/*
 * exec.c: takes an argument lists and does the "right thing" with it
 * (calls a builtin, calls a function, etc.)
 */

#include <signal.h>
#include "rc.h"
#include "utils.h"
#include "exec.h"
#include "status.h"
#include "hash.h"
#include "builtins.h"
#include "footobar.h"

extern void doredirs(void);

void exec(List *s, enum cp chpt) {
	char **av = list2array(s, dashex);
	char **ev = makeenv();
	int pid, stat;
	builtin_t *b;
	char *path = NULL;
	void (*handler)(int);
	enum bool forked;

	if (*av == NULL	/* null command or    */
	|| **av == '/'	/* absolute path name */
        || (**av == '.'
	    && ((*av)[1] == '/'
            || ((*av)[1] == '.' && (*av)[2] == '/'))))
		b = NULL;
	else if (fnlookup(*av) != NULL)
		b = function;
	else
		b = isbuiltin(*av);

	if (b == b_exec) { /* get rid of the "exec" in the arglist */
		av++;
		b = NULL;
		chpt = CHILD;
	}

	if (b == NULL) {
		path = which(*av);
		if (path == NULL && *av != NULL) { /* perform null commands for redirections */
			fprint(2,"%s not found\n",*av);
			setfalse();
			redirq = NULL;
			nullify_fifoq();
			if (chpt == PARENT)
				return;
			rc_exit(1);
		}
	}

	/* if parent & the redirq is nonnull, builtin or not it has to fork. */

	if (chpt == PARENT && (b == NULL || redirq != NULL)) {
		pid = fork();
		forked = TRUE;
	} else {
		pid = 0;
		forked = FALSE;
	}

	if (pid < 0) {
		uerror("fork");
		rc_error(NULL);
	}

	if (pid == 0) {
		if (forked)
			setsigdefaults();
		doredirs();

		/* null commands performed for redirections */
		if (*av == NULL || b != NULL) {
			if (b != NULL)
				b(av);
			if (!forked)
				return;
			rc_exit(getstatus());
		}
		execve(path,(const char **)av,(const char **)ev);
		uerror(*av);
		rc_exit(1);
	} else {
		handler = signal(SIGINT, SIG_IGN);
		if (handler != sig)
			signal(SIGINT, handler);
		posn = CRITICAL;
		while (pid != wait(&stat))
			if (pid < 0)
				uerror("wait");
		signal(SIGINT, handler);
		posn = TOPLEV;
		redirq = NULL;
		nullify_fifoq();
		setstatus(stat);
		if (stat == SIGINT) { /* interrupted? let the handler deal with it. */
			posn = OK; /* suppress the newline that the handler prints */
			sig(SIGINT);
		}
	}
}
