/* heredoc.c: heredoc slurping is done here */

#include "rc.h"
#include "lex.h"
#include "utils.h"
#include "nalloc.h"
#include "heredoc.h"
#include "tree.h"
#include "input.h"
#include "hash.h"
#include "glom.h"

struct Hq {
	Node *doc;
	char *name;
	Hq *n;
} *hq;

extern char dnw[]; /* for scanning in variables */

static int j,bufsize;

char *renalloc(char *buf, int n) {

	while (n >= bufsize - 2)
		bufsize *= 2;

	return memcpy(nalloc(bufsize), buf, j);
}

static char *readheredoc(char *eof) {
	int i,c,markerlen,varsize = 0;
	char *buf, *varname = NULL, *newvarname;
	boolean notquoted = TRUE;
	List *var;

	if (*eof == '\'') {
		notquoted = FALSE;
		eof++;
	}

	markerlen = strlen(eof);

	bufsize = 512;
	buf = nalloc(bufsize);
	j = 0;

	while (1) {
		for (i = 0, c = gchar(); eof[i] == c && i < markerlen; i++)
			c = gchar();

		if (i == markerlen && c == '\n') {
			buf[j] = 0;
			return buf;
		}

		if (i > 0) {
			if (i + j >= bufsize - 2)
				buf = renalloc(buf, i + j);
			memcpy(buf + j, eof, i);
			j += i;
		}

		do {
			if (c == EOF)
				rc_error("EOF inside heredoc");
			if (j >= bufsize - 2)
				buf = renalloc(buf, j);
			if (notquoted && c == '$') {
				if ((c = gchar()) == '$' || dnw[c]) {
					if (c != '$') /* $$ quotes $, but $<nonalnum> is transcribed literally */
						buf[j++] = '$';
					buf[j++] = c;
				} else {
					if (varsize == 0) {
						varname = nalloc(16);
						varsize = 16;
					}
					for (i = 0; !dnw[c]; i++, c = gchar()) {
						if (i >= varsize - 1) {
							newvarname = nalloc(varsize *= 4);
							memcpy(newvarname, varname, i);
							varname = newvarname;
						}
						varname[i] = c;
					}
					varname[i] = '\0';
					if (c != '^')
						ugchar(c);
					if ((var = flatten(varlookup(varname))) != NULL) {
						i = strlen(var->w);
						while (j + i >= bufsize - 2)
							buf = renalloc(buf, i + j);
						j += i;
					}
				}
			} else {
				buf[j++] = c;
			}
		} while ((c = gchar()) != '\n');

		buf[j++] = c;
	}
}

void heredoc(int end) {
	if (end && hq != NULL)
		rc_error("EOF on command line with heredoc");

	for (; hq != NULL; hq = hq->n) {
		hq->doc->u[0].i = HERESTRING;
		hq->doc->u[2].p = newnode(rWORD,readheredoc(hq->name), NULL);
	}
}

void qdoc(int fd, Node *name, Node *n) {
	Hq *new;

	if (name->type != rWORD)
		scanerror("eof-marker must be a single word");

	if (hq == NULL) {
		new = hq = nnew(Hq);
	} else {
		for (new = hq; new->n != NULL; new = new->n)
			;
		new->n = nnew(Hq);
		new = new->n;
	}

	new->name = name->u[0].s;
	new->doc = n;
	new->n = NULL;
}
