/* open.c: to insulate <fcntl.h> from the rest of rc. */

#include <fcntl.h>
#include "lex.h"
#include "open.h"

/* prototype for open() follows. comment out if necessary */

#ifndef hpux
extern int open(const char *, int, int);
#endif

extern void rc_error(const char *);

int rc_open(const char *name, enum redirtype m) {
	switch (m) {
	case FROM:
		return open(name, O_RDONLY, 0);
	case CREATE:
		return open(name, O_TRUNC | O_CREAT | O_WRONLY, 0644);
	case APPEND:
		return open(name, O_APPEND | O_CREAT | O_WRONLY, 0644);
	default:
		rc_error("bad mode passed to rc_open");
		return -1; /* provide return value for gcc -Wall */
	}
}
