#include "actions.h"
#include "jhtml.h"
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
void DelActionFrom(char *filename, char *type, char *name)
{
	char	action[50];
	char	buf[150];
	FILE * fp;
	int	i, buflen;
	sprintf(action, "%s=%s&", type, escape_string(name,"% ?+&="));
	if ((fp = fopen(filename, "r+")) == NULL) {
     sprintf(buf,"<FONT COLOR=RED> Cant open the file %s</FONT>",filename);
         ShowFrErr(buf);
		fclose(fp);
		return;
	}
	if (!FindInStream(fp, action)) {
		fclose(fp);
		return;
	}
	fseek(fp, -strlen(action), SEEK_CUR);
	buflen = FindInStream(fp, "\n\n");
	fseek(fp, -buflen, SEEK_CUR);
	for (i = 0; i < buflen; i++) 
		putc(8, fp);
	fclose(fp);
	return;
}


void WriteActionTo(char *filename, Form *this)
{
	char	buf[150];
	FILE * fp;
	Form * sledo = this;
	char	*fname, *value;
	if ((fp = fopen(filename, "a+")) == NULL) {
		sprintf(buf, "<FONT COLOR=RED> Cant open the file %s</FONT>", filename);
		ShowFrErr(buf);
	}
	while (sledo != NULL) {
		fname = escape_string(sledo->field,"% ?+&=");
		value = escape_string(sledo->val,"% ?+&=");
		fprintf(fp, "%s=%s", fname?fname:"", value?value:"");
		if(fname) free(fname);
		if(value) free(value);
		if (sledo->next != NULL)
			fprintf(fp, "&");
		sledo = sledo->next;
	}
	fprintf(fp, "\n\n");
	fclose(fp);
	sprintf(buf, "<FONT COLOR=DARKGREEN> Saved file %s</FONT>", filename);
	ShowFrErr(buf);
}


Form *GetActionFrom(char *filename, char *type, char *name)
{
	char	action[50];
	char	buf[150];
	FILE * fp;
	int     buflen;
	Form * ret;
	char	*string;
	sprintf(action, "%s=%s&", type, escape_string(name,"% ?+&="));
	if ((fp = fopen(filename, "r")) == NULL) {
		sprintf(buf, "<FONT COLOR=RED> Cant open the file %s</FONT>", filename);
		ShowFrErr(buf);
	}
	if (!FindInStream(fp, action)) {
		sprintf(buf, "<FONT COLOR=RED> Cant find %s %s in file %s</FONT>",
		    type, name, filename);
		ShowFrErr(buf);
	}
	fseek(fp, -strlen(action), SEEK_CUR);
	buflen = FindInStream(fp, "\n\n");
	fseek(fp, -buflen, SEEK_CUR);
	string = (char *)malloc(sizeof(char)*buflen + 1);
	fread(string, sizeof(char), buflen - 2, fp);
	string[buflen-1] = '\0';
	ret = AppendFromString(string, 0);
        fclose(fp);
	return ret;
}


char	**GetActionList(char *filename, char *type)
{
	char	action[50];
	char	buf[150];
	FILE * fp;
	int	i, buflen, j = 0;
	char	**ret = NULL;
        char a,b;
	sprintf(action, "%s=", type);
	if ((fp = fopen(filename, "r")) == NULL) {
		sprintf(buf, "<FONT COLOR=RED> Cant open the file %s</FONT>", filename);
		ShowFrErr(buf);
	}
	while (FindInStream(fp, action)) {
		buflen = FindInStream(fp, "&");
		fseek(fp, -buflen, SEEK_CUR);
                if(ret)
		ret = (char **)realloc(ret, sizeof(char * )*(j + 2));
                else
		ret = (char **)malloc(sizeof(char * )*(j + 2));
		ret[j] = (char *)malloc(sizeof(char)*(buflen + 1));
		for (i = 0; i < buflen - 1; i++) {
			ret[j][i] = getc(fp);
			if (ret[j][i] == '%') {
                                a=getc(fp);
                                b=getc(fp);
				ret[j][i] = deco(a,b);
				buflen = buflen - 2;
			}
		}
		ret[j][i] = '\0';
		j++;
	}
	if (j)
		ret[j] = (char * )NULL;
	return ret;
}


char	**GetAllActions(char *filename)
{
	char	action[100];
	char	buf[150];
	char	type[4][10] = {
		"Input", "Output", "Group", "Report"	};
	FILE * fp;
	int	m, k, i, buflen, j = 0;
	char	**ret = NULL;
	for (k = 0; k < 4; k++) {
		sprintf(action, "%s=", type[k]);
		if ((fp = fopen(filename, "r")) == NULL) {
			sprintf(buf, "<FONT COLOR=RED> Cant open the file %s</FONT>", filename);
			ShowFrErr(buf);
		}
		while (FindInStream(fp, action)) {
			buflen = FindInStream(fp, "&");
			fseek(fp, -buflen, SEEK_CUR);
                if(ret)
		ret = (char **)realloc(ret, sizeof(char * )*(j + 2));
                else
		ret = (char **)malloc(sizeof(char * )*(j + 2));
			ret[j] = (char *)malloc(sizeof(char)*(buflen + 3 + strlen(type[k])));
			for (m = 0; m < strlen(type[k]); m++) 
				ret[j][m] = type[k][m];
			ret[j][m] = ' ';
			for (i = m + 1; i < m + buflen; i++) {
				ret[j][i] = getc(fp);
				if (ret[j][i] == '%') {
					ret[j][i] = deco(getc(fp), getc(fp));
					buflen = buflen - 2;
				}
			}
			ret[j][i] = '\0';
			j++;
		}
	}
	if (j)
		ret[j] = (char * )NULL;
	return ret;
}


void SortActionsOfGroup(char **fields, GRPH *this)
{
	GRPB * that;
	int	ok, i, j = 0;
	char	*ptr;
	if (this == (GRPH * )NULL) 
		return;
	for (that = this->list; that; that = that->next) {
		for (ok = 0, i = 0;fields && fields[i]; i++)
			if (mystrcmp(that->name, fields[i]) == 0) {
				ok = 1;
				break;
			}
		if (ok == 0) 
			that->which = -1;
	}
	for (j = 0, that = this->list; that; that = that->next) {
		if (that->which == -1) 
			continue;
		for (i = j; fields && fields[i]; i++) {
			if (mystrcmp(that->name, fields[i]) == 0) {
				ptr = fields[i];
				fields[i] = fields[j];
				fields[j] = ptr;
				j++;
				break;
			}
		}
	}
}


INPH *ReadInput(Form *this)
{
	INPH * ret = (INPH * )malloc(sizeof(INPH));
	INPB * lst;
	Form * sledo = Field(this, "Wh");
	/* Create header part of Input list */
	if (this == (Form * )NULL) 
		return (INPH * )NULL;
	ret->name = Value(this, "Input");
	ret->host = Value(this, "Host");
	ret->database = Value(this, "WHICH");
	ret->DB = Value(this, "DB");
	ret->table = Value(this, "Table");
	ret->subname = Value(this, "Submit");
	ret->insfile = Value(this, "Html");
	ret->confirm = Value(this, "Confirm");
	ret->passfile = Value(this, "Passfile");
	ret->passfield = Value(this, "Pass");
	ret->style = matoi(Value(this, "format"));
	ret->border = matoi(Value(this, "border"));
	/* Create the bottom part of Input list */
	ret->list = (INPB * )malloc(sizeof(INPB));
	lst = ret->list;
	while (sledo != NULL) {
		lst->which = matoi(Value(sledo, "Wh"));
		lst->type = matoi(Value(sledo, "Tp"));
		lst->fldtype = matoi(Value(sledo, "TPF"));
		lst->fldsize = matoi(Value(sledo, "SZF"));
		lst->size = matoi(Value(sledo, "Sz"));
		lst->name = Value(sledo, "FN");
		lst->title = Value(sledo, "Tt");
		lst->def = Value(sledo, "Df");
		lst->defstyle = matoi(Value(sledo, "Dff"));
		lst->selstyle = matoi(Value(sledo, "St"));
		lst->vals = LfValues(Value(sledo, "Cm"));
		lst->brk = matoi(Value(sledo, "Ly"));
		lst->colspan = matoi(Value(sledo, "Cs"));
		lst->rowspan = matoi(Value(sledo, "Rs"));
		if ((sledo = sledo->next) != NULL) {
			if ((sledo = Field(sledo, "Wh")) == NULL) {
				lst->next = NULL;
				return ret;
			}
			lst->next = (INPB * )malloc(sizeof(INPB));
			lst = lst->next;
		} else {
			lst->next = NULL;
			return ret;
		}
	}
	return (INPH * )NULL;
}


void SortInput(INPH *this)
{
	INPB * lst = this->list;
	INPB * *sledo = &(this->list);
	INPB * fkp;
	int	k, j, i = 0;
	/*setvbuf(stdout,NULL,_IONBF,0);*/
	while (lst != NULL) {
		lst = lst->next; 
		i++;
	}
	for (j = i - 1; j > 0; j--) {
		for (k = 0; k < j; k++) {
			if ((((*sledo)->which > ((*sledo)->next)->which) && 
			    ((*sledo)->next)->which) || (*sledo)->which == 0) {
				fkp = *sledo;
				*sledo = (*sledo)->next;
				fkp->next = (*sledo)->next;
				(*sledo)->next = fkp;
			}
			sledo = &((*sledo)->next);
		}
		sledo = &(this->list);
	}
}


OUTH *ReadOutput(Form *this)
{
	OUTH * ret = (OUTH * )malloc(sizeof(OUTH));
	OUTB * lst;
	Form * sledo = Field(this, "Wh");
	/* Create header part of Input list */
	if (this == (Form * )NULL) 
		return (OUTH * )NULL;
	ret->name = Value(this, "Output");
	ret->host = Value(this, "Host");
	ret->database = Value(this, "WHICH");
	ret->DB = Value(this, "DB");
	ret->table = Value(this, "Table");
	ret->subname = Value(this, "Submit");
	ret->insfile = Value(this, "Html");
	ret->style = matoi(Value(this, "format"));
	ret->border = matoi(Value(this, "border"));
	/* Create the bottom part of Output list */
	ret->list = (OUTB * )malloc(sizeof(OUTB));
	lst = ret->list;
	while (sledo != NULL) {
		lst->which = matoi(Value(sledo, "Wh"));
		lst->type = matoi(Value(sledo, "Tp"));
		lst->fldtype = matoi(Value(sledo, "TPF"));
		lst->fldsize = matoi(Value(sledo, "SZF"));
		lst->name = Value(sledo, "FN");
		lst->title = Value(sledo, "Tt");
		lst->vals = LfValues(Value(sledo, "Cm"));
		lst->brk = matoi(Value(sledo, "Ly"));
		lst->colspan = matoi(Value(sledo, "Cs"));
		lst->rowspan = matoi(Value(sledo, "Rs"));
		if ((sledo = sledo->next) != NULL) {
			if ((sledo = Field(sledo, "Wh")) == NULL) {
				lst->next = NULL;
				return ret;
			}
			lst->next = (OUTB * )malloc(sizeof(OUTB));
			lst = lst->next;
		} else {
			lst->next = NULL;
			return ret;
		}
	}
	return (OUTH * )NULL;
}



void SortOutput(OUTH *this)
{
	OUTB * lst = this->list;
	OUTB * *sledo = &(this->list);
	OUTB * fkp;
	int	k, j, i = 0;
	/*setvbuf(stdout,NULL,_IONBF,0);*/
	while (lst != NULL) {
		lst = lst->next; 
		i++;
	}
	for (j = i - 1; j > 0; j--) {
		for (k = 0; k < j; k++) {
			if ((((*sledo)->which > ((*sledo)->next)->which) && 
			    ((*sledo)->next)->which) || (*sledo)->which == 0) {
				fkp = *sledo;
				*sledo = (*sledo)->next;
				fkp->next = (*sledo)->next;
				(*sledo)->next = fkp;
			}
			sledo = &((*sledo)->next);
		}
		sledo = &(this->list);
	}
}


FINDH *ReadSearch(Form *this)
{
	FINDH * ret = (FINDH * )malloc(sizeof(FINDH));
	FINDB * lst;
	Form * sledo = Field(this, "Wh");
	/* Create header part of Search list */
	if (this == (Form * )NULL) 
		return (FINDH * )NULL;
	ret->name = Value(this, "Search");
	ret->host = Value(this, "Host");
	ret->database = Value(this, "WHICH");
	ret->DB = Value(this, "DB");
	ret->table = Value(this, "Table");
	ret->subname = Value(this, "Submit");
	ret->insfile = Value(this, "Html");
	ret->confirm = Value(this, "Confirm");
	ret->style = matoi(Value(this, "format"));
	ret->border = matoi(Value(this, "border"));
	ret->braces = matoi(Value(this, "braces"));
	ret->order = Value(this, "ORD");
	ret->sens = matoi(Value(this, "CST"));
	ret->every = matoi(Value(this, "NRP"));
	/* Create the bottom part of Search list */
	ret->list = (FINDB * )malloc(sizeof(FINDB));
	lst = ret->list;
	while (sledo != NULL) {
		lst->which = matoi(Value(sledo, "Wh"));
		lst->p1 = matoi(Value(sledo, "P1"));
		lst->fldtype = matoi(Value(sledo, "TPF"));
		lst->fldsize = matoi(Value(sledo, "SZF"));
		lst->type = matoi(Value(sledo, "Tp"));
		lst->name = Value(sledo, "FN");
		lst->title = Value(sledo, "Tt");
		lst->defcond = matoi(Value(sledo, "Dfc"));
		lst->def = Value(sledo, "Df");
		lst->defstyle = matoi(Value(sledo, "Dff"));
		lst->selstyle = matoi(Value(sledo, "St"));
		lst->vals = LfValues(Value(sledo, "Cm"));
		lst->p2 = matoi(Value(sledo, "P2"));
		lst->defties = matoi(Value(sledo, "Dfti"));
		if ((sledo = sledo->next) != NULL) {
			if ((sledo = Field(sledo, "Wh")) == NULL) {
				lst->next = NULL;
				return ret;
			}
			lst->next = (FINDB * )malloc(sizeof(FINDB));
			lst = lst->next;
		} else {
			lst->next = NULL;
			return ret;
		}
	}
	return (FINDH * )NULL;
}



void SortSearch(FINDH *this)
{
	FINDB * lst = this->list;
	FINDB * *sledo = &(this->list);
	FINDB * fkp;
	int	k, j, i = 0;
	/*setvbuf(stdout,NULL,_IONBF,0);*/
	while (lst != NULL) {
		lst = lst->next; 
		i++;
	}
	for (j = i - 1; j > 0; j--) {
		for (k = 0; k < j; k++) {
			if ((((*sledo)->which > ((*sledo)->next)->which) && 
			    ((*sledo)->next)->which) || (*sledo)->which == 0) {
				fkp = *sledo;
				*sledo = (*sledo)->next;
				fkp->next = (*sledo)->next;
				(*sledo)->next = fkp;
			}
			sledo = &((*sledo)->next);
		}
		sledo = &(this->list);
	}
}


void CheckSearch(FINDH *this)
{
	FINDB * lst = this->list;
	int	count = 0;
	if (LTrim(this->name) == NULL)
		ShowFrErr("<FONT COLOR=RED> Search form must have name </FONT>");
	if (lst->which == 0)
		ShowFrErr("<FONT COLOR=RED> Nothing to do ! </FONT>");
	while (lst != NULL && lst->which) {
		if (lst->defstyle == 2 && TimeFromString(lst->def) == 0) 
			lst->def = NULL;
		count = count + (lst->p1) - (lst->p2);
		if ((lst->defstyle == 1) && (LTrim(lst->def) == NULL))
			ShowFrErr("<FONT COLOR=RED> Import default field must have name </FONT>");
		lst = lst->next;
	}
	if (count != 0)
		ShowFrErr("<FONT COLOR=RED> Braces mismatch </FONT>");
}


void CheckInput(INPH *this)
{
	INPB * lst = this->list;
	if (LTrim(this->name) == NULL)
		ShowFrErr("<FONT COLOR=RED> Input form must have name </FONT>");
	if (LTrim(this->subname) == NULL)
		ShowFrErr("<FONT COLOR=RED> Input form must have name for the submit button</FONT>");
	if (lst->which == 0)
		ShowFrErr("<FONT COLOR=RED> Nothing to do ! </FONT>");
	while (lst != NULL && lst->which) {
		if ((lst->defstyle == 1) && (LTrim(lst->def) == NULL))
			ShowFrErr("<FONT COLOR=RED> Import default field must have name </FONT>");
		lst = lst->next;
	}
}


void CheckOutput(OUTH *this)
{
	OUTB * lst = this->list;
	if (LTrim(this->name) == NULL)
		ShowFrErr("<FONT COLOR=RED> Output form must have name </FONT>");
	if (lst->which == 0)
		ShowFrErr("<FONT COLOR=RED> Nothing to do ! </FONT>");
	while (lst != NULL && lst->which) {
		lst = lst->next;
	}
}


void CheckGroup(GRPH *this)
{
	GRPB * lst = this->list;
	if (LTrim(this->name) == NULL)
		ShowFrErr("<FONT COLOR=RED> Group must have name </FONT>");
	if (lst->which == 0)
		ShowFrErr("<FONT COLOR=RED> Nothing to do ! </FONT>");
	while (lst != NULL && lst->which) {
		if (LTrim(lst->title) == NULL)
			ShowFrErr("<FONT COLOR=RED> Action must have submit name</FONT>");
		lst = lst->next;
	}
}


void CheckReport(REPORT *this)
{
	if (LTrim(this->name) == NULL)
		ShowFrErr("<FONT COLOR=RED> Report must have name </FONT>");
	if (LTrim(this->subname) == NULL)
		ShowFrErr("<FONT COLOR=RED> Report must have name for the submit button</FONT>");
	if (mystrcmp(this->act1, "No Action") != 0 && LTrim(this->tact1) == NULL)
		ShowFrErr("<FONT COLOR=RED> Action must have submit name </FONT>");
	if (mystrcmp(this->act2, "No Action") != 0 && LTrim(this->tact2) == NULL)
		ShowFrErr("<FONT COLOR=RED> Action must have submit name </FONT>");
}
GRPH *ReadGroup(Form *this)
{
	GRPH * ret = (GRPH * )malloc(sizeof(GRPH));
	GRPB * lst;
	Form * sledo = Field(this, "Wh");
	/* Create header part of Input list */
	if (this == (Form * )NULL) 
		return (GRPH * )NULL;
	ret->name = Value(this, "Group");
	ret->subname = Value(this, "Submit");
	ret->insfile = Value(this, "Html");
	ret->style = matoi(Value(this, "format"));
	ret->border = matoi(Value(this, "border"));
	/* Create the bottom part of Output list */
	ret->list = (GRPB * )malloc(sizeof(GRPB));
	lst = ret->list;
	while (sledo != NULL) {
		lst->which = matoi(Value(sledo, "Wh"));
		lst->name = Value(sledo, "FN");
		lst->title = Value(sledo, "Tt");
		lst->descrip = Value(sledo, "Descr");
		if ((sledo = sledo->next) != NULL) {
			if ((sledo = Field(sledo, "Wh")) == NULL) {
				lst->next = NULL;
				return ret;
			}
			lst->next = (GRPB * )malloc(sizeof(GRPB));
			lst = lst->next;
		} else {
			lst->next = NULL;
			return ret;
		}
	}
	return (GRPH * )NULL;
}

void FreeGroup(GRPH *group)
{
	GRPB * this=group->list;
	GRPB * sledo;
  while (this) {
    sledo = this->next;
    free(this);
    this = sledo;
  }
free(group);
}


void SortGroup(GRPH *this)
{
	GRPB * lst = this->list;
	GRPB * *sledo = &(this->list);
	GRPB * fkp;
	int	k, j, i = 0;
	while (lst != NULL) {
		lst = lst->next; 
		i++;
	}
	for (j = i - 1; j > 0; j--) {
		for (k = 0; k < j; k++) {
			if ((((*sledo)->which > ((*sledo)->next)->which) && 
			    ((*sledo)->next)->which) || (*sledo)->which == 0) {
				fkp = *sledo;
				*sledo = (*sledo)->next;
				fkp->next = (*sledo)->next;
				(*sledo)->next = fkp;
			}
			sledo = &((*sledo)->next);
		}
		sledo = &(this->list);
	}
}


REPORT *ReadReport(Form *this)
{
	REPORT * ret = (REPORT * )malloc(sizeof(REPORT));
	/* Create header part of Input list */
	if (this == (Form * )NULL) 
		return (REPORT * )NULL;
	ret->name = Value(this, "Report");
	ret->subname = Value(this, "Submit");
	ret->insfile = Value(this, "Html");
	ret->border = matoi(Value(this, "Border"));
	ret->search = Value(this, "Srch");
	ret->numcols = matoi(Value(this, "Numcols"));
	ret->format = Value(this, "Format");
	ret->act1 = Value(this, "Act1");
	ret->act2 = Value(this, "Act2");
	ret->tact1 = Value(this, "TAct1");
	ret->tact2 = Value(this, "TAct2");
	return ret;
}


SEARCH *ReadIISearch(Form *this)
{
	SEARCH * ret = (SEARCH * )malloc(sizeof(SEARCH));
	SERDATA * lst;
	Form * sledo = Field(this, "P1");
	/* Create header part of Input list */
	if (this == (Form * )NULL) 
		return (SEARCH * )NULL;
	ret->filename = Value(this, "FILENAME");
	ret->host = Value(this, "Host");
	ret->database = Value(this, "WHICH");
	ret->DB = Value(this, "DB");
	ret->table = Value(this, "Table");
	ret->order = Value(this, "ORD");
	ret->sens = matoi(Value(this, "CST"));
	ret->every = matoi(Value(this, "NRP"));
        if(Value(this, "WNRP")==NULL)
        ret->which = 0;
        else
	ret->which = matoi(Value(this, "WNRP"));
	ret->border = matoi(Value(this, "Border"));
	ret->numcols = matoi(Value(this, "Numcols"));
        ret->insfile = Value(this, "Insfile");
	ret->format = Value(this, "Format");
	ret->act1 = Value(this, "Act1");
	ret->act2 = Value(this, "Act2");
	ret->tact1 = Value(this, "TAct1");
	ret->tact2 = Value(this, "TAct2");
	/* Create the bottom part of Input list */
	ret->list = (SERDATA * )malloc(sizeof(SERDATA));
	lst = ret->list;
	while (sledo != NULL) {
		lst->p1 = matoi(Value(sledo, "P1"));
		lst->type = matoi(Value(sledo, "Tp"));
		lst->name = Value(sledo, "FN");
		lst->cond = matoi(Value(sledo, "CND"));
		lst->val = ValuesII(sledo, "VAL");
		lst->p2 = matoi(Value(sledo, "P2"));
		lst->tie = matoi(Value(sledo, "DTIE"));
		if ((sledo = sledo->next) != NULL) {
			if ((sledo = Field(sledo, "P1")) == NULL) {
				lst->next = NULL;
				return ret;
			}
			lst->next = (SERDATA * )malloc(sizeof(SERDATA));
			lst = lst->next;
		} else {
			lst->next = NULL;
			return ret;
		}
	}
	return (SEARCH * )NULL;
}


CHANGE *ReadChange(Form *this)
{
	CHANGE * ret = (CHANGE * )malloc(sizeof(CHANGE));
	ADD * lsta;
	Form * sledo = Field(this, "FN");
	/* Create header part of Input list */
	if (this == (Form * )NULL || sledo == (Form * )NULL) 
		return (CHANGE * )NULL;
	ret->host = Value(this, "Host");
	ret->database = Value(this, "WHICH");
	ret->DB = Value(this, "DB");
	ret->table = Value(this, "Table");
	ret->confirm = Value(this, "Confirm");
	ret->passfile = Value(this, "Passfile");
	/* Create the bottom part of Input list */
	ret->adds = (ADD * )malloc(sizeof(ADD));
	lsta = ret->adds;
	while (sledo != NULL) {
		lsta->name = Value(sledo, "FN");
		lsta->type = matoi(Value(sledo, "TPF"));
		lsta->val = Value(sledo, "FV");
		if ((sledo = sledo->next) != NULL) {
			if ((sledo = Field(sledo, "FN")) == NULL) {
				lsta->next = NULL;
				break;
			}
			lsta->next = (ADD * )malloc(sizeof(ADD));
			lsta = lsta->next;
		} else {
			lsta->next = NULL;
			return ret;
		}
	}
	return ret;
}


/***                   ***/
/* **************** WRITE IN FILE ******************* */
/***     START        ***/


void WriteImputInFile(Form *this)
{
	Form * setup = ReadInFormJcookie("SETTINGS");
	char	*filename = Value(setup, "FILE");
	DelActionFrom(filename, "Input", Value(this, "Input"));
	WriteActionTo(filename, this);
	exit(0);
}


void WriteOutputInFile(Form *this)
{
	Form * setup = ReadInFormJcookie("SETTINGS");
	char	*filename = Value(setup, "FILE");
	DelActionFrom(filename, "Output", Value(this, "Output"));
	WriteActionTo(filename, this);
	exit(0);
}


void WriteSearchInFile(Form *this)
{
	Form * setup = ReadInFormJcookie("SETTINGS");
	char	*filename = Value(setup, "FILE");
	DelActionFrom(filename, "Search", Value(this, "Search"));
	WriteActionTo(filename, this);
	exit(0);
}


void WriteGroupInFile(Form *this)
{
	Form * setup = ReadInFormJcookie("SETTINGS");
	char	*filename = Value(setup, "FILE");
	DelActionFrom(filename, "Group", Value(this, "Group"));
	WriteActionTo(filename, this);
	exit(0);
}


void WriteReportInFile(Form *this)
{
	Form * setup = ReadInFormJcookie("SETTINGS");
	char	*filename = Value(setup, "FILE");
	DelActionFrom(filename, "Report", Value(this, "Report"));
	WriteActionTo(filename, this);
	exit(0);
}


/***        END        ***/
/* **************** WRITE IN FILE ******************* */
/***                   ***/

/***                   ***/
/* **************** PRE ACTION  ******************* */
/***     START        ***/





/***                   ***/
/* **************** DRAW ACTION  ******************* */
/***     START        ***/

/* **************** DRAW INPUT  ******************* */

void DrawImput(Form *this, INPH *input, int add)
{
	int	j, i = 0;
	int	br = 0;
	INPB * lst;
	char	*str;
	if (input->style == 2) {
		printf("<TABLE BORDER=\"%d\" CELLSPACING=2 CELLPADDING=2>",
		    input->border);
		printf("<TR>");
	}
	if (add == 0)
		for (lst = input->list, add = 0;lst && lst->which; lst = lst->next) 
			if (lst->defstyle == 1) 
				add++;
	lst = input->list;
	printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"ToDo\">\n", add ? "ADD" : "UPDATE");
	printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"%s\">\n", input->database, "WHICH");
	printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"%s\">\n", input->host, "Host");
	printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"%s\">\n", input->DB, "DB");
	printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"%s\">\n", input->table, "Table");
	printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"%s\">\n", input->confirm?input->confirm:"", "Confirm");
	printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"%s\">\n", input->passfile?input->passfile:"", "Passfile");
	while (lst && lst->which) {
		if (input->style == 2 && (lst->type != 3)) {
			if (br) 
				printf("</TR><TR>\n");
			printf("<TD COLSPAN=%d ROWSPAN=%d>", lst->colspan, lst->rowspan);
		}
		printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"FN\">\n", lst->name);
		if ((lst->type == 0) && (lst->defstyle == 2))
			printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%d\" NAME=\"TPF\">\n", 8);
		else
			printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%d\" NAME=\"TPF\">\n", lst->fldtype);
		if (lst->type == 0) {
			printf(" <B>%s</B> \n", lst->title?lst->title:"");
			if (lst->defstyle == 1)
				printf("<INPUT TYPE=\"TEXT\" VALUE=\"%s\" NAME=\"FV\" SIZE=%d>\n",
				    Value(this, lst->def)?Value(this, lst->def):"", lst->size);
			else if (lst->defstyle == 2) {
	     if (TimeFromString(lst->def))
	    printf("<INPUT TYPE=\"TEXT\" VALUE=\"%s\" NAME=\"FV\" SIZE=8>\n",
      add ? CharTime(TimeFromString(lst->def)) : CharTime(matol(Value(this, lst->name))));
				else
   printf("<INPUT TYPE=\"TEXT\" VALUE=\"%s\" NAME=\"FV\" SIZE=8>\n",
      add ? "dd/mm/yy" : CharTime(matol(Value(this, lst->name))));
			} else if (lst->vals && (lst->vals)[0]) {
				if (lst->selstyle == 0) {
					printf("<select name = \"FV\">\n");
					for (i = 0;lst->vals && (lst->vals)[i]; i++) {
						if (lst->fldtype == 2)
							printf("<option value=\"%s\" %s >",
							    (lst->vals)[i], (add == 0 && mystrcmp((lst->vals)[i], Value(this, lst->name))
							    == 0) ? "selected" : "");
						else 
							printf("<option value=\"%d\" %s >",
							    i, (add == 0 && i == matoi(Value(this, lst->name))) ? "selected" :
							    "");
						printf(" %s\n", (lst->vals)[i]);
					}
					printf("</select><Br>\n");
				} else {
					for (i = 0;lst->vals && (lst->vals)[i]; i++) {
						printf("<INPUT TYPE=radio NAME=\"FV\" ");
						if (lst->fldtype == 2)
							printf("VALUE=\"%s\" %s > %s<br>\n",
							    (lst->vals)[i],
							    (add == 0 && mystrcmp((lst->vals)[i], Value(this, lst->name)) == 0)
							    ? "selected" : "", (lst->vals)[i]);
						else
							printf("VALUE=\"%d\" %s > %s<br>\n",
							    i, (add == 0 && i == matoi(Value(this, lst->name))) ? "selected" :
							    "", (lst->vals)[i]);
					}
				}
			} else {
                                if(add)
				printf("<INPUT TYPE=\"TEXT\" VALUE=\"%s\" NAME=\"FV\" SIZE=%d>\n",
				    lst->def?lst->def:"", lst->size);
                                else
				printf("<INPUT TYPE=\"TEXT\" VALUE=\"%s\" NAME=\"FV\" SIZE=%d>\n",
				    Value(this, lst->name)?Value(this, lst->name):"", lst->size);
			}
		} else if (lst->type == 1) {                   /* TEXTAREA */
			printf(" <B>%s</B> \n", lst->title?lst->title:"");
			str = BackToLfs(lst->vals);
                        if(add)
			printf("<TEXTAREA NAME=\"FV\" ROWS=5 COLS=%d> %s </TEXTAREA>\n",
			    lst->size,str?str:"");
                        else
			printf("<TEXTAREA NAME=\"FV\" ROWS=5 COLS=%d> %s </TEXTAREA>\n",
			    lst->size,Value(this, lst->name)?Value(this, lst->name):"");
			if(str) free(str);
		} else if (lst->type == 2) {           /* READ ONLY */
			printf(" <B>%s</B> \n", lst->title);
			if (add) {
				if (lst->defstyle == 1) {
					printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"FV\">\n",
					    Value(this, lst->def)?Value(this, lst->def):"");
					printf("%s\n", Value(this, lst->def)?Value(this, lst->def):"");
				} else {
					printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"");
                                        if(lst->defstyle == 2)
					  {
                                          if(add>10) printf("date"); else printf("%ld",time(NULL));
					  } else printf("%s",lst->def?lst->def:"");
                                         printf("\" NAME=\"FV\">\n");
                                         if(lst->defstyle == 2)
					printf("%s\n",CharTime(time(NULL)));
                                         else
					printf("%s\n",lst->def);
				}
			} else {
				printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"FV\">\n",
				    Value(this, lst->name)?Value(this, lst->name):"");
				if (lst->vals && (lst->vals)[i] && lst->fldtype == 1 && lst->defstyle != 2)
					printf(" %s\n", (lst->vals)[matoi(Value(this,lst->name))]);
				else
                                       if(lst->defstyle == 2)
					printf("%s\n",CharTime(matol(Value(this, lst->name))));
                                         else
					printf("%s\n",Value(this,lst->name));
			}
		} else if (lst->type == 3) {                        /* HIDDEN */
			if (lst->defstyle == 1)
				printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"FV\">\n",
				    Value(this,lst->def)?Value(this,lst->def):"");
			else if (lst->defstyle == 2) {
				printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"");
                               if(add>10) printf("date"); else printf("%ld",time(NULL));
                                 printf("\" NAME=\"FV\">\n");
			}
			  else
                              if(lst->def)
				printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"FV\">\n",
				  lst->def);
                                else
				printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"FV\">\n",
				    Value(this, lst->name)?Value(this, lst->name):"");
		}
		if (input->style == 2) {
			if (lst->brk) 
				br = 1;
			else 
				br = 0;
		} else if (input->style == 1) {
			printf("<NOBR>\n");
		} else if (input->style == 0) {
			printf("<Br>\n");
		}
		if (input->style == 2 && (lst->type != 3)) 
			printf("</TD>");
		lst = lst->next;
	}
	if (input->style == 2) 
		printf("</TR></TABLE>\n");
}



/* **************** DRAW OUTPUT ****************** */



void DrawOutput(Form *this, OUTH *input, int see)
{
	int	br = 0;
	OUTB * lst;
	if (input->style == 2) {
		printf("<TABLE ALIGN=\"CENTER\" BORDER=\"%d\" CELLSPACING=2 CELLPADDING=2>",
		    input->border);
		printf("<TR>");
	}
	lst = input->list;
	while (lst && lst->which) {
		if (input->style == 2 && (lst->type != 1 || this == (Form * )NULL)) {
			if (br) 
				printf("</TR><TR>\n");
			printf("<TD COLSPAN=%d ROWSPAN=%d>", lst->colspan, lst->rowspan);
		} else if(input->style != 1) puts("<Br>");
		if (see == 1 && input->style == 1 && lst->type != 1) 
			puts("<TD>");
		if (this != NULL)
			{ if (lst->type != 1 && (see == 0 || input->style != 1))
			  printf(" <B><Br>%s<Br></B> \n", lst->title?lst->title:""); }
                                 else { printf(" <B>%s</B> \n", lst->title?lst->title:"");
				 if(input->style != 1) puts("<Br>");}
		if (lst->type == 0) {
			if (this == (Form * )NULL) {
				if (lst->fldtype == 1)
					printf("%s",( lst->vals && lst->vals[0]) ? lst->vals[0] : "Int field");
				else if (lst->fldtype == 3)
					printf("Real field");
				else if (lst->fldtype == 2)
						printf("Char field length=%d",lst->fldsize);
				printf("\n");
			} else {
			  if (lst->fldtype == 1) {
                                        if(lst->vals && (lst->vals)[0])
	 printf("%s",
   lst->vals[matoi(Value(this,lst->name))]?lst->vals[matoi(Value(this,lst->name))]:"undefined");
                                        else
					printf("%s",Value(this,lst->name)?Value(this,lst->name):"");

				} else
					printf("%s", Value(this, lst->name)?Value(this, lst->name):"");
			}
		} else if (lst->type == 1) {
			if (this == (Form * )NULL)
				printf("<FONT COLOR=GREEN> Here will be hidden value of %s </FONT>\n", lst->name);
		} else if (lst->type == 2) {
			if (this == (Form * )NULL)
				printf("<A HREF=\"%s\">%s</A>\n",
				    (lst->fldtype == 1 && (lst->vals && lst->vals[0])) ? lst->vals[0] : "http://aiace.lnf.infn.it/~ht/Jate.html",
				      (lst->fldtype == 1 && (lst->vals && lst->vals[0])) ? lst->vals[0] : "http://aiace.lnf.infn.it/~ht/Jate.html");
			else
                                if(lst->fldtype == 1 && (lst->vals && lst->vals[0]))
				printf("<A HREF=\"%s\">%s</A>\n",
       lst->vals[matoi(Value(this,lst->name))]?lst->vals[matoi(Value(this,lst->name))]:"undefined",
        lst->vals[matoi(Value(this,lst->name))]?lst->vals[matoi(Value(this,lst->name))]:"undefined");
                                else
                                printf("<A HREF=\"%s\">%s</A>\n",
                                 Value(this,lst->name)?Value(this,lst->name):"",
                                      Value(this,lst->name)?Value(this,lst->name):"");
		} else if (lst->type == 3) {
			if (this == (Form * )NULL)
				printf("<A HREF=\"mailto:%s\">%s</A>\n",
				    (lst->fldtype == 1 && (lst->vals && lst->vals[0])) ? lst->vals[0] : "ht@aiace.lnf.infn.it",
				    (lst->fldtype == 1 && (lst->vals && lst->vals[0])) ? lst->vals[0] : "ht@aiace.lnf.infn.it");
			else
                              if(lst->fldtype == 1 && (lst->vals && lst->vals[0]))
     printf("<A HREF=\"mailto:%s\">%s</A>\n",
        lst->vals[matoi(Value(this,lst->name))]?lst->vals[matoi(Value(this,lst->name))]:"undefined");
                              else
     printf("<A HREF=\"mailto:%s\">%s</A>\n",Value(this,lst->name)?Value(this,lst->name):"",
                                 Value(this,lst->name)?Value(this,lst->name):"");
		} else if (lst->type == 4) {
			if (this == (Form * )NULL)
				printf(" %s\n","dd/mm/yy");            
                            else
				printf("%s\n", CharTime(matoi(Value(this, lst->name))));
		}  else if (lst->type == 5) {
			if (this == (Form * )NULL)
				printf("<IMG SRC=\"%s\">\n",
	  (lst->fldtype == 1 && (lst->vals && lst->vals[0])) ? lst->vals[0] : "/icons/image.gif");
			else
                                if(lst->fldtype == 1 && (lst->vals && lst->vals[0]))
				printf("<IMG SRC=\"%s\">\n",
      lst->vals[matoi(Value(this,lst->name))]?lst->vals[matoi(Value(this,lst->name))]:"/icons/unknown.gif");
                                else
		printf("<IMG SRC=\"%s\">\n",Value(this,lst->name)?Value(this,lst->name):"/icons/unknown.gif");
		}
		if (input->style == 2 && (lst->type != 1 || this == (Form * )NULL)) {
			printf("</TD>\n");
			if (lst->brk) 
				br = 1;
			else 
				br = 0;
		} else if (input->style == 1) {
			printf("\n");
		} else if (input->style == 0) {
			printf("<Br>\n");
		}
		lst = lst->next;
	}
	if (input->style == 2) 
		printf("</TR></TABLE>\n");
}



/* **************** DRAW GROUP  ******************* */



void DrawGroup(GRPH *input)
{
	GRPB * lst;
	printf("<TABLE BORDER=\"%d\" CELLSPACING=2 CELLPADDING=2>",
	    input->border);
	lst = input->list;
	if (input->style == 3)
		printf("<TR><TD><select name=\"Action\">\n");
	while (lst && lst->which) {
		printf("<p> <INPUT TYPE=\"hidden\" VALUE=\"%s\" NAME=\"%s\">\n", lst->name,
                  lst->title?lst->title:"");
		if (input->style == 0) {
			printf("<TR><TD>\n");
		} else if (input->style == 1) {
			printf("<TD>\n");
		} else if (input->style == 2) {
			printf("<TR><TD>\n");
		}
		if (input->style == 3) {
		printf("<option value=\"%s\"> %s", lst->title?lst->title:"", lst->title?lst->title:"");
		} else
			printf("<p> <INPUT TYPE=\"submit\" VALUE=\"%s\" NAME=\"Action\">\n", 
                                lst->title?lst->title:"");
		if (input->style == 2)
			printf("</TD><TD> %s\n", lst->descrip?lst->descrip:"");

		if (input->style == 0) {
			printf("</TD></TR>\n");
		} else if (input->style == 1) {
			printf("</TD>\n");
		} else if (input->style == 2) {
			printf("</TD></TR>\n");
		}
		lst = lst->next;
	}
	if (input->style == 1) 
		printf("</TR>\n");
	if (input->style == 3) {
		printf("</select></TD>\n");
		printf("<TD><INPUT TYPE=\"submit\" VALUE=\" OK \"></TD></TR>\n");
	}
	printf("</TABLE>\n");
}



/* **************** DRAW SEARCH  ******************* */



void DrawSearch(Form *this, FINDH *input)
{
	int	i, k;
	FINDB * lst;
	char	parentesi[50];
	int	dato = 1;
	char	*dat2;
	int	showview = 0;
	int	chf = 0;
	int	numfields = 0;
	char	*conds[9] = {
		"Like", "Equal", "More than", "Less than",
		" More or Equal ", "Less or Equal", "Not Equal", "Later than", " Before "	};
	char	dfty[3][10] = {
		" OFF ", " AND ", " OR "	};
	if (input->style == 2) {
		printf("<TABLE BORDER=\"%d\" CELLSPACING=2 CELLPADDING=2>",
		    input->border);
	}
	for (lst = input->list, numfields = 0;lst && lst->which; lst = lst->next) 
		numfields++;
	lst = input->list;
	while (lst && lst->which) {
		if (input->style == 2 && lst->type != 3) {
			printf("<TR>");
			printf("<TD COLSPAN=%d ROWSPAN=%d>", 0, 0);
		}
		switch (lst->type) {
		case 3:  /* hidden */
			if (dato)
				printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%d\" NAME=\"P1\">\n",
				    input->braces ? lst->p1 : 0);
			else
				printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%d\" NAME=\"P1\">\n", 0);
			printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"FN\">\n", lst->name);
			printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%d\" NAME=\"Tp\">\n",
                        (lst->defstyle == 2)?8:lst->fldtype);
			if (lst->defstyle == 2)
				printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%d\" NAME=\"CND\">\n", 8 - dato);
			else
				printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%d\" NAME=\"CND\">\n", lst->defcond);
			if (lst->defstyle == 2) {  /* Default is Date */

				if (dato) 
					dat2 = CutInTwo(lst->def, 1);
				if (dato) {
					printf("<INPUT TYPE=\"HIDDEN\" NAME=\"VAL\" VALUE=\"%ld\">\n",
					    TimeFromString(lst->def));
				} else {
					printf("<INPUT TYPE=\"HIDDEN\" NAME=\"VAL\" VALUE=\"%ld\">\n",
					    TimeFromString(dat2));
				}
				if (dat2 && dato) 
					dato = 0; 
				else 
					dato = 1;
			} else if (lst->defstyle == 0) {
		   printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"VAL\">\n", lst->def?lst->def:"");
			} else if (lst->defstyle == 1) {
                                if(lst->fldtype==2 && lst->defcond)
				printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"VAL\">\n", Value(this, lst->def)?Value(this, lst->def):"");
                                else
				printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"VAL\">\n", Value(this, lst->def)?Value(this, lst->def):"");
			}
			if (dato)
				printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%d\" NAME=\"P2\">\n", input->braces ? lst->p2 : 0);
			else
				printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%d\" NAME=\"P2\">\n", 0);
			if (dato)
				printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%d\" NAME=\"DTIE\">\n", lst->defties);
			else
				printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%d\" NAME=\"DTIE\">\n", 1);
			break;
		case 2:  /* read only */
			if (dato) {
				if (input->braces)
					if (lst->p1) 
						for (k = 0; k < lst->p1; k++) 
							printf("(");
					else 
						printf("Nobrace");
				printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%d\" NAME=\"P1\">\n", input->braces ? lst->p1 : 0);
			} else {
				if (input->braces) 
					printf("Nobrace");
				printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%d\" NAME=\"P1\">\n", 0);
			}
			if (input->style == 2 && input->braces)  
				printf(" </TD><TD> ");
			printf(" <B>%s</B> \n", lst->title);
			printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"FN\">\n", lst->name);
			printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%d\" NAME=\"Tp\">\n",
                          (lst->defstyle == 2)?8:lst->fldtype);
			if (input->style == 2)  
				printf(" </TD><TD> ");
			if (lst->defstyle == 2) {
				printf(" %s ", conds[8-dato]);
				printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%d\" NAME=\"CND\">\n", 8 - dato);
			} else {
				printf(" %s ", conds[lst->defcond]);
				printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%d\" NAME=\"CND\">\n", lst->defcond);
			}
			if (input->style == 2) 
				printf(" </TD><TD> ");
			if (lst->defstyle == 2) {  /* Default is Date */

				if (dato) 
					dat2 = CutInTwo(lst->def, 1);
				if (dato) {
					printf(" %s ", CharTime(TimeFromString(lst->def)));
					printf("<INPUT TYPE=\"HIDDEN\" NAME=\"VAL\" VALUE=\"%s\">\n",
					    CharTime(TimeFromString(lst->def)));
				} else {
					printf(" %s ", CharTime(TimeFromString(dat2)));
					printf("<INPUT TYPE=\"HIDDEN\" NAME=\"VAL\" VALUE=\"%s\">\n",
					    CharTime(TimeFromString(dat2)));
				}
				if (dat2 && dato) 
					dato = 0; 
				else 
					dato = 1;
			} else if (lst->defstyle == 0) {
				printf("%s\n", lst->def?lst->def:"");
				printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"VAL\">\n", lst->def?lst->def:"");
			} else if (lst->defstyle == 1) {
				printf("%s\n", Value(this, lst->def)?Value(this, lst->def):"");
                                if(lst->fldtype==2 && lst->defcond)
				printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"VAL\">\n", Value(this, lst->def)?Value(this, lst->def):"");
                                else
				printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"VAL\">\n", Value(this, lst->def)?Value(this, lst->def):"");
			}
			if (input->style == 2 && input->braces)  
				printf(" </TD><TD> ");
			if (dato) {
				if (input->braces)
					if (lst->p2) 
						for (k = 0; k < lst->p2; k++) 
							printf(")");
					else 
						printf("Nobrace");
				printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%d\" NAME=\"P2\">\n", input->braces ? lst->p2 : 0);
			} else {
				if (input->braces) 
					printf("Nobrace");
				printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%d\" NAME=\"P2\">\n", 0);
			}
			if (input->style == 2)  
				printf(" </TD><TD> ");
			if (dato) {
				printf(" %s ", dfty[lst->defties]);
				printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%d\" NAME=\"DTIE\">\n", lst->defties);
			} else {
				printf(" %s ", dfty[1]);
				printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%d\" NAME=\"DTIE\">\n", 1);
			}
			break;
		default:  /* normal */
			showview++;
			if (input->braces) {
				printf("<select name=\"P1\">\n");
				printf("<option value=\"%d\"> %s\n", 0, "Nobrace");
				for (i = 1; i < numfields; i++)
					printf("<option value=\"%d\" %s> %s\n",
					    i, ((lst->p1 == i) ? " selected " : ""), pch(parentesi, i, '('));
				printf("</select>\n");
				if (input->style == 2)  
					printf(" </TD><TD> ");
			} else 
				printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"0\" NAME=\"P1\">\n");
			printf(" <B>%s</B> \n", lst->title);
			printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"FN\">\n", lst->name);
			printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%d\" NAME=\"Tp\">\n",
                          (lst->defstyle == 2)?8:lst->fldtype);
			if (input->style == 2)  
				printf(" </TD><TD> ");
			printf("<select name=\"CND\">\n");
			if (lst->fldtype == 2)                 /*CHAR*/
				printf("<option value=\"%d\" %s> %s\n", 0, ((lst->defcond == 0) ? " selected " : ""), conds[0]);
			if (lst->defstyle == 2) {
				for (i = 7; i < 9; i++)
					printf("<option value=\"%d\" %s> %s\n", i, ((i + dato == 8) ? " selected " : ""),
					     conds[i]);
			} else
				for (i = 1; i < 7; i++)
					printf("<option value=\"%d\" %s> %s\n", i, ((lst->defcond == i) ? " selected " :
					    ""), conds[i]);
			printf("</select>");
			if (input->style == 2) 
				printf(" </TD><TD> ");
			if (lst->defstyle == 2) {                      /* Default is Date */

				if (dato) 
					dat2 = CutInTwo(lst->def, 1);
				if (dato) {
					printf("<INPUT TYPE=\"TEXT\" NAME=\"VAL\" VALUE=\"%s\" SIZE=8>\n",
					    CharTime(TimeFromString(lst->def)));
				} else {
					printf("<INPUT TYPE=\"TEXT\" NAME=\"VAL\" VALUE=\"%s\" SIZE=8>\n",
					    CharTime(TimeFromString(dat2)));
				}
				if (dat2 != NULL && dato) 
					dato = 0; 
				else 
					dato = 1;
			} else if (lst->defstyle == 1) {
				if (this == (Form * )NULL)
					printf("<INPUT TYPE=\"TEXT\" VALUE=\"Value of %s\" NAME=\"VAL\" SIZE=%d>\n",
					    lst->def?lst->def:"", ((lst->fldtype == 2) ? 15 : 5));
				else
                                if(lst->fldtype==2 && lst->defcond)
					printf("<INPUT TYPE=\"TEXT\" VALUE=\"%s\" NAME=\"VAL\" SIZE=%d>\n",
			  Value(this, lst->def)?Value(this, lst->def):"", ((lst->fldtype == 2) ? 15 : 5));		                                     else
					printf("<INPUT TYPE=\"TEXT\" VALUE=\"%s\" NAME=\"VAL\" SIZE=%d>\n",
		          Value(this, lst->def)?Value(this, lst->def):"", ((lst->fldtype == 2) ? 15 : 5));

			} else if ((lst->vals && lst->vals[0])) {
				if (lst->selstyle == 0) {
                              for (i = 0; lst->vals && (lst->vals)[i]; i++); 
			    printf("<select name = \"VAL\" multiple size=%d>\n",(i>5)?5:i);
					for (i = 0; lst->vals && (lst->vals)[i]; i++) {
						if (lst->fldtype == 2)
					           printf("<option value=\"%s\">", (lst->vals)[i]);
						else 
							printf("<option value=\"%d\">", i);
						printf(" %s\n", (lst->vals)[i]);
					}
					printf("</select><Br>\n");
				} else {
					for (i = 0; lst->vals && (lst->vals)[i]; i++) {
						printf("<INPUT TYPE=checkbox NAME=\"VAL\" ");
						if (lst->fldtype == 2)
							printf("VALUE=\"%s\"> %s<br>\n", (lst->vals)[i], (lst->vals)[i]);
						else
							printf("VALUE=\"%d\"> %s<br>\n", i, (lst->vals)[i]);
					}
				}
			} else if (lst->defstyle == 0) {
				printf("<INPUT TYPE=\"TEXT\" VALUE=\"%s\" NAME=\"VAL\" SIZE=%d>\n",
				    lst->def?lst->def:"", ((lst->fldtype == 2) ? 15 : 5));
				if (lst->fldtype == 2) 
					chf++;
			}
			if (input->style == 2)  
				printf(" </TD><TD> ");
			if (input->braces) {
				printf("<select name=\"P2\">\n");
				printf("<option value=\"%d\"> %s\n", 0, "Nobrace");
				for (i = 1; i < numfields; i++)
					if (dato)
						printf("<option value=\"%d\" %s> %s\n",
						    i, ((lst->p2 == i) ? " selected " : ""), pch(parentesi, i, ')'));
					else
						printf("<option value=\"%d\"> %s\n", i, pch(parentesi, i, ')'));
				printf("</select>\n");
				if (input->style == 2)  
					printf(" </TD><TD> ");
			} else 
				printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"0\" NAME=\"P2\">\n");
			printf("<select name=\"DTIE\">\n");
			for (i = 0; i < 3; i++)
				if (dato)
					printf("<option value=\"%d\" %s> %s\n", i, ((lst->defties == i) ? " selected " :
					    ""), dfty[i]);
				else
					printf("<option value=\"%d\" %s> %s\n", i, ((i == 1) ? " selected " : ""), dfty[i]);
			printf("</select>");
		}
		if (input->style == 2 && lst->type != 3) {
			printf("</TD></TR>\n");
		} else if (input->style == 1 && lst->type != 3) {
			printf("<NOBR>\n");
		} else if (input->style == 0 && lst->type != 3) {
			printf("<Br>\n");
		}
		if (dato)
			lst = lst->next;
	}
	if (input->style == 2 && showview)
		printf("<TR><TD ALIGN=\"CENTER\" COLSPAN=\"%d\">\n", input->braces ? 6 : 4);
	if (showview) {
		printf("<Br>");
		if (chf) {
			printf("<select name=\"CST\">\n");
			printf("<option value=\"1\"> Case insensitive\n");
			printf("<option value=\"0\"> Case sensitive\n");
			printf("</select>\n");
		}
		printf("<select name=\"NRP\">\n");
     printf("<option value=\"1\" %s> one record per page\n",
                                ((input->every == 1) ? " selected " : ""));
		printf("<option value=\"5\" %s> 5 records per page\n",
                                ((input->every == 5) ? " selected " : ""));
		printf("<option value=\"10\" %s> 10 records per page\n",
                                ((input->every == 10) ? " selected " : ""));
		printf("<option value=\"20\" %s> 20 records per page\n",
                                ((input->every == 20) ? " selected " : ""));
		printf("<option value=\"30\" %s> 30 records per page\n",
                                ((input->every == 30) ? " selected " : ""));
		printf("<option value=\"50\" %s> 50 records per page\n",
                                ((input->every == 50) ? " selected " : ""));
		printf("<option value=\"5000\" %s> All found records\n",
                                ((input->every == 5000) ? " selected " : ""));
		printf("</select>\n");
		puts("<Br>");
		printf("Order by <NOBR>\n");
		printf("<select name=\"ORD\">\n");
      	        printf("<OPTION value=\"%s\"> %s\n","No order","No order");
		lst = input->list;
		while (lst && lst->which) {
			if (lst->type != 3)
				printf("<option value=\"%s\">%s\n", lst->name, lst->title);
			lst = lst->next;
		}
		printf("</select>\n");
	} else {
			printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%d\" NAME=\"CST\">\n", input->sens);
			printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%d\" NAME=\"NRP\">\n", input->every);
			printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"ORD\">\n", input->order);
	}
	if (input->style == 2 && showview) 
		printf("</TD></TR>\n");
	if (input->style == 2) 
		printf("</TABLE>\n");
}


void DrawHiddenRepo(SEARCH *this)
{
	SERDATA * lst;
	int	i;
	printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"SEARCH\" NAME=\"ToDo\">\n");
	printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"REPORT\" NAME=\"WHAT\">\n");
	printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"FILENAME\">\n", this->filename);
	printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%d\" NAME=\"Border\">\n", this->border);
	printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%d\" NAME=\"Numcols\">\n", this->numcols);
        printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"Insfile\">\n", this->insfile?this->insfile:""); 
	printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"Format\">\n", this->format);
	printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"Act1\">\n", this->act1?this->act1:"");
	printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"Act2\">\n", this->act2?this->act2:"");
	printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"TAct1\">\n", this->tact1?this->tact1:"");
	printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"TAct2\">\n", this->tact2?this->tact2:"");
	printf("<INPUT TYPE=\"hidden\" NAME=\"Host\" VALUE=\"%s\">\n", this->host);
	printf("<INPUT TYPE=\"hidden\" NAME=\"DB\" VALUE=\"%s\">\n", this->DB);
	printf("<INPUT TYPE=\"hidden\" NAME=\"Table\" VALUE=\"%s\">\n", this->table);
	printf("<INPUT TYPE=\"hidden\" NAME=\"ORD\" VALUE=\"%s\">\n", this->order?this->order:"");
	printf("<INPUT TYPE=\"hidden\" NAME=\"CST\" VALUE=\"%d\">\n", this->sens);
	printf("<INPUT TYPE=\"hidden\" NAME=\"NRP\" VALUE=\"%d\">\n", this->every);
	for (lst = this->list; lst; lst = lst->next) {
		printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%d\" NAME=\"P1\">\n", lst->p1);
		printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%s\" NAME=\"FN\">\n", lst->name);
		printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%d\" NAME=\"Tp\">\n", lst->type);
		printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%d\" NAME=\"CND\">\n", lst->cond);
		for (i = 0; lst->val && (lst->val)[i]; i++)
			printf("<INPUT TYPE=\"HIDDEN\" NAME=\"VAL\" VALUE=\"%s\">\n", (lst->val)[i]);
		printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%d\" NAME=\"P2\">\n", lst->p2);
		printf("<INPUT TYPE=\"HIDDEN\" VALUE=\"%d\" NAME=\"DTIE\">\n", lst->tie);
	}
}


/***      END         ***/
/* **************** DRAW ACTION  ******************* */
/***                  ***/



/* ****************  MISC  ******************* */

void RMAction(Form *this)
{
  /*char	buf[150];*/
	Form * settings = ReadInFormJcookie("SETTINGS");
	char	*filename = Value(settings, "FILE");
	char	*what = Value(this, "WHAT");
	char	*type = CutInTwo(what, 1);
	char	*name = Value(this, type);
	DelActionFrom(filename, type, name);
	PrintHeader(1,1,1);
		printf("Location: http://%s:%s%s?WHICH=mSQL&WHAT=WORK\n\n",
		    SERVER_NAME, SERVER_PORT, SCRIPT_NAME);
exit(0);
}


char	*pch(char *str, int num, char c)
{
	int	i;
	str[0] = '\0';
	for (i = 0; i < num; i++)
		sprintf(str, "%s%c", str, c);
	return str;
}


Form *OutToForm(OUTB *row)
{
	Form * that = (Form * )NULL;
	Form * sledo;
	OUTB * slout;
	if (!row || row->which == 0) 
		return that;
	that = (Form * )malloc(sizeof(Form));
	sledo = that;
	for (slout = row; slout && slout->which; slout = slout->next) {
		sledo->field = slout->name;
		if (slout->next && (slout->next)->which) {
			sledo->next = (Form * )malloc(sizeof(Form));
			sledo = sledo->next;
		} else
			sledo->next = (Form * )NULL;
	}
	return that;
}


Form *InToForm(INPB *row)
{
	Form * that = (Form * )NULL;
	Form * sledo;
	INPB * slout;
	if (!row || row->which == 0) 
		return that;
	that = (Form * )malloc(sizeof(Form));
	sledo = that;
	for (slout = row; slout && slout->which; slout = slout->next) {
		sledo->field = slout->name;
		if (slout->next && (slout->next)->which) {
			sledo->next = (Form * )malloc(sizeof(Form));
			sledo = sledo->next;
		} else
			sledo->next = (Form * )NULL;
	}
	return that;
}


void FillInForm(INPH *input,Form *this,char **row)
{
INPB *lst=input->list;
Form *sledo=this;
int lim,i=0;
/*char buf[100];*/
for(lim=0;row && row[lim]!=NULL;lim++);
for (lst=input->list;lst && lst->which; lst = lst->next) {
if(lst->which>lim) sledo->val=NULL;
else if(lst->defstyle==2) { sledo->val=(char*)malloc(sizeof(char)*12);
sprintf(sledo->val,"%ld",TimeFromString(row[lst->which-1]));
} else if((lst->vals && lst->vals[0]) && lst->fldtype==1)
  {
    for(i=0;lst->vals && (lst->vals)[i];i++) {
      /*printf("<FONT COLOR=YELLOW>LL%sLL%sLL</FONT>",row[lst->which-1],(lst->vals)[i]);*/
     if(mystrcmp((lst->vals)[i],row[lst->which-1])==0) {
     sledo->val=(char*)malloc(sizeof(char)*8);
     sprintf(sledo->val,"%d",i);
     i=-1;
     break;
  }
    }
   if(i>0) sledo->val=row[lst->which-1];
  } else sledo->val=row[lst->which-1];
sledo=sledo->next;
}
}

