#include <stdio.h>
#include "jmsql.h"
#include "jhtml.h"
m_result *types;
m_field *field;

void GetTypes(int sock, char *table)
{
	types = msqlListFields(sock, table);
	if (types == NULL) {
		ShowErr("No such table");
	}
}


void GoBottom()
{
	msqlFieldSeek(types, 0);
}


int	NextField()
{
	if ((field = msqlFetchField(types)) == NULL) 
		return 0;
	return 1;
}


int	FindSSField(char *name)
{
	int	i = 0;
	msqlFieldSeek(types, 0);
	while ((field = msqlFetchField(types)) != NULL) {
		if (mystrcmp(name, field->name) == 0) 
			return i;
		i++;
	}
	return - 1;
}


char	*Name()
{
	return field->name;
}


int	Length()
{
	return field->length;
}


int	Type()
{
	return field->type;
}


int	IsKey()
{
	return ((field->flags) & PRI_KEY_FLAG);
}


int	IsNotNull()
{
	return ((field->flags) & NOT_NULL_FLAG);
}


/************Borrowed from Pascal Forgets msqlimport ************/
/***************** for backslashify_special_chars(const char *s)**/
/*****************************************************************
 * _safe_c_string_copy() makes a copy of a string and returns    *
 * the new string.                                               *
 *                                                               *
 * This function replaces strdup() because:                      *
 *      Not all Unixes implement strdup                          *
 *      Some strdup implementations crash on a NULL argument     *
 *****************************************************************/

char	*
safe_c_string_copy(const char *s)
{
	char	*s1;

	if (s == NULL) {
		return(NULL);
	}

	s1 = (char *)malloc(strlen(s) + 1);

	if (s1 == NULL) {
		return(NULL);
	}

	(void)strcpy(s1, s);

	return(s1);
}


/*****************************************************************
 * Put a backslash in front of single quote, parentheses,        *
 * backslashes, and other special characters in the string. This *
 * is needed for inserting strings containing these characters   *
 * in a relational database.                                     *
 *****************************************************************/

#define BACKSLASH_CHAR 92

char	*
backslashify_special_chars(const char *s)
{
	char	*str, *ptr;
	int	i, j, index, len;

	const char special_chars[] = { 
		'\'', '\"', 0	};
	int	current = 0;

	if ((!s) || 
	    (strlen(s) == 0) || 
	    ((strchr(s, '\'') == NULL) && 
	    (strchr(s, ')') == NULL) && 
	    (strchr(s, '\\') == NULL) && 
	    (strchr(s, '(') == NULL))) {
		return safe_c_string_copy(s);
	}

	str = safe_c_string_copy(s);

	/*
     * Process the backslash character first.  We can't use strchr
     * on strings looking for a backslash
     */

	i = 0;
	while (str[i] != '\0') {
		if (str[i] == BACKSLASH_CHAR) {
			len = strlen(str) + 1;
			str = (char *)realloc(str, len + 2);

			/* move the string to the right */

			j = len - 1;

			while (j > i) {
				str[j+2] = str[j--];
			}
			str[len+1] = '\0';

			/* insert 2 backslashes in the gap */

			str[i] = BACKSLASH_CHAR;
			str[i+1] = BACKSLASH_CHAR;

			i += 3; /* this is not a mistake */
		}

		if (str[i] != '\0') {
			i++;
		}
	}

	/* Do the other special characters */

	while (special_chars[current]) {
		index = -2;

		while ((ptr = strchr(str + index + 2, special_chars[current])) != NULL) {
			len = strlen(str) + 1;
			index = ptr - str;
			str = (char *)realloc(str, len + 1);

			for (i = len + 1; i >= index; i--) {
				str[i+1] = str[i];
			}

			str[index] = BACKSLASH_CHAR;
		}
		current++;
	}

	return str;
}


int	IfmSQL(char *host)
{
	int	sock = -1;

	/* Connect to the msql server */
	if (mystrcmp(host, "local") == 0) {
		sock = msqlConnect(NULL);
	} else {
		sock = msqlConnect(host);
	}

	if (sock == -1) 
		return 0;
	else {
		msqlClose(sock);
		return 1;
	}
}


char	**mSQLDBs(char *host)
{
	int	sock = -1;
	int	i = 0;
	m_row row;
	m_result * res;
	char	**ret = (char**)NULL;
	if (mystrcmp(host, "local") == 0) {
		sock = msqlConnect(NULL);
	} else {
		sock = msqlConnect(host);
	}
	if (sock == -1)  
		ShowErr("Can't connect to server");
	res = msqlListDBs(sock);
	while (row = msqlFetchRow(res)) {
                if (ret)
		ret = (char **)realloc(ret, sizeof(char * )*(i + 2));
                else
		ret = (char **)malloc(sizeof(char * )*(i + 2));
		ret[i] = (char *)malloc(sizeof(char)*(strlen(row[0]) + 1));
		sprintf(ret[i], "%s", row[0]?row[0]:"");
		i++;
	}
	if(i) ret[i] = NULL;
	if(res) msqlFreeResult(res);
	return ret;
}


char	**mSQLTables(char *host, char *DB)
{
	int	sock = ConnectMsql(host, DB);
	int	i = 0;
	m_row row;
	m_result * res;
	char	**ret = NULL;
	res = msqlListTables(sock);
	while (row = msqlFetchRow(res)) {
                if (ret)
		ret = (char **)realloc(ret, sizeof(char * )*(i + 2));
                else
		ret = (char **)malloc(sizeof(char * )*(i + 2));
		ret[i] = (char *)malloc(sizeof(char)*(strlen(row[0]) + 1));
		sprintf(ret[i], "%s", row[0]?row[0]:"");
		i++;
	}
	if(i) ret[i] = NULL;
	if(res) msqlFreeResult(res);
	return ret;
}


char	**mSQLFields(char *host, char *DB, char *Table)
{
	int	sock = ConnectMsql(host, DB);
	int	i = 0;
	m_field * row;
	m_result * res;
	char	**ret = NULL;
	res = msqlListFields(sock, Table);
	while (row = msqlFetchField(res)) {
                if (ret)
		ret = (char **)realloc(ret, sizeof(char * )*(i + 2));
                else
		ret = (char **)malloc(sizeof(char * )*(i + 2));
		ret[i] = (char *)malloc(sizeof(char)*(strlen(row->name) + 1));
		sprintf(ret[i], "%s", row->name);
		i++;
	}
	if(i) ret[i] = NULL;
	if(res) msqlFreeResult(res);
	return ret;
}


char	*mSQLPriKey(int sock, char *Table)
{
	m_field * row;
	m_result * res;
	char	*ret = NULL;
	res = msqlListFields(sock, Table);
	while (row = msqlFetchField(res)) {
		if (IS_PRI_KEY(row->flags)) {
			ret = (char *)malloc(sizeof(char)*(strlen(row->name) + 1));
			sprintf(ret, "%s", row->name);
			break;
		}
	}
	msqlFreeResult(res);
	return ret;
}


m_result *mSQLFullFields(char *host, char *DB, char *Table)
{
	int	sock = ConnectMsql(host, DB);
	m_result * res;
	if (!(res = msqlListFields(sock, Table)))
		ShowFrErr(msqlErrMsg);
	return res;
}


m_field *FindField(m_result *types, char *name)
{
	int	i = 0;
	m_field * field;
	msqlFieldSeek(types, 0);
	while ((field = msqlFetchField(types)) != NULL) {
		if (mystrcmp(name, field->name) == 0) 
			return field;
		i++;
	}
	return (m_field * )NULL;
}


void mSQLDelTable(char *host, char *DB, char *table)
{
	int	sock = ConnectMsql(host, DB);
	char	query[100];
	sprintf(query, "DROP TABLE %s", table);
	if (msqlQuery(sock, query) == -1)
		ShowFrErr(msqlErrMsg);
}


int	ConnectMsql(char *host, char *DB)
{
	int	sock = -1;

	/* Connect to the msql server */
	if (mystrcmp(host, "local") == 0) {
		sock = msqlConnect(NULL);
	} else {
		sock = msqlConnect(host);
	}
	/* Set the current database */
	if (sock == -1)
		ShowFrErr("<FONT COLOR=RED>Can't connect to server</FONT>");
	if (msqlSelectDB(sock, DB) == -1)
		ShowFrErr("<FONT COLOR=RED>Can't find specified DB</FONT>");
	return sock;
}


int	MsqlConnect(char *host, char *DB)
{
	int	sock = -1;

	/* Connect to the msql server */
	if (mystrcmp(host, "local") == 0) {
		sock = msqlConnect(NULL);
	} else {
		sock = msqlConnect(host);
	}
	/* Set the current database */
	if (sock == -1)
		ShowErr("<FONT COLOR=RED>Can't connect to server</FONT>");
	if (msqlSelectDB(sock, DB) == -1)
		ShowErr("<FONT COLOR=RED>Can't find specified DB</FONT>");
	return sock;
}


void TableFromForm(Form *this)
{
	Form * sledo = this;
	int	sock = ConnectMsql(this->val, (this->next)->val);
	char	*query;
	int	length = 0;
	int	count = 0;
	char	type[10];
	char	*sizechar;
	int	flag = 0;
	sledo = sledo->next;
	sledo = sledo->next;
	if (LTrim(sledo->val) == NULL)
		ShowFrErr("<FONT COLOR=RED>A table must have a name");
	sledo = sledo->next;
	while (sledo != NULL) {
		if (mystrcmp(sledo->field, "FieldName") == 0 && !strlen(sledo->val))
			break;
		if (mystrcmp(sledo->field, "Type") == 0)
			strcpy(type, sledo->val);
		else if (mystrcmp(sledo->field, "Size") == 0) {
			if (mystrcmp(type, "char") == 0) {
				sizechar = LTrim(sledo->val);
				if (!isnumber(sizechar))
					ShowFrErr("<FONT COLOR=RED>Size must be a number");
				if (!matoi(sizechar))
					ShowFrErr("<FONT COLOR=RED>A character field must have a size");
			}
		} else if (mystrcmp(sledo->field, "Flag") == 0) {
			if (mystrcmp(sledo->val, "primary key") == 0)
				flag++;
			if (flag > 1)
				ShowFrErr("<FONT COLOR=RED>A table can have only one primary key field");
		}
		length = length + strlen(sledo->val);
		count++;
		sledo = sledo->next;
	}
	if (!count)
		ShowFrErr("<FONT COLOR=RED>A table must have fields");
	query = (char *)malloc(sizeof(char)*(length + count * 4 + 20));
	if (query == NULL) 
		ShowFrErr("<FONT COLOR=RED><BLINK>Memory Allocation Problems");
	sledo = (this->next)->next;
	count = 0;
	sprintf(query, "CREATE TABLE %s(\n", sledo->val?sledo->val:"");
	sledo = sledo->next;
	while (sledo != NULL) {
		if (mystrcmp(sledo->field, "FieldName") == 0) {
			if (!strlen(sledo->val))
				break;
			sprintf(query, "%s %s", query, sledo->val?sledo->val:"");
			count++;
		} else if (mystrcmp(sledo->field, "Type") == 0) 
			strcpy(type, sledo->val);
		else if (mystrcmp(sledo->field, "Size") == 0) {
			if (mystrcmp(type, "char") == 0)
				sprintf(query, "%s %s(%s)", query, type, sledo->val?sledo->val:"");
			else
				sprintf(query, "%s %s", query, type);
		} else if (mystrcmp(sledo->field, "Flag") == 0) {
			sprintf(query, "%s %s", query, sledo->val?sledo->val:"");
			if ((mystrcmp((sledo->next)->field, "ToDo") != 0 ) && 
			    (LTrim((sledo->next)->val) != NULL))
				sprintf(query, "%s,\n", query);
		}
		sledo = sledo->next;
	}
	sprintf(query, "%s\n)", query);
	if (msqlQuery(sock, query) == -1)
		ShowFrErr(msqlErrMsg);

}

int  mSQLInsertRecord(int sock,char *tablename,Form *this,char *query,char *scapes,int enco)
{
	char	*unslashed=NULL;
        char    *unescaped=NULL;
	int	length = 0;
	int	count = 0;
        Form *sledo;
		sprintf(query, "INSERT INTO %s (", tablename);
	sledo = this;
	count = 0;
	GetTypes(sock, tablename);
		while (sledo != NULL) {
			if (count)
				sprintf(query, "%s,", query);
			sprintf(query, "%s%s", query, sledo->field);
			count++;
			sledo = sledo->next;
		}
		sprintf(query, "%s)\n VALUES ( ", query);
	sledo = this;
	count = 0;
	while (sledo != NULL) {
		FindSSField(sledo->field);
		if (count)
			sprintf(query, "%s,", query);
		if (LTrim(sledo->val) != NULL) {
		  if(Type() == 2) {
		    if(enco==1) {
                        unescaped = unescape_string(sledo->val);
			unslashed = backslashify_special_chars(unescaped);
                        if(unescaped) free(unescaped);
		  } else 
                  unslashed = backslashify_special_chars(sledo->val);
		  }
		}
		if (Type() == 2) {
			if (LTrim(sledo->val) != NULL && mystrcmp(sledo->val,"(NULL)"))
        sprintf(query, "%s\'%s\'", query, unslashed?unslashed:"");
			 else
		sprintf(query, "%sNULL", query);
		if (unslashed) {
		  free(unslashed);unslashed=NULL;}
      	} else {
	  if(LTrim(sledo->val)==NULL) {
		    sprintf(query, "%s0", query);
	  } else  if (!isnumber(sledo->val)) {
            sprintf(query,"not numeric value for field %s = %s",
              sledo->field,sledo->val?sledo->val:"");
	    return 1;                       
			} else 
				sprintf(query, "%s%s", query, sledo->val?sledo->val:"");
	}
		count++;
		sledo = sledo->next;
	}
		sprintf(query, "%s)", query);
	if ((count = msqlQuery(sock, query)) == -1) {
            sprintf(query,"%s",msqlErrMsg);
                  return 1;
	}
return 0;
}

void WhereQuery(Form *this, int sock, char *tablename, char *query)
{
	Form * sledo = this;
	char	*unslashed=NULL;
	int	count = 0;
	/* prkey=mSQLPriKey(sock,cur->table); */
	GetTypes(sock, tablename);
	sprintf(query, "%s WHERE ", query);
	while (sledo != NULL && mystrcmp(sledo->field,"##")) {
		if (count)
			sprintf(query, "%s AND ", query);
		unslashed = backslashify_special_chars(sledo->val);
		FindSSField(sledo->field);
		if (Type() == 2) {
			if (LTrim(sledo->val) && mystrcmp(sledo->val,"(NULL)"))
				sprintf(query, "%s %s = \'%s\'", query, sledo->field, sledo->val);
			else 
				sprintf(query, "%s %s = NULL", query, sledo->field);
		} else if (!isnumber(unslashed))
			sprintf(query, "%s %s = 0", query, sledo->field);
		else
			sprintf(query, "%s %s = %s", query, sledo->field, sledo->val?sledo->val:"");
		if (unslashed != NULL)
		  {free(unslashed);unslashed=NULL;}
		sledo = sledo->next;
		count++;
	}
	msqlFreeResult(types);
}


char	*create_search_query(OUTH *out, SEARCH *cur)
{
	SERDATA * sledo = cur->list;
	char	*conds[9] = {
		"like", "=", ">", "<",
		">= ", "<=", "<>", ">", "<"	};
	char	dfty[3][10] = {
		" OFF ", " AND ", " OR "	};
	char	*query;
	char	*unslashed=NULL;
	int	length = 0;
	int	i, count = 0;
	int	statcond = 0;
	OUTB * lst;
	/****************************************
                           QUERY
			   *************************/
	lst = out->list;
	sledo = cur->list;
	length = 8000;
	query = (char * )malloc(sizeof(char)*length);
	if (query == NULL) 
		ShowErr("Memory allocation problems");
	query[0] = '\0';
	sprintf(query, "SELECT ");
	while (lst && lst->which) {
		if (lst->next && (lst->next)->which)
			sprintf(query, "%s %s,", query, lst->name);
		else 
			sprintf(query, "%s %s", query, lst->name);
		lst = lst->next;
	}
	sprintf(query, "%s FROM %s WHERE ", query, cur->table);
	if (query == NULL) 
		ShowErr("Memory allocation problems");
	count = 0;
	sledo = cur->list;
	while (sledo != NULL) {
		if (sledo->tie == 0) {
			sledo = sledo->next;
			continue;
		}
		if (statcond) {
			sprintf(query, "%s %s", query, dfty[statcond]);
		}
		if (sledo->type == 2) {
			unslashed = make_char_query(sledo->val, sledo->name, conds[sledo->cond], cur->sens);
			if (LTrim(unslashed) == NULL || mystrcmp(unslashed,"(NULL)")==0) {
				sprintf(query, "%s %s %s NULL",
				    query, sledo->name, conds[sledo->cond]);
			} else {
				sprintf(query, "%s %s",
				    query, unslashed);
			}
		} else if (sledo->type == 8) {
                          if(TimeFromString((sledo->val)[0])>15)
			sprintf(query, "%s %s %s %ld",
			    query, sledo->name, conds[sledo->cond], TimeFromString((sledo->val)[0]));
                          else 
      ShowErr("Wrong value for a date field.<Br>Must be dd/mm/yy"); 
		} else {
			for (i = 0;sledo->val && LTrim((sledo->val)[i]) != NULL; i++) {
				if (i > 0)
					if (sledo->cond == 6) 
						sprintf(query, "%s %s", query, dfty[1]);
					else 
						sprintf(query, "%s %s", query, dfty[2]);
				if (!isnumber((sledo->val)[0])) {
					sprintf(query, "%s %s %s 0", query, sledo->name, conds[sledo->cond]);
				} else {
					if (sledo->type == 3)
						sprintf(query, "%s %s %s %f", query, sledo->name, conds[sledo->cond], atof((sledo->val)[i]));
					else
						sprintf(query, "%s %s %s %ld", query, sledo->name, conds[sledo->cond], matol((sledo->val)[i]));
				}
			}
		}
		statcond = sledo->tie;
		sledo = sledo->next;
		count++;
	}
	if (count==0) ShowErr("Nothyng to do");
	if (LTrim(cur->order) != NULL && mystrcmp(cur->order, "No order") != 0) {
		lst = out->list;
                if(mystrcmp(cur->order,"No order")!=0)
		while (lst && lst->which) {
			if (mystrcmp(lst->name, cur->order) == 0) {
				sprintf(query, "%s ORDER BY %s", query, cur->order?cur->order:"");
				break;
			}
			lst = lst->next;
		}
	}
	/********************** END QUERY **********/
	return query;
}

static char cqbuf[1240];

char	*make_char_query(char **val, char *name, char *cond, int caso)
{
	char	*ptr;
	char	*ret = cqbuf;
	char	*mtr;
	char	*cso = NULL;
	int	i;
	ret[0] = '\0';
	for (i = 0; val && LTrim((val)[i]) != NULL; i++) {
		if (i > 0)
			if (mystrcmp(cond, "!=") == 0) 
				sprintf(ret, "%s AND", ret);
			else 
				sprintf(ret, "%s OR", ret);
		mtr = val[i];
                if(mystrcmp(cond,"like")!=0) {
                  cso = mtr;
                  cso = backslashify_special_chars(cso);
                  sprintf(ret, "%s %s %s \'%s\'", ret, name, cond, cso);
                  continue;
                } else 
                 ptr = CutInTwo(val[i], 1);
		while (LTrim(mtr) != NULL) {
			cso = mtr;
			if (caso) 
				cso = casify(cso);
                        regulik(cso);
			cso = backslashify_special_chars(cso);
			sprintf(ret, "%s %s %s \'%s\'", ret, name, cond, cso);
			/*free(cso);*/
			mtr = ptr;
			if (LTrim(mtr) == NULL) 
				break;
			ptr = CutInTwo(ptr, 1);
			if ((mystrcmp(mtr, "AND") == 0 || mystrcmp(mtr, "and") == 0) && LTrim(ptr) != NULL) {
				sprintf(ret, "%s %s", ret, "AND");
				mtr = ptr;
				ptr = CutInTwo(ptr, 1);
			} else if (LTrim(ptr) != NULL) {
				sprintf(ret, "%s %s", ret, "OR");
				if (mystrcmp(mtr, "OR") == 0 || mystrcmp(mtr, "or") == 0) {
					mtr = ptr;
					ptr = CutInTwo(ptr, 1);
				}
			} else {
				cso = mtr;
				if (caso) 
					cso = casify(cso);
                                regulik(cso);
				cso = backslashify_special_chars(cso);
				sprintf(ret, "%s %s %s %s \'%s\'", ret, "OR", name, cond, cso);
				/*free(cso);*/
				mtr = ptr;
				break;
			}
		}
	}
	return ret;
}


char	*casify(char *str)
{
	int	i = 0;
	char	*ret = (char *)malloc(sizeof(char)*(strlen(str)*3 + 2));
	char	*ptr = str;
	if (str == NULL) 
		return NULL;
	while (*ptr) {
		if (islower(*ptr)) {
			ret[i] = 91; 
			i++;
			ret[i] = *ptr; 
			i++;
			ret[i] = toupper(*ptr); 
			i++;
			ret[i] = 93; 
			i++;
		} else if (isupper(*ptr)) {
			ret[i] = 91; 
			i++;
			ret[i] = *ptr; 
			i++;
			ret[i] = tolower(*ptr); 
			i++;
			ret[i] = 93; 
			i++;
		}  else {
			ret[i] = *ptr; 
			i++;
		}
		ptr++;
	}
	ret[i] = '\0';
	return ret;
}

void regulik(char *str)
{
char *ptr;
char *mtr=str;
for(ptr=str;*ptr!='\0';ptr++) {
if(*ptr==42 && *mtr != 92) *ptr=37;
mtr=ptr;
}
}

Form *RowToForm(m_row row)
{
	Form * that = (Form * )NULL;
	Form * sledo;
	int	i;
	if (row == NULL) 
		return that;
	that = (Form * )malloc(sizeof(Form));
	sledo = that;
	for (i = 0; row[i]; i++) {
		sledo->val = row[i];
		if (row[i+1]) {
			sledo->next = (Form * )malloc(sizeof(Form));
			sledo = sledo->next;
		} else
			sledo->next = (Form * )NULL;
	}
	return that;
}


