/***[alloc.c]*****************************************************[TAB=4]****\
*                                                                            *
* PHP/FI                                                                     *
*                                                                            *
* Copyright 1995,1996 Rasmus Lerdorf                                         *
*                                                                            *
*  This program is free software; you can redistribute it and/or modify      *
*  it under the terms of the GNU General Public License as published by      *
*  the Free Software Foundation; either version 2 of the License, or         *
*  (at your option) any later version.                                       *
*                                                                            *
*  This program is distributed in the hope that it will be useful,           *
*  but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*  GNU General Public License for more details.                              *
*                                                                            *
*  You should have received a copy of the GNU General Public License         *
*  along with this program; if not, write to the Free Software               *
*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
*                                                                            *
\****************************************************************************/
#include <stdlib.h>
#include <php.h>

static int debug_malloc=0;

void *Emalloc(char *file, int line, int bytes) {
	static unsigned char  *s;

	s = (unsigned char *)malloc(bytes);
	if(s) {
		if(debug_malloc) Debug("[%s-%d]:Allocated %d bytes at %ld\n",file,line,bytes,s);
		return((void *)s);
	}
	Error("[%s-%d]:Unable to allocate %d bytes",file,line,bytes);
	return(NULL);
}

void Efree(char *file, int line, void *s) {
	if(debug_malloc) Debug("[%s-%d]:Freeing allocated block at %ld\n",file,line,s);
	free(s);
}

char *Estrdup(char *file, int line, char *s) {
	int len = strlen(s);
	static char *ret;

	ret = malloc(len+1);
	if(ret) {
		strcpy(ret,s);
		if(debug_malloc) Debug("[%s-%d]: Allocated %d bytes at %ld\n",file,line,len+1,ret);
		return(ret);
	}
	Error("[%s-%d]:Unable to allocate %d bytes",file,line,len);
	return(NULL);
}
