/***[info.c]******************************************************[TAB=4]****\
*                                                                            *
* PHP/FI                                                                     *
*                                                                            *
* Copyright 1995,1996 Rasmus Lerdorf                                         *
*                                                                            *
*  This program is free software; you can redistribute it and/or modify      *
*  it under the terms of the GNU General Public License as published by      *
*  the Free Software Foundation; either version 2 of the License, or         *
*  (at your option) any later version.                                       *
*                                                                            *
*  This program is distributed in the hope that it will be useful,           *
*  but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*  GNU General Public License for more details.                              *
*                                                                            *
*  You should have received a copy of the GNU General Public License         *
*  along with this program; if not, write to the Free Software               *
*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
*                                                                            *
\****************************************************************************/
#include <php.h>
#include <stdlib.h>
#if HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <pwd.h>
#include <grp.h>
#include <time.h>

void Info(void) {
	struct stat sb;
	char *path;
	struct passwd *pw;
	struct group *gr;

	fputs("Content-type: text/html\n\n",stdout);
	fflush(stdout);
#if FI2
	printf("<html><head><title>FI2 - Version Info</title></head><body><h1>FI Version %s</h1>by Rasmus Lerdorf (<a href=\"mailto:rasmus@io.org\">rasmus@io.org</a>)<p>\n",PHP_VERSION);
#else
	printf("<html><head><title>PHP/FI</title></head><body><h1>PHP Version %s</h1>by Rasmus Lerdorf (<a href=\"mailto:rasmus@io.org\">rasmus@io.org</a>)<p>\n",PHP_VERSION);
#endif

	printf("This program is free software; you can redistribute it and/or modify\n");
	printf("it under the terms of the GNU General Public License as published by\n");
	printf("the Free Software Foundation; either version 2 of the License, or\n");
	printf("(at your option) any later version.<p>\n");
	printf("This program is distributed in the hope that it will be useful,\n");
	printf("but WITHOUT ANY WARRANTY; without even the implied warranty of\n");
	printf("MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n");
	printf("GNU General Public License for more details.<p>\n");
	printf("You should have received a copy of the GNU General Public License\n");
	printf("along with this program; if not, write to the Free Software\n");
	printf("Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.<p>\n");

	fflush(stdout);
	fputs("<hr><b><i>Unix version:</i></b> ",stdout);
	fflush(stdout);
	system("uname -a");
	fflush(stdout);
	fputs("<hr><b><i>Environment:</i></b><pre>",stdout);
	fflush(stdout);
	system("env");
	fflush(stdout);
	fputs("</pre>\n",stdout);
	fflush(stdout);
	path = getenv("PATH_TRANSLATED");
	if(path) {
		if(stat(path,&sb)!=-1) {
			printf("<hr><font size=+1>Information on <i>%s</i></font><br>\n",path);
			switch(sb.st_mode&S_IFMT) {
			case S_IFIFO:
				fputs("<b>Type:</b> <i>fifo special</i><br>\n",stdout);
				break;
        	case S_IFCHR:
				fputs("<b>Type:</b> <i>character special</i><br>\n",stdout);
				break;
        	case S_IFDIR:
				fputs("<b>Type:</b> <i>directory</i><br>\n",stdout);
				break;
        	case S_IFBLK:
				fputs("<b>Type:</b> <i>block special</i><br>\n",stdout);
				break;
        	case S_IFREG:
				fputs("<b>Type:</b> <i>ordinary file</i><br>\n",stdout);
				break;
			default:
				fputs("<b>Type:</b> <i>unknown</i><br>\n",stdout);
				break;
			}
			printf("<b>Permission Bits:</b> <i>%04lo</i><br>\n",(long)sb.st_mode&07777);
			printf("<b>Number of Links:</b> <i>%ld</i><br>\n",(long)sb.st_nlink);
			pw = getpwuid(sb.st_uid);
			if(pw) {
				gr = getgrgid(pw->pw_gid);
				printf("<b>Owner:</b> <i>%s</i> <b>From Group:</b> <i>%s</i><br>\n",pw->pw_name,gr->gr_name);
			}
			gr = getgrgid(sb.st_gid);
			if(gr) {
				printf("<b>Group:</b> <i>%s</i><br>\n",gr->gr_name);
			}
			printf("<b>Size:</b> <i>%ld</i><br>\n",(long)sb.st_size);
			printf("<b>Last Access:</b> <i>%s</i><br>",ctime(&sb.st_atime));
			printf("<b>Last Modification:</b> <i>%s</i><br>",ctime(&sb.st_mtime));
			printf("<b>Last Status Change:</b> <i>%s</i><br>",ctime(&sb.st_ctime));
		}
	}
	path = getcwd(NULL,1024);
	if(path) {
		printf("<hr><b>Working Directory:</b> <i>%s</i><br>\n",path);
		free(path);
	}
#if ACCESS_CONTROL
	printf("<b>Access Control enabled using:</b> <i>%s</i><br>\n",ACCESS_DIR);
#endif
#if LOGGING
	printf("<b>Access Logging enabled using:</b> <i>%s</i><br>\n",LOG_DIR);
#endif
#if HAVE_LIBMSQL
	printf("<b>mSQL support enabled</b><br>\n");
#endif
#if GDBM
	printf("<b>GDBM support enabled</b><br>\n");
#else
#if NDBM
	printf("<b>NDBM support enabled</b><br>\n");
#else
	printf("<b>FlatFile support enabled</b><br>\n");
#endif
#endif
#if HAVE_LIBGD
	printf("<b>GD support enabled</b><br>\n");
#endif
	fputs("</body></html>",stdout);
	fflush(stdout);
}

void ShowPageInfo(void) {
	char *email,*host=NULL;
	struct tm *tm1;
	time_t t;
	int tot=0, tod=0;
	char *days[] = {"Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"};
	char *months[] = {	"January","February","March","April","May","June","July",
						"August","September","October","November","December" };
	
	email = getlastemailaddr();
	if(!email) host = getlasthost();
	t = getlastaccess();	
	tm1 = localtime(&t);
	if(email) {
		if(!t)
			printf("<hr size=3 width=400 align=\"center\"><center><i>No Previous Access to this page<br>\n");
		else
			printf("<hr size=3 width=400 align=\"center\"><center><i>Last access on %s %s %d at %d:%02d:%02d by %s<br>\n",days[tm1->tm_wday],months[tm1->tm_mon],tm1->tm_mday,tm1->tm_hour,tm1->tm_min,tm1->tm_sec,email);
	} else {
		if(!t)
			printf("<hr size=3 width=400 align=\"center\"><center><i>No Previous Access to this page<br>\n");
		else
			printf("<hr size=3 width=400 align=\"center\"><center><i>Last access on %s %s %d at %d:%02d:%02d from %s<br>\n",days[tm1->tm_wday],months[tm1->tm_mon],tm1->tm_mday,tm1->tm_hour,tm1->tm_min,tm1->tm_sec,host?host:"(null)");
	}
	tot = gettotal();
	tod = gettoday();
	printf("This page has been accessed	a total of %d time%s now.  %d time%s today.\n<br>",tot,(tot==1)?"":"s",tod,(tod==1)?"":"s");
	t = getlastmod();
	tm1 = localtime(&t);
	printf("Page was last updated on %s %s %d, %d at %d:%02d:%02d</i></center>\n",days[tm1->tm_wday],months[tm1->tm_mon],tm1->tm_mday,1900+tm1->tm_year,tm1->tm_hour,tm1->tm_min,tm1->tm_sec);
}
