/***[main.c]******************************************************[TAB=4]****\
*                                                                            *
* PHP/FI                                                                     *
*                                                                            *
* Copyright 1995,1996 Rasmus Lerdorf                                         *
*                                                                            *
*  This program is free software; you can redistribute it and/or modify      *
*  it under the terms of the GNU General Public License as published by      *
*  the Free Software Foundation; either version 2 of the License, or         *
*  (at your option) any later version.                                       *
*                                                                            *
*  This program is distributed in the hope that it will be useful,           *
*  but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*  GNU General Public License for more details.                              *
*                                                                            *
*  You should have received a copy of the GNU General Public License         *
*  along with this program; if not, write to the Free Software               *
*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
*                                                                            *
\****************************************************************************/
#include <stdlib.h>
#include <php.h>
#if HAVE_UNISTD_H
#include <unistd.h>
#endif

extern int yydebug;

int HeaderPrinted = 0;
int PrintHeader = 1;

#if NSAPI
Session *gsn=NULL;
Request *grq=NULL;
pblock  *gpb=NULL;

int php(pblock *pb, Session *sn, Request *rq) {
	char *path = pblock_findval("path", rq->vars);
	SYS_FILE fd;

	gsn = sn;	
	grq = rq;
	gpb = pb;
	TreatData(1); /* GET Data */
	fd=OpenFile(path,1);
	ParserInit(fd);
	yyparse();
	if(getshowinfo() && getlogging()) ShowPageInfo();
	MsqlClose();
	dbmCloseAll();
#if DEBUG
	CloseDebug();	
#endif
	return(0);
}
#else
int main(int argc, char **argv) {
	int fd;
	char *s;
	int no_httpd=0;
	long file_size;

	s = getenv("PATH_TRANSLATED");
	if(!s) no_httpd=1;

	s = getenv("REQUEST_METHOD");
	if(s && !strcasecmp(s,"post")) {
#if DEBUG
		Debug("About to call TreatData\n");
#endif
		TreatData(0);  /* POST Data */
	}
	if(argc>1) {
		if(!strcasecmp(argv[argc-1],"info")) {
			Info();
			exit(0);
#if ACCESS_CONTROL
		} else if(!strcasecmp(argv[argc-1],"config")) {
			Configuration(argc, argv);	
			exit(0);
#endif
		}
	}
	TreatData(1); /* GET Data */

	if(no_httpd && argv[1]) {
		fd=OpenFile(argv[1],1,&file_size);
	} else {
		fd=OpenFile(NULL,1,&file_size);
	}
	if(fd==-1) {
		Error("Unable to open file");
		return(-1);
	}
	ParserInit(fd,file_size);	
	yyparse();
	if(!no_httpd && getshowinfo() && getlogging()) {
		Log(GetCurrentPI());
		ShowPageInfo();
	}
	MsqlClose();
	dbmCloseAll();
#if DEBUG
	CloseDebug();	
#endif
	return(0);
}
#endif
