/***[php.h]*******************************************************[TAB=4]****\
*                                                                            *
* PHP/FI                                                                     *
*                                                                            *
* Copyright 1995,1996 Rasmus Lerdorf                                         *
*                                                                            *
*  This program is free software; you can redistribute it and/or modify      *
*  it under the terms of the GNU General Public License as published by      *
*  the Free Software Foundation; either version 2 of the License, or         *
*  (at your option) any later version.                                       *
*                                                                            *
*  This program is distributed in the hope that it will be useful,           *
*  but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*  GNU General Public License for more details.                              *
*                                                                            *
*  You should have received a copy of the GNU General Public License         *
*  along with this program; if not, write to the Free Software               *
*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
*                                                                            *
\****************************************************************************/
#include <stdio.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "../config.h"
#if HAVE_FCNTL_H
#include <fcntl.h>
#endif
#if NSAPI
#include "base/pblock.h"
#include "base/session.h"
#include "frame/req.h"
#include "base/file.h"
#include "frame/http.h"
#include "frame/log.h"
#endif

/* 
 * This should be set to the same as the UserDir httpd setting from
 * srm.conf on your system for proper ~username expansion 
 */
#define PHP_PUB_DIRNAME	"public_html"

/* 
 * Only define the following if you wish the ROOT_DIR for PHP loaded
 * scripts to be different from the server's default ROOT_DIR.  
 * Only really useful in non server-wide setups to help shorten the
 * URL's from something like:
 *
 *   http://www.io.org/~rasmus/php.cgi/~rasmus/file.html
 *
 * to:
 *
 *   http://www.io.org/~rasmus/php.cgi/file.html
 */ 
/* #define PHP_ROOT_DIR "/home/rasmus/public_html" */

/*
 * If you are compiling PHP in DEBUG mode, make sure the following
 * points to a valid path and that PHP is allowed to create/write to
 * this file.
 */
#define DEBUG_FILE	"/tmp/php.err"

/*
 * If you are using a virtual domain on a braindead http server which
 * sets the SCRIPT_NAME environment variable to the absolute path as
 * opposed to the relative path to your virtual domain, then you need
 * to define the following to be the relative path to your php.cgi
 * program.  (include php.cgi in the path please)
 */
/* #define VIRTUAL_PATH	"/cgi/php.cgi" */

/*
 * If MAGIC_QUOTES is defined, then the single quote " ' " character
 * will be automatically escaped if it is found in a posted form variable.
 * This is useful when mSQL support is enabled since the single quote
 * has to be escaped when it is part of an mSQL query.  
 */
#define MAGIC_QUOTES 1

/*
 * If UPLOAD_TMPDIR is defined, then this directory will be used for storing
 * uploaded files temporarily.  If undefined, the system's default temporary
 * directory will be used.  You can check which directory is the default
 * temporary directory by searching through your /usr/include directory and
 * looking for the P_tmpdir variable.
 */
/* #define UPLOAD_TMPDIR "/tmp" */

/*
 * If no matter what you do, you cannot get it to accept your ?config
 * password, define the following variable.  Delete any files in your
 * configuration directory, recompile PHP and try using the password: php
 */
/* #define BROKEN_CONFIG_PW 1 */

/* Do not touch anything after this point unless you are very brave */

#define PHP_VERSION "1.99c"

#define VAR_INIT_CHAR	'$'

#if HAVE_FLOCK
#ifndef LOCK_SH
#define LOCK_SH 1
#endif
#ifndef LOCK_EX
#define LOCK_EX 2
#endif
#ifndef LOCK_NB
#define LOCK_NB 4
#endif
#ifndef LOCK_UN
#define LOCK_UN 8
#endif
#endif

#if DEBUG
#define emalloc(a)		Emalloc(__FILE__,__LINE__,(a))
#define estrdup(a)		Estrdup(__FILE__,__LINE__,(a))
#define efree(a)		Efree(__FILE__,__LINE__,(a))
#else
#define emalloc(a)		malloc((a))
#define estrdup(a)		strdup((a))
#define efree(a)		free((a))
#endif

#if STDC_HEADERS
#include <string.h>
#else
#ifndef HAVE_MEMCPY
#define memcpy(d, s, n)		bcopy((s), (d), (n))
#endif
#endif

#define LINEBUFSIZE	4096
#define MAX_CMD_LEN 21

#define YYSTYPE long

#if GDBM
#define DBM_TYPE GDBM_FILE;
#else
#if NDBM
#define DBM_TYPE DBM*;
#else
#define DBM_TYPE FILE*;
typedef struct {
	char *dptr;
	int   dsize;
} datum;
#endif
#endif

/* Variable Tree */
typedef struct VarTree {
	short type;
	int count;
	unsigned char *name;
	unsigned char *strval;
	unsigned char *iname;
	long intval;
	double douval;
	int flag;
	struct VarTree *left;
	struct VarTree *right;
	struct VarTree *next;
	struct VarTree *lacc;
} VarTree;

/* Expression Stack */
typedef struct Stack {
	short type;
	unsigned char *strval;
	long intval;
	double douval;
	VarTree *var;	
	struct Stack *next;
} Stack;

/* Conditional State Stack */
typedef struct CondStack {
	int state;
	int active;
	struct CondStack *next;
} CondStack;

/* Switch state stack */
typedef struct SwitchStack {
	int type;
	int matched;
	long intval;
	double douval;
	char *strval;
	struct SwitchStack *next;
} SwitchStack;

/* Match Stack */
typedef struct MatchStack {
	int val;
	struct MatchStack *next;
} MatchStack;

typedef struct WhileStack {
	long seekpos;
	int offset;
	int state;
	int lineno;
	struct WhileStack *next;
} WhileStack;

typedef struct dbmStack {
	char *filename;
	char *lockfn;
	int lockfd;
	void *dbf;
	struct dbmStack *next;
} dbmStack;

typedef struct FileStack {
#if HAVE_MMAP
	caddr_t pa;
#else
	FILE *fp;
#endif
	int fd;
	long size;
	long pos;
	int state;
	int lineno;
	char *filename;
	struct FileStack *next;
} FileStack;

typedef struct FpStack {
	FILE *fp;
	char *filename;
	int id;
	struct FpStack *next;
} FpStack;

typedef struct AccessInfo {
	int def;
	int mode;
	char *password;
	int type;
	char *patt;
	struct AccessInfo *next;
} AccessInfo;

typedef struct PtrStack {
	void *ptr;
	struct PtrStack *next;
} PtrStack;

/* Prototypes */

/* error.c */
void bailout(void);
void Debug(char *, ...);
void Error(char *, ...);
void CloseDebug(void);
void ErrorPrintState(int);

/* lex.c */
#if NSAPI
int ParserInit(int);
#else
void ParserInit(int, long);
#endif
int yylex(void);
void yyerror(char *);
void WhileAgain(long, int, int);
void Include(void);
void Exit(void);
char *GetCurrentLexLine(int *, int *);

/* date.c */
void Date(int, int);
void UnixTime(void);
void MkTime(void);

/* parse.c */
int yyparse(void);

/* calc.c */
int Calc(int);
int CalcInc(int);
void Neg(void);
void BinDec(void);
void DecBin(void);
void DecHex(void);
void HexDec(void);
void OctDec(void);
void DecOct(void);

/* stack.c */
void Push(unsigned char *, int);
Stack *Pop(void);
void ClearStack(void);

/* var.c */
void SetVar(unsigned char *, int, int);
VarTree *GetVar(unsigned char *, unsigned char *, int);
void IsSet(unsigned char *);
char *SubVar(char *);
void Count(void);
void ArrayMax(void);
void ArrayMin(void);
void PutEnv(void);
void PtrPush(void *);
void *PtrPop(void);
void SecureVar(void);

/* echo.c */
void Echo(unsigned char *);
void StripSlashes(char *);
char *AddSlashes(char *, int);
void ParseEscapes(char *);

/* cond.c */
int Compare(int);
void If(void);
void Else(void);
void ElseIf(void);
void EndIf(void);
void Not(void);
int Logic(int);
int GetCurrentState(int *);
int GetCurrentActive(void);
void ClearCondStack(void);
void CondPush(int, int);
int CondPop(int *);
int CheckCond(Stack *);

/* switch.c */
void Switch(void);
void EndSwitch(void);
void Case(void);
void Break(void);
void Default(void);

/* alloc.c */
void *Emalloc(char *, int, int);
void Efree(char *, int, void *);
char *Estrdup(char *, int, char *);

/* db.c */
void ListSupportedDBs(void);
void dbmOpen(void);
int _dbmOpen(char *, char *);
void dbmClose(void);
int _dbmClose(char *);
void dbmCloseAll(void);
void dbmInsert(void);
int _dbmInsert(char *, char *, char *);
void dbmReplace(void);
int _dbmReplace(char *, char *, char *);
void dbmFetch(void);
char *_dbmFetch(char *, char *);
void dbmExists(void);
int _dbmExists(char *, char *);
void dbmDelete(void);
int _dbmDelete(char *, char *);
void dbmFirstKey(void);
char *_dbmFirstKey(char *);
void dbmNextKey(void);
char *_dbmNextKey(char *, char *);


/* while.c */
void WhilePush(long, int, int);
WhileStack *WhilePop(void);
void While(void);
void EndWhile(void);

/* string.c */
void StrLen(void);
void StrVal(void);
void IntVal(void);
void DoubleVal(void);
void StrTok(int);
char *_strtoupper(char *);
void StrToUpper(void);
char *_strtolower(char *);
void StrToLower(void);
void StrStr(void);
void StrrChr(void);
void SetType(void);
void GetType(void);
void SubStr(void);

/* msql.c */
void Msql(void);
void MsqlResult(void);
void MsqlClose(void);
void MsqlConnect(void);
void MsqlFreeResult(void);
void MsqlNumRows(void);
void MsqlNumFields(void);
void MsqlField(int);
void MsqlRegCase(void);

/* reg.c */
void RegMatch(void);
void RegSearch(void);
void RegReplace(void);
char *_RegReplace(char *, char *, char *);

/* exec.c */
void Exec(unsigned char *, int);

/* file.c */
#if NSAPI
SYS_FILE OpenFile(char *, int);
#else
int OpenFile(char *, int, long *);
#endif
char *GetCurrentFilename(void);
void SetCurrentFilename(char *);
long GetCurrentFileSize(void);
void SetCurrentFileSize(long);
char *FixFilename(char *, int, int *);
char *getfilename(char *, int);
void FileFunc(int);
void TempNam(void);
void Unlink(void);
void Rename(void);
void Sleep(void);
void USleep(void);
void Fopen(void);
void Fclose(void);
void Fputs(void);
void Fgets(void);
void Rewind(void);
void Fseek(void);
void Ftell(void);
char *GetCurrentPI(void);
void ChMod(void);
void ChOwn(void);
void ChGrp(void);
void MkDir(void);

/* crypt.c */
void Crypt(int);

/* head.c */
void Header(void);

/* info.c */
void Info(void);
void ShowPageInfo(void);

/* post.c */
void TreatData(int);
void parse_url(char *);

/* type.c */
int CheckType(char *);
int CheckIdentType(char *);
char *GetIdentIndex(char *);

/* conf.c */
void Configuration(int, char **);

/* acc.c */
AccessInfo *StrtoAccess(char *);
void PostToAccessStr(char *);
void AddRule(char *);
void AddFile(char *, char *);
void ChkPostVars(char *);
void CheckAccess(char *, long);
void ShowBanPage(char *);
void ShowEmailPage(char *);
void ShowPasswordPage(char *);
char *getremotehostname(void);
char *getemailaddr(void);
char *getrefdoc(void);
char *getbrowser(void);
int getlogging(void);
void setlogging(int);
void SetLogging(void);
int getshowinfo(void);
void setshowinfo(int);
void SetShowInfo(void);
void GetAccDir(void);

/* dns.c */
void GetHostByAddr(void);
const char *_GetHostByAddr(char *);
void GetHostByName(void);
char *_GetHostByName(char *);

/* log.c */
void Log(char *);
char *getlastemailaddr(void);
char *getlasthost(void);
char *getlastbrowser(void);
char *getlastref(void);
char *getlogfile(void);
time_t getlastaccess(void);
time_t getlastmod(void);
int gettotal(void);
int gettoday(void);
void loadlastinfo(char *, char *);
void GetLastEmail(void);
void GetLastBrowser(void);
void GetLastHost(void);
void GetLastAccess(void);
void GetLastRef(void);
void GetLogFile(void);
void GetLastMod(void);
void GetTotal(void);
void GetToday(void);
void GetLogDir(void);
void GetMyUid(void);
void GetMyInode(void);
void SetStatInfo(struct stat *);
void GetMyPid(void);

/* sort.c */
void Sort(void);

/* dir.c */
void OpenDir(void);
void CloseDir(void);
void RewindDir(void);
void ReadDir(void);
void ChDir(void);

/* rand.c */
void Srand(void);
void Rand(void);
void GetRandMax(void);

/* gd.c */
void ImageCreate(void);
void ImageDestroy(void);
void ImageGif(int);
void ImageSetPixel(void);
void ImageLine(void);
void ImageRectangle(void);
void ImageFilledRectangle(void);
void ImageArc(void);
void ImageFillToBorder(void);
void ImageFill(void);
void ImageColorAllocate(void);
void ImageColorTransparent(void);
void ImageInterlace(void);
void ImagePolygon(int);
void ImageChar(int);

/* mime.c */
void mime_split(char *, int, char *);
