/***[stack.c]*****************************************************[TAB=4]****\
*                                                                            *
* PHP/FI                                                                     *
*                                                                            *
* Copyright 1995,1996 Rasmus Lerdorf                                         *
*                                                                            *
*  This program is free software; you can redistribute it and/or modify      *
*  it under the terms of the GNU General Public License as published by      *
*  the Free Software Foundation; either version 2 of the License, or         *
*  (at your option) any later version.                                       *
*                                                                            *
*  This program is distributed in the hope that it will be useful,           *
*  but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*  GNU General Public License for more details.                              *
*                                                                            *
*  You should have received a copy of the GNU General Public License         *
*  along with this program; if not, write to the Free Software               *
*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
*                                                                            *
\****************************************************************************/
/* Expression Stack */
#include <stdlib.h>
#include <string.h>
#include <php.h>
#include <parse.h>

static Stack *top=NULL;

void ShowStack(void) {
	Stack *s;

	s=top;
	while(s) {
#if DEBUG
		Debug("(%s)",s->strval?s->strval:(unsigned char *)"NULL");
#endif
		s=s->next;
	}
}

void FreeElement(Stack *el) {
	if(el->strval) efree(el->strval);
	if(el) efree(el);
}

void ClearStack(void) {
	Stack *t,*n;

	t=top;
	while(t) {
		n=t->next;
		if(t->strval) efree(t->strval);
		efree(t);
		t=n;
	}
	top=NULL;
}
	
void Push(unsigned char *value, int type) {
	Stack *new, *s=NULL;
	VarTree *t;
	int next=0;

	if(!value) return;
	if(type==ARRAY) {
		s = Pop();
		if(!s) {
			Error("Stack Error in Push");
			return;
		}
	} else if(type== -ARRAY) { type=ARRAY; next=1; }

	new = emalloc(sizeof(Stack));
	new->type   = type;
	new->next   = NULL;
	new->strval = NULL;
	new->var = NULL;
	if(type==DNUMBER || type==LNUMBER) {
		new->strval = estrdup(value);
		new->intval = atol(value);
		new->douval = atof(value);
	} else if(type==STRING) {
		new->strval = SubVar(value);
		new->intval = atol(new->strval);
		new->douval = atof(new->strval);
	} else if(type==VAR) {
		t = GetVar(value,NULL,0);
		if(!t) {
#if DEBUG
			Debug("Undefined variable: %s\n",value);
#endif
			new->strval = estrdup("");
			new->intval = 0;
			new->douval = 0;
			new->type = LNUMBER;
		} else {
			new->strval = estrdup(t->strval);
			new->intval = t->intval;
			new->douval = t->douval;
			new->type = t->type;
			new->var = t;
		}
	} else if(type==ARRAY) {
		if(!next) t = GetVar(value,s->strval,0);
		else t = GetVar(value,NULL,1);
		if(!t) {
#if DEBUG
			Debug("Undefined array variable: %s\n",value);
#endif
			new->strval = estrdup("");
			new->intval = 0;
			new->douval = 0;
			new->type = LNUMBER;
		} else {
			new->strval = estrdup(t->strval);
			new->intval = t->intval;
			new->douval = t->douval;
			new->type = t->type;
			new->var = t;
		}
	}
	new->next = top;
	top = new;
}

Stack *Pop(void) {
	static Stack ret;
	static int FirstTime=1;

	if(!top) return(NULL);
	if(!FirstTime) {
		if(ret.strval) {
			efree(ret.strval);
			ret.strval=NULL;
		}
	} else {
		ret.strval = NULL;
		FirstTime = 0;
	}
	ret.type = top->type;
	ret.intval = top->intval;
	ret.douval = top->douval;
	ret.next = top->next;
	ret.var = top->var;
	if(top->strval) {
		ret.strval = emalloc(strlen(top->strval)+1);
		strcpy(ret.strval, top->strval);
	}
	FreeElement(top);
	top = ret.next;
	return(&ret);
}
