/***[string.c]****************************************************[TAB=4]****\
*                                                                            *
* PHP/FI                                                                     *
*                                                                            *
* Copyright 1995,1996 Rasmus Lerdorf                                         *
*                                                                            *
*  This program is free software; you can redistribute it and/or modify      *
*  it under the terms of the GNU General Public License as published by      *
*  the Free Software Foundation; either version 2 of the License, or         *
*  (at your option) any later version.                                       *
*                                                                            *
*  This program is distributed in the hope that it will be useful,           *
*  but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*  GNU General Public License for more details.                              *
*                                                                            *
*  You should have received a copy of the GNU General Public License         *
*  along with this program; if not, write to the Free Software               *
*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
*                                                                            *
\****************************************************************************/
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <php.h>
#include <parse.h>

static char nullstr[1] = {'\0'};

void StrLen(void) {
	Stack *s;
	char temp[32];

	s = Pop();
	if(!s) {
		Error("Stack Error in strlen function");
		return;
	}
	sprintf(temp,"%d",(int)strlen(s->strval));
	Push(temp,LNUMBER);
}

void StrVal(void) {
	Stack *s;

	s = Pop();
	if(!s) {
		Error("Stack Error in strval function");
		return;
	}
	Push(s->strval,STRING);
}

void GetType(void) {
	Stack *s;

	s = Pop();
	if(!s) {
		Error("Stack Error in strval function");
		return;
	}
	switch(s->type) {
	case LNUMBER:
		Push("integer",STRING);
		break;
	case DNUMBER:
		Push("double",STRING);
		break;
	case STRING:
		Push("string",STRING);
		break;
	}
}
	
void SetType(void) {
	Stack *s;
	char new_type[32];

	s = Pop();
	if(!s) {
		Error("Stack Error in settype function");
		return;
	}
	strcpy(new_type,s->strval);
	s = Pop();
	if(!s) {
		Error("Stack Error in settype function");
		return;
	}
	if(!s->var) {
		return;
	}
	if(!strcasecmp(new_type,"integer")) s->var->type = LNUMBER;
	else if(!strcasecmp(new_type,"double")) s->var->type = DNUMBER;
	else if(!strcasecmp(new_type,"string")) s->var->type = STRING;
}

void IntVal(void) {
	Stack *s;
	char temp[64];

	s = Pop();
	if(!s) {
		Error("Stack Error in intval function");
		return;
	}
	sprintf(temp,"%ld",s->intval);
	Push(temp,LNUMBER);
}

void DoubleVal(void) {
	Stack *s;
	char temp[128];

	s = Pop();
	if(!s) {
		Error("Stack Error in doubleval function");
		return;
	}
	sprintf(temp,"%.10f",s->douval);
	Push(temp,DNUMBER);
}

void StrTok(int init) {
	Stack *s;
	static char *str=NULL;
	static char *pos1=NULL;
	static char *pos2=NULL;
	char *temp=NULL;
	char *token=NULL;

	s = Pop();
	if(!s) {
		Error("Stack Error in strtok function");
		return;
	}
	if(s->type==STRING) {
		token = estrdup(s->strval);
	} else {
		temp = emalloc(sizeof(char) * 8);
		sprintf(temp,"%c",(int)s->intval);
		token = temp;
	}

	if(init) {
		if(str) {
			efree(str);
			str=NULL;
		}
		s = Pop();
		if(!s) {
			Error("Stack Error in strtok function");
			return;
		}
		str = estrdup(s->strval);
		pos1=str;
		pos2=NULL;
	}
	if(pos1 && *pos1) {
		pos2 = strstr(pos1,token);
		if(pos2) {
			*pos2='\0';
		}	
		Push(pos1,STRING);
		if(pos2) pos1 = pos2+1;
		else pos1=NULL;
	} else {
		Push("",STRING);
	}
	if(token && token!=temp) efree(token);
	if(temp) efree(temp);
}

char *_strtoupper(char *s) {
	char *c;
	int ch;

	c = s;
	while(*c) {
		ch = toupper(*c);
		*c++ = ch;
	}
	return(s);
}
	
void StrToUpper(void) {
	Stack *s;
	
	s = Pop();
	if(!s) {
		Error("Stack Error in strtoupper function");
		return;
	}
	Push(_strtoupper(s->strval),STRING);
}

char *_strtolower(char *s) {
	char *c;
	int ch;

	c = s;
	while(*c) {
		ch=tolower(*c);
		*c++ = ch;
	}
	return(s);
}

void StrToLower(void) {
	Stack *s;
	
	s = Pop();
	if(!s) {
		Error("Stack Error in strtolower function");
		return;
	}
	Push(_strtolower(s->strval),STRING);
}

void StrStr(void) {
	Stack *s;
	char *a, *b;
	char *c;

	s = Pop();
	if(!s) {
		Error("Stack Error in strstr function");
		return;
	}
	if(s->type == STRING) b = estrdup(s->strval);
	else { 
		b = emalloc(6);
		sprintf(b,"%c",(int)s->intval);
	}
		
	s = Pop();
	if(!s) {
		Error("Stack Error in strstr function");
		return;
	}
	a = estrdup(s->strval);

	c = strstr(a,b);

	if(c) Push(c,STRING);
	else Push(nullstr,STRING);
	efree(b);
	efree(a);
}	

void StrrChr(void) {
	Stack *s;
	char *a, *b;
	char *c;

	s = Pop();
	if(!s) {
		Error("Stack Error in strchr function");
		return;
	}
	if(s->type == STRING) b = estrdup(s->strval);
	else { 
		b = emalloc(6);
		sprintf(b,"%c",(int)s->intval);
	}

	s = Pop();
	if(!s) {
		Error("Stack Error in strstr function");
		return;
	}
	a = estrdup(s->strval);

	c = strrchr(a,*b);

	if(c) Push(c,STRING);
	else Push(nullstr,STRING);
	efree(b);
	efree(a);
}	

/* args s,m,n */
void SubStr(void) {
	Stack *s;
	int m,n;
	char *str;

	s = Pop();
	if(!s) {
		Error("Stack Error in substr function");
		return;
	}
	n = s->intval;

	s = Pop();
	if(!s) {
		Error("Stack Error in substr function");
		return;
	}
	m = s->intval;

	s = Pop();
	if(!s) {
		Error("Stack Error in substr function");
		return;
	}
	if(m>strlen(s->strval)) {
		Push("",STRING);
		return;
	}	
	str = (char *)estrdup(s->strval);
	if(m+n > strlen(str)) {
		Push(&str[m],STRING);
		efree(str);
		return;
	}
	str[m+n]='\0';	
	Push(&str[m],STRING);
	efree(str);
}
