/***[switch.c]****************************************************[TAB=4]****\
*                                                                            *
* PHP/FI                                                                     *
*                                                                            *
* Copyright 1995,1996 Rasmus Lerdorf                                         *
*                                                                            *
*  This program is free software; you can redistribute it and/or modify      *
*  it under the terms of the GNU General Public License as published by      *
*  the Free Software Foundation; either version 2 of the License, or         *
*  (at your option) any later version.                                       *
*                                                                            *
*  This program is distributed in the hope that it will be useful,           *
*  but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*  GNU General Public License for more details.                              *
*                                                                            *
*  You should have received a copy of the GNU General Public License         *
*  along with this program; if not, write to the Free Software               *
*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
*                                                                            *
\****************************************************************************/
#include <stdlib.h>
#include <string.h>
#include <php.h>
#include <parse.h>

static SwitchStack *top=NULL;

void SwitchPush(Stack *s) {
	struct SwitchStack *new;

	new = malloc(sizeof(SwitchStack));
	new->type = s->type;
	new->matched = 0;
	new->intval = s->intval;
	new->douval = s->douval;
	if(s->strval) new->strval = strdup(s->strval);
	new->next = top;
	top = new;
}

SwitchStack *SwitchPop(void) {
	static int FirstTime=1;
	static SwitchStack ret;
	SwitchStack *s;

	if(!top) return(NULL);

	if(!FirstTime) {
		if(ret.strval) {
			free(ret.strval);
			ret.strval = NULL;
		}
	} else {
		ret.strval=NULL;
		FirstTime=0;
	}
	ret.type = top->type;
	ret.matched = top->matched;
	ret.intval = top->intval;
	ret.douval = top->douval;
	if(top->strval) {
		ret.strval=strdup(top->strval);
		free(top->strval);
	}
	s = top->next;
	free(top);
	top = s;
	return(&ret);
}	

void Switch(void) {
	Stack *s;
	int active, state;

	state = GetCurrentState(&active);
	if(state) {
		s = Pop();
		if(!s) {
			Error("Stack error in switch");
			return;
		}
		SwitchPush(s);
		CondPush(1,1);
	} else {
		CondPush(0,-3);
	}
}

void EndSwitch(void) {
	int active, state;

	state = GetCurrentState(&active);
	if(active==-3) {
		CondPop(NULL);
	} else {
		SwitchPop();
		CondPop(NULL);
	}
}

void Case(void) {
	Stack *s;
	int ret;
	int active;
	int state;

	s = Pop();
	if(!s) {
		Error("Stack Error in case statement");
		return;
	}
	if(!top) {
		Error("Case statement found outside of switch");
		return;
	}
	state = GetCurrentState(&active);
#if DEBUG
	Debug("Case active = %d, matched = %d\n",active,top->matched);
#endif
	if(state && active==-2) {
		return;
	}

	switch(s->type) {
		case LNUMBER:
#if DEBUG
			Debug("Case comparing %ld to %ld\n",s->intval, top->intval);
#endif
			ret = (s->intval == top->intval);
			CondPush(ret,-2);
			break;
		case DNUMBER:
			ret = (s->douval == top->douval);
			CondPush(ret,-2);
			break;
		case STRING:
			ret = (strcmp(s->strval,top->strval)==0);
			CondPush(ret,-2);
			break;
	}
}	

void Default(void) {
	if(!top->matched) CondPush(1,-2);
	else CondPush(0,-2);
}
	
void Break(void) {
	int active;
	int state;

	active = GetCurrentActive();
	if(active>-2) {
		Error("Misplaced break");
#if DEBUG
		Debug("Active = %d",active);
#endif
		return;
	}
	state = CondPop(NULL);
	if(!top->matched) {
#if DEBUG
		Debug("Setting matched to %d in break\n",state);
#endif
		top->matched = state;
	}
}
