/***[while.c]*****************************************************[TAB=4]****\
*                                                                            *
* PHP/FI                                                                     *
*                                                                            *
* Copyright 1995,1996 Rasmus Lerdorf                                         *
*                                                                            *
*  This program is free software; you can redistribute it and/or modify      *
*  it under the terms of the GNU General Public License as published by      *
*  the Free Software Foundation; either version 2 of the License, or         *
*  (at your option) any later version.                                       *
*                                                                            *
*  This program is distributed in the hope that it will be useful,           *
*  but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*  GNU General Public License for more details.                              *
*                                                                            *
*  You should have received a copy of the GNU General Public License         *
*  along with this program; if not, write to the Free Software               *
*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
*                                                                            *
\****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <php.h>
#include <parse.h>

static WhileStack *top=NULL;

void ShowWhileStack(void) {
	WhileStack *s;
	
	s = top;
	while(s) {
#if DEBUG
		Debug("(%ld) ",s->seekpos + s->offset);
#endif
		s = s->next;
	}
#if DEBUG
	Debug("\n");
#endif
}

void WhilePush(long seekpos, int offset, int lineno) {
	WhileStack *new;

#if DEBUG
	Debug("WhilePush called: seekpos=%ld, offset=%d, lineno=%d\n",seekpos,offset,lineno);
#endif
	new=emalloc(sizeof(WhileStack));
	new->seekpos = seekpos;
	new->offset = offset;
	new->next = top;
	new->state = 1;
	new->lineno = lineno;
	top = new;
}

WhileStack *WhilePop(void) {
	static WhileStack ret;
	WhileStack *s;

	s = top;
	ret.seekpos = top->seekpos;
	ret.offset = top->offset;
	ret.state = top->state;
	ret.lineno = top->lineno;
	top = top->next;
	free(s);
	return(&ret);
}

void While(void) {
	Stack *s;
	int active, state, c;
	
#if DEBUG
	Debug("While() called\n");
#endif
	state = GetCurrentState(&active);
	if(state) {
		s = Pop();
		if(!s) {
			Error("Stack Error in while");
			return;
		}
		c = CheckCond(s);
		top->state = c;
		CondPush(c,-4);
		if(!c) WhilePop();
	} else {
		CondPush(state,-4);
	}
}

void EndWhile(void) {
	WhileStack *t=NULL;
	int active, state;

#if DEBUG
	Debug("EndWhile() called\n");
#endif
	state = CondPop(&active);
	if(active != -4) {
		Error("endwhile misplaced");
		return;
	}	
	if(state) {
		t = WhilePop();
		WhileAgain(t->seekpos,t->offset,t->lineno);
	}
}
