// Header file for ZWindow class
#ifndef __ZWINDOW_H
#define __ZWINDOW_H

#include <zwindef.h>
#include <zwininfo.h>
#include <zcanvas.h>
#include <zevent.h>
#include <zmenu.h>
#include <zapp.h>

LRESULT CALLBACK _export WndProc( HWND hWnd, UINT iMessage,
                                 WPARAM wParam, LPARAM lParam );

class ZWindow	{
	public:
	TZWindow		Window;				/* Our private window */
	TZCursor		Cursor;					/* Current pointer icon */
	char Name[255];
	TZWindow Parent;
	ZEventHandler* EventHandler[MAX_EVENTS];
	ZWindowInfo WindowInfo;
	ZRect WindowRect;
	BOOL Registered;
	BOOL Created;
	BOOL Opened;
	int NumEvHandlers;

	ZCanvas* Canvas;
	ZMenu* Menu;

	ZWindow(TZWindow,char*,ZMenu*,int x=10,int y=10,int w=300,int h=300);
	~ZWindow();

	TZWindow GetWindow(){return Window;}
	TZCursor GetCursor(){return Cursor;}
	char* GetWindowName(){return Name;}
	TZWindow GetParent(){return Parent;}
	ZWindowInfo* GetWindowInfo(){return &WindowInfo;}
	void SetTitle(char*);

	BOOL AddEventHandler(ZEventHandler*);
	virtual LRESULT HandleEvent(ZEventInfo);

	virtual BOOL Register();
	virtual BOOL Create();
	virtual BOOL Open();
	virtual void Error(ZError errorCode);

	virtual LRESULT CmAbout(ZEventInfo);
	virtual LRESULT CmQuit(ZEventInfo);
	virtual LRESULT CmClose(ZEventInfo);
	virtual LRESULT CmPaint(ZEventInfo);

	};

#endif //__ZWINDOW_H

