/*--------------------------------------------------------------*/
/* 								*/
/* xmsql version 0.1						*/
/*								*/
/* xmsql is a X interface to the mSQL database			*/
/*								*/
/* xmsql is distributed WITHOUT ANY WARRENTY; 			*/
/* see README for details.					*/
/* Copyright (C) 1995 Stefan Dupont-Christ			*/
/*								*/
/*--------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Viewport.h>

#include "xwidgets.h"
#include "common.h"

#ifdef NO_XAW
#define XawRubber XtRubber
#define XawChainTop XtChainTop
#define XawChainBottom XtChainBottom
#define XawChainLeft XtChainLeft
#define XawChainRight XtChainRight
#endif


#define MAINWIDTH 550
#define MAINHEIGHT 150

/* globaler Widget-Container */
extern CWidgets cWidgets; 

/* Callbacks */
extern void quit(Widget, XtPointer, XtPointer);
extern void openNotify(Widget, XtPointer, XtPointer);
extern void connectLocalServer(Widget, XtPointer, XtPointer);
extern void connectRemoteServer(Widget, XtPointer, XtPointer);
extern void listTables(Widget, XtPointer, XtPointer);
extern void selectDB(Widget, XtPointer, XtPointer);
extern void executeSql(Widget, XtPointer, XtPointer);
extern void showAbout(Widget, XtPointer, XtPointer);
extern void load(Widget, XtPointer, XtPointer);
extern void save(Widget, XtPointer, XtPointer);

/*
 * Funktion zum Erzeugen des Widget-Baums
*/

void initWidgetTree(Widget appShell)
{
  Arg wargs[20];
  Widget form, box, menu, paned, stext, dtext, statusLine, aboutButton,
     	 fileMenuButton, controlMenuButton, entry, combo, label;
  Window root;
  int n;
  static notifyInfo aNotify;

  form = XtCreateManagedWidget("form", formWidgetClass,
		appShell, (Arg *)NULL, 0);
                
  /* file menu */              
  n=0;
  XtSetArg(wargs[n], XtNlabel, "File");      n++;
  fileMenuButton = XtCreateManagedWidget("fileMenuButton", menuButtonWidgetClass,
        	form, wargs, n);

  menu = XtCreatePopupShell("menu", simpleMenuWidgetClass,
        	fileMenuButton, (Arg *)NULL, 0);     
  n = 0;
  XtSetArg(wargs[n], XtNlabel, "Load"); n++;               
  entry = XtCreateManagedWidget("Load", smeBSBObjectClass,
        	menu, wargs, n); 
  XtAddCallback(entry, XtNcallback, load, NULL);
  n = 0;
  XtSetArg(wargs[n], XtNlabel, "Save"); n++;               
  entry = XtCreateManagedWidget("Save", smeBSBObjectClass,
        	menu, wargs, n); 
  XtAddCallback(entry, XtNcallback, save, NULL);                         
  entry = XtCreateManagedWidget("line", smeLineObjectClass,
        	menu, (Arg *)NULL, 0);
  n = 0;
  XtSetArg(wargs[n], XtNlabel, "Quit"); n++;               
  entry = XtCreateManagedWidget("quit", smeBSBObjectClass,
        	menu, wargs, n); 
  XtAddCallback(entry, XtNcallback, quit, NULL); 
  
  /* control menu */
  n=0;
  XtSetArg(wargs[n], XtNlabel, "Control");      n++;
  controlMenuButton = XtCreateManagedWidget("controlMenuButton", menuButtonWidgetClass,
        	form, wargs, n);

  menu = XtCreatePopupShell("menu", simpleMenuWidgetClass,
        	controlMenuButton, (Arg *)NULL, 0);
  n = 0;
  XtSetArg(wargs[n], XtNlabel, "Connect to local server"); n++;          
  entry = XtCreateManagedWidget("connectSrv", smeBSBObjectClass,
        	menu, wargs, n);               
  XtAddCallback(entry, XtNcallback, connectLocalServer, NULL);
  
  n = 0;
  XtSetArg(wargs[n], XtNlabel, "Connect to remote server"); n++;          
  entry = XtCreateManagedWidget("connectRemoteSrv", smeBSBObjectClass,
        	menu, wargs, n);               
  XtAddCallback(entry, XtNcallback, connectRemoteServer, NULL);
  
  n = 0;
  XtSetArg(wargs[n], XtNlabel, "List tables & columns"); n++; 
  entry = XtCreateManagedWidget("listTbl", smeBSBObjectClass,
        	menu, wargs, n);               
  XtAddCallback(entry, XtNcallback, listTables, NULL);
  
  n = 0;
  XtSetArg(wargs[n], XtNlabel, "Execute selection"); n++;
  entry = XtCreateManagedWidget("executeSql", smeBSBObjectClass,
        	menu, wargs, n);               
  XtAddCallback(entry, XtNcallback, executeSql, NULL);
  
  /* About Menu item */
  
  n=0;
  XtSetArg(wargs[n], XtNlabel, "About xmsql");      n++;
  XtSetArg(wargs[n], XtNx, MAINWIDTH - 30);      n++;
  aboutButton = XtCreateManagedWidget("cmdButton", commandWidgetClass,
        	form, wargs, n);    
  XtAddCallback(aboutButton, XtNcallback, showAbout, NULL);                        
                  
  /* end Menu */
  
  combo = MakeCombo(form);
  /* an dieser Stelle sollte cWidgets.list schon belegt sein. */
  XtAddCallback(cWidgets.list, XtNcallback, selectDB, NULL);
  
  n = 0;
  XtSetArg(wargs[n], XtNborderWidth, 0);	n++;
  XtSetArg(wargs[n], XtNlabel,	"Database:");	n++;
  label = XtCreateManagedWidget("label", labelWidgetClass, 
        	form, wargs, n);
  
  /* paned, sql-source-window, output-window */              
  paned = XtCreateManagedWidget("paned", panedWidgetClass,
        	form, (Arg *)NULL, 0);
  
  n = 0;
  XtSetArg(wargs[n], XtNwidth,	MAINWIDTH);	n++;
  XtSetArg(wargs[n], XtNheight,	MAINHEIGHT); 	n++;
  XtSetArg(wargs[n], XtNdisplayNonprinting, False);	n++; 
  XtSetArg(wargs[n], XtNeditType, XawtextEdit);		n++;
  XtSetArg(wargs[n], XtNwrap, XawtextWrapWord);		n++;
  XtSetArg(wargs[n], XtNscrollVertical, XawtextScrollWhenNeeded); n++; 
  stext = XtCreateManagedWidget("stext", asciiTextWidgetClass,
        	paned, wargs, n);
  
  n = 0;
  XtSetArg(wargs[n], XtNwidth,	MAINWIDTH);	n++;
  XtSetArg(wargs[n], XtNheight,	MAINHEIGHT);	n++;
  XtSetArg(wargs[n], XtNeditType, XawtextRead);		n++;
  XtSetArg(wargs[n], XtNwrap, XawtextWrapNever);	n++;
  XtSetArg(wargs[n], XtNscrollVertical, XawtextScrollWhenNeeded); n++;
  XtSetArg(wargs[n], XtNscrollHorizontal, XawtextScrollWhenNeeded); n++;
  XtSetArg(wargs[n], XtNdisplayCaret, False);	n++;
  dtext = XtCreateManagedWidget("dtext", asciiTextWidgetClass,
        	paned, wargs, n);
   
  n=0;
  XtSetArg(wargs[n], XtNstring, "Welcome to xmsql");      n++;              
  statusLine = XtCreateManagedWidget("status", asciiTextWidgetClass,
        	form, wargs, n);                
  
  n=0;
  XtSetArg(wargs[n], XtNtop, XawChainTop);      n++;
  XtSetArg(wargs[n], XtNbottom, XawChainTop);      n++;
  XtSetArg(wargs[n], XtNright, XawChainLeft);      n++;
  XtSetArg(wargs[n], XtNleft, XawChainLeft);      n++;
  XtSetValues(fileMenuButton, wargs, n);
  XtSetValues(controlMenuButton, wargs, n);
  XtSetValues(label, wargs, n);
  XtSetValues(combo, wargs, n);
  XtSetValues(aboutButton, wargs, n);
  n = 0;
  XtSetArg(wargs[n], XtNfromHoriz, fileMenuButton);      n++;
  XtSetValues(controlMenuButton, wargs, n); 
  n = 0;
  XtSetArg(wargs[n], XtNfromHoriz, controlMenuButton);      n++;
  XtSetValues(label, wargs, n); 
  n = 0;
  XtSetArg(wargs[n], XtNfromHoriz, label);      n++;
  XtSetValues(combo, wargs, n); 
  n = 0;
  XtSetArg(wargs[n], XtNfromHoriz, combo);      n++;
  XtSetValues(aboutButton, wargs, n); 
  
  
  n=0;
  XtSetArg(wargs[n], XtNtop, XawChainTop);      n++;
  XtSetArg(wargs[n], XtNleft, XawChainLeft);      n++;
  XtSetArg(wargs[n], XtNright, XawRubber);      n++;
  XtSetArg(wargs[n], XtNbottom, XawRubber);      n++;
  XtSetArg(wargs[n], XtNfromVert, fileMenuButton);      n++;
  XtSetArg(wargs[n], XtNvertDistance, 5);      n++;
  
  XtSetValues(paned, wargs, n);
  
  n=0;
  XtSetArg(wargs[n], XtNwidth, MAINWIDTH);      n++;
  XtSetArg(wargs[n], XtNtop, XawChainBottom);      n++;
  XtSetArg(wargs[n], XtNleft, XawRubber);      n++;
  XtSetArg(wargs[n], XtNright, XawRubber);      n++;
  XtSetArg(wargs[n], XtNbottom, XawChainBottom);      n++;
  XtSetArg(wargs[n], XtNfromVert, paned);      n++;
  XtSetArg(wargs[n], XtNvertDistance, 5);      n++;
  XtSetArg(wargs[n], XtNeditType, XawtextRead);      n++;
  XtSetArg(wargs[n], XtNdisplayCaret, False);      n++;
  
  XtSetValues(statusLine, wargs, n);
 
  /* Close-Aktion fr form eintragen (Translation) */
  XtOverrideTranslations(form, XtParseTranslationTable("<Key>q:closeWin()"));
  /* Evaluate-Aktion fr stext */
  XtOverrideTranslations(stext, XtParseTranslationTable(
     	"!Ctrl<Key>Return:evaluate()"));
         /*<Enter>:dropLine()\n\
         <Leave>:clearStatus()"));*/  /* not useful */
  
  /* Widgets in Widget-Container */
  cWidgets.stext = stext;
  cWidgets.dtext = dtext;
  cWidgets.status = statusLine;
}

