#!/usr/local/bin/perl -sw
# $Id: Makefile.PL,v 1.21 1995/06/22 00:37:04 timbo Rel $

use ExtUtils::MakeMaker qw(&WriteMakefile $Verbose %att);
use Getopt::Std;
use Config;

use DBI;	# The DBI must be installed before we can build a DBD

%opts = (
    'NAME'    => 'DBD::mSQL',
    'VERSION' => '0.0',
);

# Options, typically only used for debugging
#$opt_m = '';		# path to proc.mk or oracle.mk file to read

#getopts('m:') or die "Invalid arguments";

# --- Introduction

print "\nConfiguring DBD::mSQL version $opts{VERSION}...\n";
print "Remember to actually read the README file!\n\n";

# --- Where is mSQL installed...

unless ($ENV{MSQL_HOME}){
    warn "\$MSQL_HOME not defined. Searching for mSQL...\n";
    foreach(qw(/usr/mSQL /opt/mSQL /usr/soft/mSQL)){
	$ENV{MSQL_HOME}=$_,last if -d "$_/lib";
    }
    die "Unable to determine \$MSQL_HOME!\n" unless $ENV{MSQL_HOME};
}
my $MH = $ENV{MSQL_HOME};

print "Using mSQL in $MH\n";

# --- What mSQL is installed...

# Validate we have the right stuff installed

warn "Warning: mSQL library does not appear to be installed.\n"
	unless -f "$MH/lib/libmsql.a"
	   and -f "$MH/include/msql.h";

# read list of libs that oracle requires (eg -lm -lnsl)
$sysliblist = "-L$MH/lib -lmsql -lm";
print "mSQL sysliblist: $sysliblist\n";


#$oraclemk = $opt_m || "$OH/proc/lib/proc.mk";
# Apparently some Oracle 7.1.3 Pro*C makefiles might be here:
#$oraclemk = "$OH/proc16/lib/proc16.mk" unless -f $oraclemk;
#die "Unable to locate proc.mk (use -m /path/to/proc.mk to specify)\n"
#    unless -f $oraclemk;
$linkwith = "-L$MH/lib -R$MH/lib";
 
#print "Using $oraclemk version $MK{mkver}\n";


#$OCIINCLUDE = $MK{INCLUDE} || '';

$opts{LIBS} = [ $sysliblist ];
$opts{INC}  = "-I$MH/include -I$Config{archlib}/DBI";
#$opts{dynamic_lib} = { OTHERLDFLAGS => '-L$(LIBHOME)' .$linkwith };
$opts{dynamic_lib} = { OTHERLDFLAGS => '-L$(MSQL_HOME)/lib' .$linkwith };
$opts{OBJECT} = '$(O_FILES)';

# --- Handle special cases ---

# Since HPUX can't mix -pic & non-pic (.a) in a dynamically loadable
# file and oracle only supply .a libs we have to build static.
if ($Config{osname} eq 'hpux' || $Config{osname} eq 'i386-sysv' ) {
    print "Warning: forced to build static not dynamic on $Config{osname}\n";
    print "         See README file for more information.\n";
    $opts{LINKTYPE} = 'static';
}

$opts{DEFINE} = '-Wall -pedantic -Wno-comment -Wpointer-arith -Wcast-align'
	    . ' -Wconversion -Wtraditional -Wpointer-arith'
	    . ' -Wcast-qual'
	if $Config{cc} eq 'gcc';	# Just me asking gcc to be paranoid.

$opts{DEFINE} .= ' -Xa' if $Config{cc} eq 'clcc';	# CenterLine CC


# Set some private WriteMakefile options if this is 'me' :-)
if ($ENV{LOGNAME} eq 'timbo' and $ENV{S_ARCH_SW}){  # a reasonable guess
    $Verbose = 1;
    $opts{INST_LIB}     = $Config{installprivlib};
    $opts{INST_ARCHLIB} = $Config{installarchlib};
}

# log key platform information to help me help you quickly
print "System: perl$] @Config{qw(myuname archname dlsrc)}\n";
print "Compiler: @Config{qw(cc optimize ccflags)}\n";

# Assorted hints - these should be move to a hints subdirectory
print "See README notes about SPARCompiler on Solaris\n"
    if -d "/opt/SUNWspro/bin" and $Config{osname} eq 'solaris';

print "\n";

WriteMakefile(%opts);

exit 0;

#sub MY::dist {		# new name with 5.001e
#    '
#DISTFILES=RCS/*
#
#ci:
#	-ci -u $(DISTFILES) 2>&1 | grep -v "no lock set by "
#	-rcs -q -Nv`echo "$(VERSION)" | tr . _`: $(DISTFILES)
#
#rcsdiff:
#	for f in $(DISTFILES); do rcsdiff -r$(V) $$f; done 2>&1 | less
#
#dist:  ci clean
#	rcs -q -sRel $(DISTFILES)
#	co -q -u     $(DISTFILES)
#	rm -f Makefile *~ t/*~
#	cd ..; tar cvFf $(DISTNAME)-$(VERSION).tar \
#		`sed -e "s:^:$(BASEEXT)/:" < $(BASEEXT)/MANIFEST`
#	@cd ..; compress $(DISTNAME)-$(VERSION).tar;
#	@chmod -w ../$(DISTNAME)-$(VERSION).tar.Z
#	mv ../$(DISTNAME)-$(VERSION).tar.Z $$HOME/perl/db/DBD/Oracle/
#	cp README $$HOME/perl/db/DBD/Oracle/
#	@cd $$HOME/perl/db/DBD/Oracle; pwd; ls -l *.Z
#';
#}
#
#*{"MY::distclean"} = \&MY::dist;	# remain compatible with 5.001

__END__
