#!/usr/local/bin/perl -w
# $Id: Makefile.PL,v 1.32 1995/06/22 00:02:19 timbo Rel $

use ExtUtils::MakeMaker qw(WriteMakefile $Verbose %att);
use Config;

%opts = (
    NAME=> 'DBI',
    VERSION=> "0.58",
);

# Set some private WriteMakefile options if this is 'me' :-)
if ($ENV{LOGNAME} eq 'timbo' and $ENV{S_ARCH_SW}){	# a reasonable guess
	$Verbose = 1;
	$opts{'INST_LIB'}     = $Config{'installprivlib'};
	$opts{'INST_ARCHLIB'} = $Config{'installarchlib'};
}
$opts{'DEFINE'} = '-Wall -pedantic -Wno-comment -Wpointer-arith -Wcast-align -Wconversion'
    if $Config{cc} eq 'gcc';	# ask gcc to be mildly paranoid


$Verbose = 1;
warn <<EOT;

    Build, TEST and INSTALL Perl 5 first. Use version 5.001e or later.

    DO NOT build the DBI under the Perl source tree.

    Use 'make test' to execute self tests.

EOT


WriteMakefile( %opts );


sub MY::post_initialize{
	# get DBIXS.h installed for access by DBD's
	$att{PM}->{'DBIXS.h'} = '$(INST_ARCHLIBDIR)/DBI/DBIXS.h';
	'';
}


# --- private development stuff ---

sub MY::dist {
    '
DISTFILES=RCS/*

ci:
	-ci -u $(DISTFILES) 2>&1 | grep -v "no lock set by "
	-rcs -q -Nv`echo "$(VERSION)" | tr . _`: $(DISTFILES)

rcsdiff:
	for f in $(DISTFILES); do rcsdiff -r$(V) $$f; done 2>&1 | less

dist:  ci clean
	rcs -q -sRel $(DISTFILES)
	co -q -u     $(DISTFILES)
	rm -f Makefile Makefile.old *~ t/*~
	cd ..; tar cvFf DBI-$(VERSION).tar $(BASEEXT) && compress DBI-$(VERSION).tar
	@chmod -w ../DBI-$(VERSION).tar.Z
	mv ../DBI-$(VERSION).tar.Z $$HOME/perl/db/DBI/
	@cd $$HOME/perl/db/DBI; pwd; ls -l DBI-*.Z
';
}

*{"MY::distclean"} = \&MY::dist;    # remain compatible with 5.001

# end.
