/*
 * Filename: msql-import.h
 * Project:  msql-import
 *
 * Function: This program reads the contents of a flat file
 *           and loads it into a Mini SQL table.
 *           The program does not create the MiniSQL table,
 *           it must have been created beforehand.  msql-import
 *           simply sends INSERTs to the database server.
 *
 *           When importing a flat fiel that was created in
 *           the DOS world, make sure you convert the file
 *           to unix by replacing CR/LF with LF only.
 *
 * Author:   Pascal Forget <pascal@wsc.com>
 *
 * Copyright (C) 1995-1996 Pascal Forget.  All Rights Reserved
 *
 * PASCAL FORGET MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY
 * OF THIS SOFTWARE FOR ANY PURPOSE.  IT IS SUPPLIED "AS IS"
 * WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for any purpose and without fee is
 * hereby granted, provided that the above copyright notice
 * appear in all copies of the software.
 */

#ifndef MSQLIMPORT_H__
#define MSQLIMPORT_H__

#include "msql.h"
#include <stdio.h>
#include <stdlib.h>

typedef struct {
    char *buffer;
    unsigned int capacity;
} SafeString;

/* SafeString functions */
void append_character(SafeString *str, char c);
void append_string_buffer(SafeString *str, const char *newBuffer);
void copy_string_buffer(SafeString *str, const char *newBuffer);
SafeString *create_string(void);
void set_string_buffer(SafeString *str, char *newBuffer);
void set_string_capacity(SafeString *str, unsigned int cap);

void abort_import(int exitCode);
void alarm_msql(void);
void alarm_msg(const char *message);
char *append_string(char *s, const char *append);
char *backslashify_special_chars(const char *s);
int *datatypes(const char *table, const char *fields);
char *format_delimiter(const char *str);
char *get_record(FILE *fp, const char record_delimiter, SafeString *record);
void import_file(char *table,
		char *path,
		char *fieldDel,
		char *rowDel,
		const char *fields);
int insert_record(const char *table,
		  char *record,
		  const char *fields,
		  int *types,
		  int recordCount,
		  char *fieldDel);
void main(int argc, char **argv);
int row_length(const char *table_name);
char *str_parse(char **str, char *delimiters);
char *safe_c_string_copy(const char *s);
#endif
