/*    imaginary.sql.iMsqlDriver
 *    from the Imaginary Java Class Library
 *    Copyright (c) 1996 George Reese
 *    created by George Reese (borg@imaginary.com) 960311
 *    a JDBC compliant mSQL driver
 */

package imaginary.sql;

import java.sql.Connection;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;

/**
 * This class is the JDBC driver implementation of a the mSQLJava 1.1.1
 * API by Darryl Collins.
 *
 * @see java.sql.Driver
 * @version 1.6, 96/06/05
 * @author George Reese
 */
public class iMsqlDriver implements java.sql.Driver {
  /**
   * Constructs a new driver and registers it with
   * java.sql.DriverManager.registerDriver() as specified by the JDBC
   * draft protocol.
   */
  public iMsqlDriver() throws SQLException {
    java.sql.DriverManager.registerDriver(this);
  }

  /**
   * Takes a look at the given URL to see if it is meant for this
   * driver.  If not, simply return null.  If it is, then go ahead and
   * connect to the database.  For the mSQL implementation of JDBC, it
   * looks for URL's in the form of <P>
   * <PRE>
   *     jdbc:msql://[host_addr]:[port]/[db_name]
   * </PRE>
   * @see java.sql.Driver#connect
   * @param url the URL for the database in question
   * @param info the properties object
   * @return null if the URL should be ignored, a new Connection
   * implementation if the URL is a valid mSQL URL
   */
  public Connection connect(String url, Properties info)
       throws SQLException {
    String host, database, tmp;
    int i, j, port, len = url.length();
    boolean root;
    
    if( len < 8 ) return null;
    tmp = url.substring(5, 9);
    if( !tmp.equals("msql") ) return null;
    i = url.indexOf(':', 11);
    if( i == -1 ) {
      j = url.indexOf('/', 12);
      host = url.substring(12, j);
      port = 1112;
    }
    else if( len < (i+2) ) {
      throw new SQLException("Invalid URL: URL must specify a connect port.");
    }
    else {
      host = url.substring(12, i++);
      j = url.indexOf('/', i);
      tmp = url.substring(i, j);
      try {
	port = Integer.valueOf(tmp).intValue();
      }
      catch( NumberFormatException e ) {
	throw new SQLException("Invalid port in URL: " + e.getMessage());
      }
    }
    if( port == 1112 ) root = true;
    else root = false;
    database = url.substring(j+1);
    return new iMsqlConnection(host, root, info.getProperty("user"),
			       database, url, this);
  }

  /**
   * Returns true if the driver thinks that it can open a connection
   * to the given URL.  Typically drivers will return true if they
   * understand the sub-protocol specified in the URL and false otherwise.
   *
   * @param url The URL of the database.
   * @return True if this driver can connect to the given URL.
   */
  public boolean acceptsURL(String url) throws SQLException {
    if( url.length() < 10 ) return false;
    return url.substring(5,9).equals("msql");
  }

  /**
   * <p>The getPropertyInfo method is intended to allow a generic GUI tool to\

   * discover what properties it should prompt a human for in order to get
   * enough information to connect to a database.  Note that depending on
   * the values the human has supplied so far, additional values may become
   * necessary, so it may be necessary to iterate though several calls
   * to getPropertyInfo.
   *
   * @param url The URL of the database to connect to.
   * @param info A proposed list of tag/value pairs that will be sent on
   *          connect open.
   * @return An array of DriverPropertyInfo objects describing possible
   *          properties.  This array may be an empty array if no properties
   *          are required.
   */
  public DriverPropertyInfo[] getPropertyInfo(String url,
					      java.util.Properties info)
       throws SQLException {
    return new DriverPropertyInfo[0];
  }
				
  /**
   * Gives the major version for this driver as required by the JDBC
   * draft specification.
   * @see java.sql.Driver#getMajorVersion
   * @return the major version
   */
  public int getMajorVersion() {
    return 0;
  }

  /**
   * Gives the minor version for this driver as required by the JDBC
   * draft specification.
   * @see java.sql.Driver#getMinorVersion
   * @return the minor version
   */
  public int getMinorVersion() {
    return 9;
  }

  /**
   * Returns information noting the fact that the mSQL database is not
   * SQL-92 and thus cannot support a JDBC compliant implementation.
   */
  public boolean jdbcCompliant() {
    return false;
  }
}
