//
// Msql client library for JAVA
// Copyright (C) 1995 Darryl Collins <darryl@minmet.uq.oz.au>
// This software is provided "as is" without any expressed or implied warranty.
//
// This package implements a client for the mSQL server designed and
// implemented by David Hughes <bambi@hughes.com.au>
//
// $Log: MsqlRow.java,v $
// Revision 1.1.1  1996/02/15 06:12:39  root
// Initial revision
//
//

// package msql;

import java.awt.*;
import java.lang.*;
import java.io.*;
import java.net.*;
import java.util.*;

/**
 * MsqlFieldDesc - description of a table column.
 */
public class MsqlFieldDesc {

	String tableName;
	String fieldName;
	int fieldType;
	int fieldLength;
	boolean fieldNonNull;
	boolean fieldKey;

/**
 * MsqlFieldDesc - Constructs a Field Desc from an array of strings.
 */
	public MsqlFieldDesc(String row[]) {

		tableName = new String(row[0]);
		fieldName = new String(row[1]);
		fieldType = Integer.parseInt(row[2]);
		fieldLength = Integer.parseInt(row[3]);

		if(row.length >= 5 && row[4].equals("Y")) fieldNonNull = true;
		else fieldNonNull = false;

		if(row.length >= 6 && row[5].equals("Y")) fieldKey = true;
		else fieldKey = false;
	}


/**
 * Return name of base table containing this field.
 */
	public String TableName() { return tableName; }

/**
 * Return the name of this field.
 */
	public String FieldName() { return fieldName; }

/**
 * Return the type of this field.
 */
	public int FieldType() { return fieldType; }

/**
 * Return the length of this field.
 */
	public int FieldLength()  { return fieldLength; }

/**
 * Return the NonNull flag for ths field.
 */
	public boolean NonNull()  { return fieldNonNull; }

/**
 * Return the Key flag for this field.
 */
	public boolean IsKey()	   { return fieldKey; }

/**
 * MsqlFieldDesc - Constructs a Field Desc from an array of strings.
 */
	public String toString() {
		
		return new String(
			tableName+"\t"+fieldName+"\t"+fieldType+"\t"+
			fieldLength+"\t"+fieldNonNull+"\t"+
			fieldKey
		);
	}
}
