/*
**      errmsg.h  - Error messages
**
**
** Copyright (c) 1993-95  David J. Hughes
** Copyright (c) 1995  Hughes Technologies Pty Ltd
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
**
** This software is provided "as is" without any expressed or implied warranty.
**
** ID = "$Id:"
**
*/

/*
** German translations by Nils Faerber <gl055@appl2.hrz.uni-siegen.de>
** updated by Dirk Ohme (Dirk.Ohme@transtec.de)
*/

/*
** French translations by F.X. Menard <menard@ccrv.obs-vlfr.fr>
** inserted by Dirk Ohme (Dirk.Ohme@transtec.de)
*/



/*************************************************************************
**
**      ENGLISH MESSAGES
**
*/

#ifdef ENGLISH

   /* CLIENT LIBRARY MESSAGES */

#  define SOCKET_ERROR          "Can't create UNIX socket"
#  define CONNECTION_ERROR      "Can't connect to local MSQL server"
#  define IPSOCK_ERROR          "Can't create IP socket"
#  define UNKNOWN_HOST          "Unknown MSQL Server Host (%s)"
#  define CONN_HOST_ERROR       "Can't connect to MSQL server on %s"
#  define SERVER_GONE_ERROR     "MSQL server has gone away"
#  define UNKNOWN_ERROR         "Unknown MSQL error"
#  define PACKET_ERROR          "Bad packet received from server"
#  define USERNAME_ERROR        "Can't find your username. Who are you?"
#  define VERSION_ERROR         \
                "Protocol mismatch. Server Version = %d Client Version = %d"

   /* SERVER MESSAGE */

#  define CON_COUNT_ERROR       "Too many connections"
#  define BAD_HOST_ERROR        "Can't get hostname for your address"
#  define HANDSHAKE_ERROR       "Bad handshake"
#  define ACCESS_DENIED_ERROR   "Access to database denied"
#  define NO_DB_ERROR           "No Database Selected"
#  define PERM_DENIED_ERROR     "Permission denied"
#  define UNKNOWN_COM_ERROR     "Unknown command"
#  define BAD_DIR_ERROR         "Can't open directory \"%s\""
#  define BAD_TABLE_ERROR       "Unknown table \"%s\""
#  define TABLE_READ_ERROR      "Error reading table \"%s\" definition"
#  define TMP_MEM_ERROR         "Out of memory for temporary table"
#  define TMP_CREATE_ERROR      "Couldn't create temporary table"
#  define DATA_OPEN_ERROR       "Couldn't open data file for %s"
#  define KEY_OPEN_ERROR        "Couldn't open key file for %s"
#  define STACK_OPEN_ERROR      "Couldn't open stack file for %s"
#  define WRITE_ERROR           "Data write failed"
#  define KEY_WRITE_ERROR       "Write of key failed"
#  define SEEK_ERROR            "Seek into data table failed!"
#  define KEY_SEEK_ERROR        "Seek into key table failed!"
#  define BAD_NULL_ERROR        "Field \"%s\" cannot be null"
#  define FIELD_COUNT_ERROR     "Too many fileds in query"
#  define TYPE_ERROR            "Literal value for \'%s\' is wrong type"
#  define BAD_FIELD_ERROR       "Unknown field \"%s.%s\""
#  define BAD_FIELD_2_ERROR     "Unknown field \"%s\""
#  define COND_COUNT_ERROR      "Too many fields in condition"
#  define ORDER_COUNT_ERROR     "Too many fields in order specification"
#  define BAD_LIKE_ERROR        "Evaluation of LIKE clause failed"
#  define UNQUAL_ERROR          "Unqualified field in comparison"
#  define BAD_TYPE_ERROR        "Bad type for comparison of '%s'"
#  define INT_LIKE_ERROR        "Can't perform LIKE on int value"
#  define REAL_LIKE_ERROR       "Can't perform LIKE on real value"
#  define BAD_DB_ERROR          "Unknown database \"%s\""
#  define TABLE_EXISTS_ERROR    "Table \"%s\" exists"
#  define TABLE_FAIL_ERROR      "Can't create table \"%s\""
#  define TABLE_WIDTH_ERROR     "Too many fields in table (%d Max)"
#  define CATALOG_WRITE_ERROR   "Error writing catalog"
#  define KEY_CREATE_ERROR      "Creation of key table failed"
#  define DATA_FILE_ERROR       "Error creating table file for \"%s\""
#  define BAD_TABLE_ERROR       "Unknown table \"%s\""
#  define NO_VALUE_ERROR        "No value specified for field '%s'"
#  define NON_UNIQ_ERROR        "Field '%s' not unique"
#  define KEY_UNIQ_ERROR        "Non unique key value in field '%s'"
#  define UNSELECT_ERROR        "Reference to un-selected table \"%s\""
#  define UNQUAL_JOIN_ERROR     "Unqualified field \"%s\" in join"
#  define SIZE_ERROR            "Value for field \'%s\' is too large"

#endif



/*************************************************************************
**
**      GERMAN MESSAGES
**
*/


#ifdef GERMAN

   /* CLIENT LIBRARY MESSAGES */

#  define SOCKET_ERROR          "Kann UNIX-Socket nicht anlegen"
#  define CONNECTION_ERROR      "Keine Verbindung zu lokalem MSQL Server"
#  define IPSOCK_ERROR          "Kann IP-Socket nicht anlegen"
#  define UNKNOWN_HOST          "Unbekannter MSQL Server Host (%s)"
#  define CONN_HOST_ERROR       "Keine Verbindung zu MSQL Server auf %s"
#  define SERVER_GONE_ERROR     "MSQL Server nicht vorhanden"
#  define UNKNOWN_ERROR         "Unbekannter MSQL Fehler"
#  define PACKET_ERROR          "Fehlerhaftes Paket von Server empfangen "
#  define USERNAME_ERROR        "Kann Usernamen nicht herausfinden."
#  define VERSION_ERROR         \
                "Protokolle ungleich. Server Version = % d Client Version = %d"


   /* SERVER MESSAGE */

#  define CON_COUNT_ERROR       "zuviele Verbindungen offen"
#  define BAD_HOST_ERROR        "kann Hostnamen zur IP-Adresse auflsen"
#  define HANDSHAKE_ERROR       "Fehler beim Verbindungsaufbau"
#  define ACCESS_DENIED_ERROR   "Zugriff auf Datenbank nicht gestattet"
#  define NO_DB_ERROR           "keine Datenbank ausgewhlt"
#  define PERM_DENIED_ERROR     "Zugriff verweigert"
#  define UNKNOWN_COM_ERROR     "unbekanntes Kommando"
#  define BAD_DIR_ERROR         "kann Verzeichnis \"%s\" nicht finden"
#  define BAD_TABLE_ERROR       "unbekannte Tabelle \"%s\""
#  define TABLE_READ_ERROR      "Fehler beim Lesen der Tabellendefinition von \"%s\""
#  define TMP_MEM_ERROR         "kann temporre Tabelle mangels Speicher nicht anlegen"
#  define TMP_CREATE_ERROR      "kann temporre Tabelle nicht anlegen"
#  define DATA_OPEN_ERROR       "kann Datendatei fr %s nicht ffnen"
#  define KEY_OPEN_ERROR        "kann Verweisdatei zu %s nicht ffnen"
#  define STACK_OPEN_ERROR      "kann Stapeldatei zu %s nicht ffnen"
#  define WRITE_ERROR           "Fehler beim Schreiben von Daten"
#  define KEY_WRITE_ERROR       "Schreiben eines Verweises gescheitert"
#  define SEEK_ERROR            "Suche in Datendatei milungen!"
#  define KEY_SEEK_ERROR        "Suche in Verweisdatei milungen!"
#  define BAD_NULL_ERROR        "Feld \"%s\" kann nicht NULL sein"
#  define FIELD_COUNT_ERROR     "zuviele Felder in Suchkommando"
#  define TYPE_ERROR            "Feld \'%s\' mit falschem Datentyp"
#  define BAD_FIELD_ERROR       "unbekanntes Feld \"%s.%s\""
#  define BAD_FIELD_2_ERROR     "unbekanntes Feld \"%s\""
#  define COND_COUNT_ERROR      "zuviele Felder im Vergleich angegeben"
#  define ORDER_COUNT_ERROR     "zuviele Felder in der Sortierreihenfolge"
#  define BAD_LIKE_ERROR        "Ausdruck bei LIKE konnte nicht aufgelst werden"
#  define UNQUAL_ERROR          "nicht qualifizierter Ausdruck"
#  define BAD_TYPE_ERROR        "falsche Typ bei Vergleich mit '%s'"
#  define INT_LIKE_ERROR        "kann LIKE nicht auf Ganzahlen anwenden"
#  define REAL_LIKE_ERROR       "kann LIKE nicht auf Fliekommazahlen anwenden"
#  define BAD_DB_ERROR          "unbekannte Datenbank \"%s\""
#  define TABLE_EXISTS_ERROR    "Tabelle \"%s\" existiert (bereits)"
#  define TABLE_FAIL_ERROR      "kann Tabelle \"%s\" nicht anlegen"
#  define TABLE_WIDTH_ERROR     "zuviele Felder in der Tabelle (max. %d)"
#  define CATALOG_WRITE_ERROR   "Fehler beim Schreiben der Katalogdatei"
#  define KEY_CREATE_ERROR      "Erzeugung der Verweisdatei milungen"
#  define DATA_FILE_ERROR       "Fehler beim Erzeugen der Tabelle fr \"%s\""
#  define BAD_TABLE_ERROR       "unbekannte Tabelle \"%s\""
#  define NO_VALUE_ERROR        "kein Wert fr Feld '%s' angegeben"
#  define NON_UNIQ_ERROR        "Feld '%s' ist nicht eindeutig"
#  define KEY_UNIQ_ERROR        "nicht eindeutiger Wert in Feld '%s'"
#  define UNSELECT_ERROR        "Referenz zu nicht selektierter Tabelle \"%s\""
#  define UNQUAL_JOIN_ERROR     "nicht qualifiziertes Feld \"%s\" in join"
#  define SIZE_ERROR            "Wert fr Feld \'%s\' ist zu gro"

#endif



/*************************************************************************
**
**      FRENCH MESSAGES
**
*/

#ifdef FRENCH

   /* CLIENT LIBRARY MESSAGES */

#  define SOCKET_ERROR            "Ne peux creer la chaussette UNIX"
#  define CONNECTION_ERROR        "Ne peux me connecter au serveur mSQL local"
#  define IPSOCK_ERROR            "Ne peux creer la chaussette IP"
#  define UNKNOWN_HOST            "La machine serveur de mSQL (%s) est inconnue"
#  define CONN_HOST_ERROR \
                "Ne trouve pas de serveur mSQL sur la machine %s"
#  define SERVER_GONE_ERROR       "Le serveur mSQL s'est deconnecte"
#  define UNKNOWN_ERROR           "Erreur mSQL inconnue"
#  define PACKET_ERROR            "Recu du serveur un paquet en erreur"
#  define USERNAME_ERROR  \
                "Ne peux trouver votre nom d'utilisateur. Qui etes-vous?"
#  define VERSION_ERROR           \
                "Protocoles differents: version serveur = %d, version client = %d"

   /* SERVER MESSAGES */

#  define CON_COUNT_ERROR "Trop de connections"
#  define BAD_HOST_ERROR  \
                "Ne peux deduire votre nom de machine de votre adresse"
#  define HANDSHAKE_ERROR "Mauvaise poignee de main"
#  define ACCESS_DENIED_ERROR     "Acces refuse a la base de donnees"
#  define NO_DB_ERROR             "Pas de base de donnees selectionnee"
#  define PERM_DENIED_ERROR       "Permission refusee"
#  define UNKNOWN_COM_ERROR       "Commande inconnue"
#  define BAD_DIR_ERROR           "Ne peux ouvrir le repertoire \"%s\""
#  define BAD_TABLE_ERROR "Table \"%s\" inconnue"
#  define TABLE_READ_ERROR        \
                "Erreur a la lecture de la definition de la table \"%s\""
#  define TMP_MEM_ERROR           "Depassement memoire pour une table"
#  define TMP_CREATE_ERROR        "N'ai pu creer une table temporaire"
#  define DATA_OPEN_ERROR "N'ai pu ouvrir un fichier de donnees pour %s"
#  define KEY_OPEN_ERROR  "N'ai pu ouvrir un fichier de cles pour %s"
#  define STACK_OPEN_ERROR        "N'ai pu ouvrir un fichier de piles pour %s"
#  define WRITE_ERROR             "Echec d'ecriture de donnees"
#  define KEY_WRITE_ERROR "Echec d'ecriture de cle"
#  define SEEK_ERROR              "Echec de la recherche dans la table de donnees!"
#  define KEY_SEEK_ERROR  "Echec de la recherche dans la table de cles!"
#  define BAD_NULL_ERROR  "Le champ \"%s\" ne peut etre NULL"
#  define FIELD_COUNT_ERROR       "Trop de champs dans la requete"
#  define TYPE_ERROR              "Type errone dans la valeur litterale de \"%s\""
#  define BAD_FIELD_ERROR "Champ \"%s.%s\" inconnu"
#  define BAD_FIELD_2_ERROR       "Champ \"%s\" inconnu"
#  define COND_COUNT_ERROR        "Trop de champs dans la condition"
#  define ORDER_COUNT_ERROR       "Trop de champs dans la clause de classement"
#  define BAD_LIKE_ERROR  "Echec de l'evaluation de la clause LIKE"
#  define UNQUAL_ERROR            "Champ non qualifie dans la comparaison"
#  define BAD_TYPE_ERROR  "Type errone pour la comparaison de '%s'"
#  define INT_LIKE_ERROR  "Ne peux appliquer LIKE sur un entier"
#  define REAL_LIKE_ERROR "Ne peux appliquer LIKE sur un reel"
#  define BAD_DB_ERROR            "Base de donnees \"%s\" inconnue"
#  define TABLE_EXISTS_ERROR      "La table \"%s\" existe"
#  define TABLE_FAIL_ERROR        "Ne peux creer la table \"%s\""
#  define TABLE_WIDTH_ERROR       "Trop de champs dans la table (%d max)"
#  define CATALOG_WRITE_ERROR     "Erreur a l'ecriture du catalogue"
#  define KEY_CREATE_ERROR        "Echec de la creation de la table de cles"
#  define DATA_FILE_ERROR \
                "Echec a la creation du fichier de table pour \"%s\""
#  define BAD_TABLE_ERROR "Table \"%s\" inconnue"
#  define NO_VALUE_ERROR  "Pas de valeur specifiee pour le champ \"%s\""
#  define NON_UNIQ_ERROR  "Champ \"%s\" non unique"
#  define KEY_UNIQ_ERROR  "Valeur de cle non unique dans le champ \"%s\""
#  define UNSELECT_ERROR  "Reference sur une table non selectionnee \"%s\""
#  define UNQUAL_JOIN_ERROR       "Champ \"%s\" non qualifie dans la jointure"
#  define SIZE_ERROR              "Trop de champs \"%s\" dans la valeur"

#endif


