/******************************************************************************
	  CCCC	    A	  BBBBB	  L	EEEEE  N     N	EEEEE	TTTTTTT
	 C    C    A A	  B    B  L	E      NN    N	E	   T
	C	  A   A	  B    B  L	E      N N   N	E	   T
	C	 AAAAAAA  BBBBB	  L	EEEEE  N  N  N	EEEEE	   T
	C        A     A  B    B  L	E      N   N N	E	   T
	 C    C  A     A  B    B  L	E      N    NN  E 	   T
	  CCCC	 A     A  BBBBB	  LLLL	EEEEE  N     N	EEEEE	   T
*******************************************************************************

CableNet Source Module:
	Copyright 1994-1995 (C) CableNet Limited. All Rights Reserved.

    Module Name:		$RCSfile: Error.c,v $
    Module Description:	Error message output routine

Description: 

Edit History:

	$Log: Error.c,v $
 * Revision 1.2  1996/04/04  11:16:50  damian
 * don't declare extern sys_errlist in freebsd
 *
 * Revision 1.1  1995/08/29  10:15:34  damian
 * Initial revision
 *


*/

/* RCS identification string (for "what" program) */
static char moduleRCSid[] = "@(#) $Id: Error.c,v 1.2 1996/04/04 11:16:50 damian Exp $";

/* must come first header files */
#include "V.h"			/* virtual header file */
#include "Vport.h"		/* port header file */

/*
 * system header files 
*/
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <time.h>
#include <errno.h>
#include <syslog.h>

#ifdef VANSI_1
#include <stdarg.h>
#else
#include <varargs.h>
#endif

#ifdef Vsunos40
#include "Vansi.h"
#endif

#include "Vlib.h"


/*
 * Exported variables.
 */
char Vusrmsg[4096];	/* program message buffer */


/* standard error message envelope */
static char errtext[] = "%sProgram: %s (%u)\n\t%s\n\tErrno = %d [%s]\n";


/* time (includes newline), program, PID
   error message, UNIX errno, error desc */

#ifndef Vfreebsd
extern char *sys_errlist[];
#endif

extern char *Vprogram;

extern int sys_nerr;

char *
Vstrerror(int errnum)
{
    if ( errnum >= sys_nerr ) 
	return NULL;

    return sys_errlist[errnum];
}
