/******************************************************************************
	  CCCC	    A	  BBBBB	  L	EEEEE  N     N	EEEEE	TTTTTTT
	 C    C    A A	  B    B  L	E      NN    N	E	   T
	C	  A   A	  B    B  L	E      N N   N	E	   T
	C	 AAAAAAA  BBBBB	  L	EEEEE  N  N  N	EEEEE	   T
	C        A     A  B    B  L	E      N   N N	E	   T
	 C    C  A     A  B    B  L	E      N    NN  E 	   T
	  CCCC	 A     A  BBBBB	  LLLL	EEEEE  N     N	EEEEE	   T
*******************************************************************************

CableNet Source Module:
	Copyright 1994-1995 (C) CableNet Limited. All Rights Reserved.

    Module Name:		$RCSfile: Vlib.h,v $
    Module Description:	Virtual library header file


Description: 


Edit History:

	$Log: Vlib.h,v $

*/

/* RCS identification string (for "what" program) 
static char moduleRCSid[] = "@(#) $Id: Vlib.h,v 2.4 1996/02/02 12:16:52 damian Exp $";
*/


#ifndef _VLIB_H
#define _VLIB_H

#include "V.h"
#include "Vport.h"


#include <stdio.h>

#include "Vllist.h"

/*
 library to program message buffer 
 this is used by library modules to communicate long text messages to 
 calling applications.  A 4k buffer is declared in Error.c 
 which I'm sure is big enough to never ever cause a SIGSEGV
 :-)

*/

extern char Vusrmsg[];  


/*  application command line processing stuff */
/*
  VappSetupArgs     flag bits

  bits  0-15  control bits

  bits  16-31 value bits

*/

#define VARG_MANDATORY       0x01    /* if set arg is mandatory */
#define VARG_MANDATORY_SET   0x02    /* if set arg is part of a mandatory set */
#define VARG_FAILTRUE        0x04    /* if set fail if evaluation func is true */
#define VARG_FAILFALSE       0x00    /* opposite of FAILTRUE so bit is not set */
#define VARG_EXITFAIL        0x08    /* if set exit if validation fails */
#define VARG_PRNUSAGE        0x10    /* if set print usage for this arg */
#define VARG_POSITION        0x20    /* if set arg is position dependent 
					(top 8 bits determine position ) */


/*  define control bits for args to VappInit */
#define V_NORMAL_INIT       0
#define VARG_NOVERSION      0x01 /* don't print program name and version */
#define VARG_LOGFILE        0x02 /* create a logfile for redirected stderr */
#define VARG_USAGE          0x04 /* don't print usage when exiting */
#define VARG_DFLTS          0x08 /* open defaults area */



typedef struct VargInfo     *VargInfoPtr; 
        

/* this structure is used to process command line arguments.  It can be used
   to identify command line options and also their arguments.  An option
   argument is kept in a distinct arginfo item because this may have nothing
   to do with the preceding option identifier, it may be a positional
   argument in it's own right.  How it is viewed will be determined by 
   subsequent interrogation of the argument list.  If a process asks for
   an option's argument then it will get the next argument that came on the
   command line (as long as it wasn't an option itself) */

/* 

The following command line will produce this list of arginfo items;

   %foo  -dbase -P 1234 -f berks.tar -Wall -Wnobackup -verbose 1000a.c1

a)   -dbase will produce { 1, 'd', "dbase", "base", NULL, 0, NULL, NULL }
b)   -P     will produce { 2, 'P', NULL, "1234", &c, 0, NULL, NULL }
c)   1234   will produce { 3, '\0', NULL, "1234", NULL, 0, NULL, NULL }
d)   -f     will produce { 4, 'f', NULL, "berks.tar", &e, NULL, 0, NULL, NULL }
e)   berks.tar  ==       { 5, '\0', NULL, "berks.tar", NULL, 0, NULL, NULL }
f)   -Wall  will produce { 6, 'W', "Wall", "all", NULL, 0, &g, NULL }
g)   -Wnobackup ==       { 7, 'W', "Wnobackup", "nobackup", NULL, 0, NULL, &f }
h)   -verbose   ==       { 8, 'v', "verbose", "erbose", &i, 0, NULL, NULL }
i)   1000a.c1   ==       { 9, '\0', NULL, "1000a.c1", NULL, 0, NULL, NULL }


NB: this presumes no prior setup (which would affect the way things are
    interpreted)

*/

typedef struct VargInfo {
    int             argindex;	/*-- where this arg occured on the cmd line  */
    char            shortname;	/*-- single char identifier  */
    char            *longname;  /*-- long name identifier  */
    char            *value;	/*-- possible value for short identifier  */
    VargInfoPtr     optarg;	/*-- a possible argument to this option  */
    BitMask         flags;	/*-- control flags  */
    VargInfoPtr     next;	/*-- next option in this identifier's list */
    VargInfoPtr     prev;	/*-- previous option  --  ditto --  */
    int             mutexid;    /*-- mutual exclusion identifier */
/* the following items are setup prior to calling VappInit() */
    char            *range;	/*-- valid range for argument  */
    int             exval;      /*-- exit value if args fails validation */
    BOOLEAN         (*func)();  /*-- validation function */
    char            *desc;	/*-- short description of argument  */
} VargInfo ;



/* public function declarations */

/*
 * AppInit.c and AppArgs.c
 */

#ifdef VANSI_1
extern char     *VappInit( int *, char *[], char *, 
			  int (*)(), BitMask );
extern int      VappSetupArg( char * , char , char *, char *,
			     BOOLEAN (*)(), int, BitMask );
extern int      VappMutExclArgs( char *arg1, ... );
extern int      VappArgINT( char * );
extern char     *VappArgCHAR( char * );
extern int      VappArgPosINT( int  );
extern char     *VappArgPosCHAR( int );
extern int      VappArgPosition( char *, BOOLEAN );
extern char     *VappArgListScan( VargInfoPtr *);
extern VargInfoPtr     VappArgListStart( char * );
#else

extern int      VappSetupArg();	/* setup a named arg */
extern char     *VappArgsInit();	/* process command line */
extern int      VappMutExclArgs(); /* setup list of mutually exclusive args */
extern int      VappArgINT();		/* retrieve an integer argument */
extern char     *VappArgCHAR();	/* retrieve a char * argument */
extern int      VappArgPosINT();	/* get positional arg as an integer */
extern char     *VappArgPosCHAR(); /* get positional arg as a char pointer */
extern int      VappArgPosition();	/* get the position of an argument */
extern char     *VappArgListScan();
extern VargInfoPtr     VappArgListStart();
#endif

extern char     *ProgramName();
extern char     *GlobalDefaults();
extern char     *LocalDefaults();
extern char     *UserDefaults();
extern LLlist 	*VappArgList();	/* get handle on argument list */
extern void     VappGenericArgs();	/* accept set of generic args */


/* private function declarations */
#ifdef VANSI_1
extern VargInfoPtr _FindArgInfoLong( char *);
extern VargInfoPtr _FindArgInfoShort( int  );
extern VargInfoPtr _AddNewArgInfo( char *, int );
#else
extern VargInfoPtr _FindArgInfoLong();
extern VargInfoPtr _FindArgInfoShort();
extern VargInfoPtr _AddNewArgInfo();
#endif


/* debug mask bits */

/* user class or library class */
#define VLT_LIB            0x02
#define VLT_USER           0x00

/* class of message, info, warn or error */
#define VLT_INFO           0x04
#define VLT_WARN           0x08
#define VLT_ERROR          0x10

#define VLT_EXEC           0x20
#define VLT_READ           0x40
#define VLT_WRITE          0x80

#define VLT_ADD            0x100
#define VLT_DEL            0x200

#define VLT_TIME           0x400  /* print the time */
#define VLT_PID            0x800  /* print the process pid */

/* some module specific defs */
#define VLT_DFLTSET        0x1000
#define VLT_DFLTGROUP      0x2000


/*
 *  DbgTrace.c
 */

#ifdef VANSI_1
extern void     LTRACE( BitMask mask, ... );
extern void     FTRACE( char *fmt, ...  );
extern void     FTRACEON(void);
extern void     DbgSetLvl( BitMask mask );
extern void     DbgAddLvl( BitMask mask );
extern void     AddLtraceLevel (BitMask);
extern void     AddDebugMode (BitMask);
extern void     SetLtraceLevel (BitMask);
extern void     SetLogFile (int fd);
extern void     SetLogFunction (int (*fd)(char *));
extern void     SetDebugMode (BitMask);
extern void     SetRecoveryMode (BitMask);
extern void     SetStracePattern (char *);
extern void     SetStraceWindow (int);
extern void     SetStraceCase (int);
extern BitMask  DebugMode (void);
extern BitMask  LtraceLevel (void);
extern BitMask  RecoveryMode(void);
#else
extern void     LTRACE( /* BitMask mask, char *fmt, ...*/ );
extern void     FTRACE( /* char *fmt, ... */ );
extern void      DbgSetLvl();
extern void      DbgAddLvl();
extern void     AddLtraceLevel ();
extern void     AddDebugMode ();
extern void     SetLtraceLevel ();
extern void     SetLogFunction (int (*fd)(char *));
extern void     SetLogFile (int fd);
extern void     SetDebugMode ();
extern void     SetRecoveryMode ();
extern void     SetStracePattern ();
extern void     SetStraceWindow ();
extern void     SetStraceCase ();
extern BitMask  DebugMode ();
extern BitMask  RecoveryMode();
#endif


#ifdef __STDC__
typedef void (*VusageFunc)(char * progname );
#else
typedef void (*VusageFunc)();
#endif


#define     ANY_DFLT_SET        0
#define     GLOBAL_DFLT_SET     1
#define     LOCAL_DFLT_SET      2
#define     USER_DFLT_SET       3

typedef struct DfltsInfo {
    char    *set;
    char    *group;
    char    *tag;
    char    *val;
    int     num;
    int     base;
} DfltsInfo;

/*
 *  Defaults.c 
 */

#ifdef __STDC__
extern int DfltsInit(void);
extern int DfltSetBaseSet( DfltsInfo *di );
extern char  *DfltGetBaseSet( int);
extern char *DfltGetCurrentSet(int);
extern char *DfltGetCurrentGroup(int);
extern int DfltSetCurrentGroup( DfltsInfo *di );
extern int DfltSetCurrentSet( DfltsInfo *di );
extern int DfltSetString( DfltsInfo *di );
extern char *DfltGetString( DfltsInfo *di );
extern int DfltSetInt( DfltsInfo *di );
extern int DfltGetInt( DfltsInfo *di );
extern char *DfltGetSet( DfltsInfo *di );
extern int DfltGetBool( DfltsInfo *di );
extern char *DfltGetGroup( DfltsInfo *di );
extern int DfltDeleteGroup(char *path);
#else
extern int DfltSetBaseSet();
extern char *DfltGetBaseSet();
extern int DfltsInit();
extern char *DfltGetCurrentSet();
extern char *DfltGetCurrentGroup();
extern int DfltSetCurrentGroup();
extern int DfltSetCurrentSet();
extern int DfltSetString();
extern char *DfltGetString();
extern int DfltSetInt();
extern int DfltGetInt();
extern char *DfltGetSet();
extern int DfltGetBool();
extern char *DfltGetGroup();
extern int DfltDeleteGroup();
#endif

/*
 * Memory.c  
 */
#ifdef VANSI_1
extern char     *CopyString( char *string );
extern void     Free( void *arg );
extern void     *Malloc( size_t n );
extern void     *Realloc( void *old, size_t size );
extern void     *Calloc(size_t nobj,size_t size);
extern void	Memset( void *, int, size_t );
#else
extern char     *CopyString();
extern void     Free();
extern void     *Malloc();
extern void     *Realloc();
extern void     *Calloc();
extern void	Memset();

#endif

/*  debugging functions provided in Memory.c for debugging memory 
    allocations etc. */

extern int PrintFullMemoryUsage();
extern int PrintUsedMemory();
extern int SwitchOnDebuggingMemory();
extern int SwitchOffDebuggingMemory();


/*
 *   StringList.c
 */

#ifdef __STDC__
extern StringList       CreateStringList(int num);
extern void             DestroyStringList(StringList list);
extern StringList       ExtendStringList(StringList list, int *newnum);
extern int              CountStringList( StringList list);
#else
extern StringList       CreateStringList();
extern void             DestroyStringList();
extern StringList       ExtendStringList();
extern int              CountStringList();
#endif


/*
 * StrUtils.c
 */
#ifdef VANSI_1
extern char     *EndOfString( char * string );
extern void     StripLTBlanks( char *s );
extern int      CountWords( char *str );
extern int      CountWordsInString( char *str );
extern int      CountWordsInStringList( StringList list );
extern char     *UpperStr( char *str );
extern char     *LowerStr( char *str );
extern char     *strcasestr( char *str1, char *str2 );
extern int      PosStringDiff( char *str1, char *str2 );
extern int      NumCharInString( char *string, char ch );
extern char     *TerminateAtNextChar( char *str, char *seps );
extern int      StringToArgVector( char *str, char *argv[0] );
#else
extern char     *EndOfString();
extern void     StripLTBlanks();
extern int      CountWords();
extern int      CountWordsInString();
extern int      CountWordsInStringList();
extern char     *UpperStr();
extern char     *strcasestr();
extern int      PosStringDiff();
extern int      NumCharInString();
extern char     *TerminateAtNextChar();
extern int      StringToArgVector();
#endif

/* TagValue.c */


typedef struct _TagDef
{
    char *tag;
    char *val;
} TagDef;

#ifdef VANSI_1
extern TagDef *CreateTagDef( char *tag, char *val );
extern void DestroyTagDef( TagDef *tg );
extern LLlist *CreateTagValueLLlist(void);
extern int  AddTagValueToLLlist(LLlist *list, char *tag, char *val);
extern void InitTagValueScan(LLlist *list);
extern int GetNextTagValuePair(LLlist *list, char **tag, char **val);
extern char *FindTagValue(LLlist *list, char *tag);
extern int  SeperateTagAndValue (char *str, char **tag, char **val);
#else
extern TagDef *CreateTagDef();
extern void DestroyTagDef();
extern LLlist *CreateTagValueLLlist();
extern int  AddTagValueToLLlist();
extern void InitTagValueScan();
extern int GetNextTagValuePair();
extern char *FindTagValue();
extern int  SeperateTagAndValue ();

#endif

#endif  /* _VLIB_H_ */

