
SRCS = DfltsIntface.c DfltsPaths.c HashLList.c SimpleLList.c Error.c \
         StringList.c Memory.c AppInit.c AppArgs.c StrUtils.c TagValue.c \
         DbgTrace.c StrCase.c msqlacc.c

# for other databases replace msqlacc.c with other unit

TESTSRCS = test.c

LIBS = -lVdb -lmsql
DEFS =

VBASE = $(PROJECTROOT)
DBASELIB = /usr/local/Minerva/lib

LIST    = Vdb test

# use a sensible compiler
CC = gcc

VdbOBJECTS = ${SRCS:%.c=%.o}
all-Vdb: libVdb.a

libVdb.a: ${VdbOBJECTS} Imakefile
	${AR} libVdb.a ${VdbOBJECTS}
	${RANLIB} libVdb.a

install-Vdb: ${INSTALL_LIB}/lib//libVdb.a

${INSTALL_LIB}/lib//libVdb.a: libVdb.a
	${INSTALL} libVdb.a ${VBUILD_DIR}/lib/
	${RANLIB} ${INSTALL_LIB}/lib/libVdb.a
	chmod 644 ${INSTALL_LIB}/lib/libVdb.a

lib-Vdb: ${BUILD_DIR}/lib//libVdb.a

${BUILD_DIR}/lib//libVdb.a: libVdb.a
	${INSTALL} libVdb.a ${BUILD_DIR}/lib/
	${RANLIB} ${BUILD_DIR}/lib/libVdb.a
	chmod 644 ${BUILD_DIR}/lib/libVdb.a

debug-Vdb: libVdb.a
	${INSTALL} libVdb.a ${BUILD_DIR}/${DEBUGLIBDIR}
	${RANLIB} ${BUILD_DIR}/${DEBUGLIBDIR}/libVdb.a
	chmod 644 ${BUILD_DIR}/lib/libVdb.a

dbi-Vdb: libVdb.a
	${INSTALL} libVdb.a ${INSTALL_LIB}/${DEBUGLIBDIR}
	${RANLIB} ${INSTALL_LIB}/${DEBUGLIBDIR}/libVdb.a
	chmod 644 ${INSTALL_LIB}/lib/libVdb.a

cpp-Vdb: ${SRCS} ${SRCS:%.c=%.i} ${SRCS:%.cc=%.i} ${SRCS:%.C=%.i}

touch-Vdb:
	touch libVdb.a

Vdb: libVdb.a

depend-Vdb: SRCS
	@echo Generating dependancy list in .Vdb.depend ... ;
	$(RM) .Vdb.depend;
	${CC} ${DEBUGDEFINES} ${DEFINES} ${VINCLUDES} ${INCLUDES} -M \
	${SRCS} | awk '{print $$0}' > .Vdb.depend
	$(RM) .Vdb.dep;
	$(LN) .Vdb.depend .Vdb.dep;

.Vdb.dep:
	@if [ ! -f .Vdb.dep ]; then \
	echo "Getting copy of .dep file..."; \
	if [ ! -f .Vdb.depend ]; then \
	touch .Vdb.depend; \
	fi; \
	$(CP) .Vdb.depend .Vdb.dep; \
	fi

include .Vdb.dep

relink-Vdb: Vdb

clean-Vdb:
	${RM} Vdb ${VdbOBJECTS} *~ *.bak *.dep core
	-${VCLEAN}

testOBJECTS = ${TESTSRCS:%.c=%.o} ${CCSRCS:%.cc=%.o}
all-test: test

test: ${testOBJECTS} Imakefile
	${PRELINKER} ${CC} -o test ${testOBJECTS} ${DEBUGLIBPATH} ${MYLIBPATH} ${VLIBPATH} ${LIBS} ${LINKFLAGS} ${EXTRA_LOAD_FLAGS}

depend-test: TESTSRCS
	@echo Generating dependancy list in .test.depend ... ;
	$(RM) .test.depend;
	${CC} ${DEBUGDEFINES} ${DEFINES} ${VINCLUDES} ${INCLUDES} -M \
	${TESTSRCS} | awk '{print $$0}' > .test.depend
	$(RM) .test.dep;
	$(LN) .test.depend .test.dep;

.test.dep:
	@if [ ! -f .test.dep ]; then \
	echo "Getting copy of .dep file..."; \
	if [ ! -f .test.depend ]; then \
	touch .test.depend; \
	fi; \
	$(CP) .test.depend .test.dep; \
	fi

include .test.dep

install-test: ${INSTALL_DIR}/test

${INSTALL_DIR}/test: test
	${INSTALL} -c -s -m 755 test ${INSTALL_DIR}

bin-test: ${BUILD_DIR}/bin/test

${BUILD_DIR}/bin/test: test
	${INSTALL} test ${BUILD_DIR}/bin

debug-test: test
	${INSTALL} test ${BUILD_DIR}/${DEBUGBINDIR}

dbi-test: test
	${INSTALL} test ${INSTALL_DIR}/${DEBUGBINDIR}/

local-test: test
	${INSTALL} test /usr/local/bin/

remove-test:
	${RM} test

relink-test: remove-test test

pure-test: remove-test test

cpp-test: ${SRCS:%.c=%.i} ${SRCS:%.cc=%.i} ${SRCS:%.C=%.i}

touch-test:
	touch test

clean-test:
	${RM} test ${testOBJECTS} *~ *.bak *.dep core
	-${VCLEAN}

all: ${LIST:%=all-%}

install:: ${LIST:%=install-%}

depend:: ${LIST:%=depend-%}

lib:: ${LIST:%=lib-%}

bin:: ${LIST:%=bin-%}

debug:: ${LIST:%=debug-%}

dbi:: ${LIST:%=dbi-%}

local:: ${LIST:%=local-%}

relink:: ${LIST:%=relink-%}

pure:: ${LIST:%=pure-%}

clean:: ${LIST:%=clean-%}

touch:: ${LIST:%=touch-%}

cpp:: ${LIST:%=cpp-%}
