/******************************************************************************
	  CCCC	    A	  BBBBB	  L	EEEEE  N     N	EEEEE	TTTTTTT
	 C    C    A A	  B    B  L	E      NN    N	E	   T
	C	  A   A	  B    B  L	E      N N   N	E	   T
	C	 AAAAAAA  BBBBB	  L	EEEEE  N  N  N	EEEEE	   T
	C        A     A  B    B  L	E      N   N N	E	   T
	 C    C  A     A  B    B  L	E      N    NN  E 	   T
	  CCCC	 A     A  BBBBB	  LLLL	EEEEE  N     N	EEEEE	   T
*******************************************************************************

CableNet Source Module:
	Copyright 1994-1995 (C) CableNet Limited. All Rights Reserved.

    Module Name:		$RCSfile$
    Module Description:	Brief description of source module

Command Line Args: (for main program modules only)
    Arg      Param      Description

Description: 

Linked with: <file.c> .. <file.c>

Created on   17 May 1996    By damian

Edit History:

	$Log$


*/

/* RCS identification string (for "what" program) */
static char moduleRCSid[] = "@(#) $Id$";

/*
 * system header files 
*/
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <syslog.h>
#include <errno.h>

/*
 * third party headers ie, X, informix, ctree 
*/

/*
 * project header files 
*/

#include "Vlib.h"
#include "msql.h"
#include "Vdb.h"

/*
 * local header files 
*/

/*
 * local defines 
*/

/*
 * local typedefs 
*/

/*
 * static function declarations 
*/

/*
 * static local variables 
*/

/*
 * exported objects/variables (non-static) 
*/

char *Vprogram = "test" ; 

/*
 * static functions 
*/

/*
 * non static functions 
*/

extern int syslog();
extern char *strtok();

/* 

  demonstrate the use of the various functions in the CableNet library 

*/

char    *host = "localhost";
char    *dbase = "test";
char    *login = "testuser";

int
ExerciseSql(void)
{
    int     handle, num, slnum, i;
    char    *fldv[1], *id, *start, *length;
    char    qbuf[1024];
    StringList  sl;

    /* access the mSQL database engine using the generic interface library */

    if ((handle = VdbConnect(host)) < 0) {
	syslog(LOG_ERR, "Couldn't connect to engine! %s ",
	    msqlErrMsg);
	return 1;
    }

    if (VdbSelect(handle, dbase) < 0) {
	syslog(LOG_ERR, "Couldn't select database %s! %s", dbase,
	    msqlErrMsg);
	return 1;
    }

    sprintf(qbuf, "select name from subs where login = '%s'", 
	    login );

    /* set this to the number of fields you are expecting from the query */
    /* it must be <= the number of char *vectors in fldv */
    num = 1;

    /* just retrieve the first record that matches */
    if (VdbQuery(handle, qbuf) < 0    ||
	VdbFirstRec(handle, &fldv[0], &num) < 0) 
    {
	syslog( LOG_ERR, "error querying name from subs for %s %s", 
	       login, Vusrmsg );
    } else {
	printf("name == %s\n", fldv[0] );
    }

    sprintf(qbuf, "select * from times where login = '%s'", login );

    if (VdbQuery(handle, qbuf) < 0 )
    {
	syslog( LOG_ERR, "error querying times for %s %s", 
	       login, Vusrmsg );
    } else {

	/* retrieve the results as a string list which we can cycle through
	   easily */
	sl = VdbResultSL(handle, '^');

	slnum = CountStringList(sl);

	for( i = 0 ; i < slnum ; i++) {

	    id = strtok(sl[i], "^");
	    start = strtok(NULL, "^");
	    length = strtok(NULL, "^");

	    printf("session : %s %s\n", start, length );
	}
    }

    VdbClose(handle);

    return 0;
}

char *ver = "$Revision: $";

int
usage()
{
    fprintf(stdout, "%s: usage:  <args>\n", Vprogram);
    return 0;
}

/* these don't mean anything */
#define DEMO_SRV_PORT 9999
#define DFLT_DELAY 10

int
main(int argc, char **argv)
{
    char    *val;
    int     forking = 1, srv_port = DEMO_SRV_PORT, delay = DFLT_DELAY;
    int     log_to_file = FALSE;
    DfltsInfo   di;
    
    /* application startup */
    VappGenericArgs();

    VappInit(&argc, argv, ver, usage, 0 );

    /* initialise the defaults system */
    DfltsInit();

    /* now get some things from the command line values */

    /* get some string values */
    if ((val = VappArgCHAR("host")) != NULL)
	host = CopyString(val);

    if ((val = VappArgCHAR("dbase")) != NULL)
	dbase = CopyString(val);

    if ((val = VappArgCHAR("user")) != NULL)
	login = CopyString(val);

    /* see if an arg is present to set a boolean flag */
    if ((val = VappArgCHAR("fork")) != NULL)
	forking = 0;

    /* get arg as a string and get it's integer value */
    if ((val = VappArgCHAR("port")) != NULL) {
	if ((srv_port = atoi(val)) < 0) 
	    srv_port = DEMO_SRV_PORT;
    }

    /* get an arg as an integer */
    delay = VappArgINT("delay");
    if (errno != 0)
	delay = DFLT_DELAY;

    /* setup syslog */
    openlog(Vprogram, LOG_PID | LOG_CONS | LOG_NOWAIT, LOG_DAEMON );

    /* get some defaults values */
    /* see the defaults document for an 
       explanation but it's similar to the windows 95 hierarchical
       registry database expect that you can three levels of defaults
       user, local and system (global) in that order of priority */

    memset(&di, 0, sizeof(di));

    di.base = ANY_DFLT_SET;	/* retrieve from anywhere */
				/* other values are USER_DFLT_SET */
    di.group = Vprogram;	/* LOCAL_DFLT_SET & GLOBAL_DFLT_SET */
				/* which will force retrieval from that set */
    di.tag = "port";
    if ((srv_port = DfltGetInt(&di)) <= 0 )
	srv_port = DEMO_SRV_PORT;

    di.base = ANY_DFLT_SET;
    di.tag = "fork";
    if ((val = DfltGetString(&di)) != NULL ) {
	if (strncmp(val,"FALSE",5) == 0)
	    forking = 0;
	else
	    forking = 1;
    }

    di.base = ANY_DFLT_SET;
    di.tag = "log_to_file";
    if ((val = DfltGetString(&di)) != NULL ) {
	if (strncasecmp(val,"TRUE",4) == 0   ||
	    strncasecmp(val,"YES",3) == 0)
	    log_to_file = TRUE;
    }

    return ExerciseSql();

}
