/*************************************************************************
 msqlexpire: module to remove records from a mSQL database based on age.
 ************************************************************************* 
 *
 * Copyright (c), 1994-1995, by B. Scott Burkett
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All modifications to the source code must not be distributed without
 *    the permission of B. Scott Burkett.
 * 4. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgment:
 *      This product includes software developed by B. Scott Burkett and
 *      other unpaid contributors.
 * 5. The name of B. Scott Burkett may not be used to endorse or promote
 *    products derived from this software without specific prior
 *    written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY B. SCOTT BURKETT AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL B. SCOTT BURKETT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 ***************************************************************************** 
 $Header: /opt/home/staff/scottb/msqlexpire/RCS/msqlexpire.c,v 1.2 1996/07/06 19:09:34 scottb Exp scottb $
 ***************************************************************************** 
 $Log: msqlexpire.c,v $
 * Revision 1.2  1996/07/06  19:09:34  scottb
 * Added support for the -e (expire by date) switch.  Also
 * removed some hardcoded limits.
 *
 * Revision 1.1  1996/07/06  16:05:28  scottb
 * Initial revision
 *
 *****************************************************************************

 msqlexpire: module to remove records from a mSQL database based on age.

 USAGE: msqlexpiry [database_name] [table_name] [host_name] [ttl_fldnum]
		   [notify_fldnum]

	database_name = Name of the mSQL database
	table_name    = Name of the table to check for expiries
	host_name     = Host name that msqld is running on
	ttl_fldnum    = The field number containing the time_to_live value.
	notify_fldnum = The field number containing an email address for
			deletion notification

 ************************************************************************* 
 NOTE: When calculating field numbers, start from zero (0), not one (1)!
 *************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "msql.h"

#include "msqlexpire.h"

int main( int argc, char *argv[])
{
	char 	querybuf[255], *workptr, timebuf[255];
	time_t 	currtime, diff, addtime;
	struct tm *curr_tm = malloc(sizeof(struct tm));
	int     mon, day, year, remove_flag=0, cntr=0;
	long	daysold, time_to_live;
	long	totalrows=0, delete_count=0;
	long	skippedrows=0;
	m_field	*currfld;

	/* Obtain info from command line arguments */
	ParseCmdLine(argc, argv);

	/* Connect to mSQL daemon */
	if((db=msqlConnect(host_name)) == -1)
	{
		perror(msqlErrMsg);
		exit(EXIT_FAILURE);
	}

	/* Attempt to connect to database */
	if(msqlSelectDB(db, database_name) == -1)
	{
		perror(msqlErrMsg);
		exit(EXIT_FAILURE);
	}

	/* Do a SELECT * for the database */
	sprintf(querybuf, "SELECT * from %s", table_name);
	if(msqlQuery(db, querybuf) == -1)
	{
		perror(msqlErrMsg);
		exit(EXIT_FAILURE);
	}

	/* Store the query result */
	result = msqlStoreResult();

	while((row = msqlFetchRow(result)))
	{
		totalrows++;

		/* Handle expire by date */
		if(expire_by_date)
		{
			/* Parse the current date */
			time(&currtime);
			curr_tm = localtime(&currtime);
			
			/* Adjust the month by 1 */
			curr_tm->tm_mon = curr_tm->tm_mon + 1;

			/* Parse the stored expiry date field.  Make sure that strtok()
			   doesn't fail.  POSIX specifies undefined behavior when calling
			   atoi/atol/atof on a NULL pointer!
	 		*/

			strcpy(timebuf, row[date_field]);

			if((workptr = strtok(timebuf, "/-")) != NULL)
				mon = atoi(workptr);
			else
				{
					fprintf(stderr, "ERROR: invalid expiry date field - record skipped\n");
					skippedrows++;
					continue;
				}

			if((workptr = strtok(NULL, "/-")) != NULL)
				day = atoi(workptr);
			else
				{
					fprintf(stderr, "ERROR: invalid expiry date field - record skipped\n");
					skippedrows++;
					continue;
				}

			if((workptr = strtok(NULL, "/-")) != NULL)
				year = atoi(workptr);
			else
				{
					fprintf(stderr, "ERROR: invalid expiry date field - record skipped\n");
					skippedrows++;
					continue;
				}

			/* Lets compare */
			
			if((curr_tm->tm_year+1900) == year &&
			    curr_tm->tm_mon == mon &&
			    curr_tm->tm_mday == day)
	
				remove_flag=TRUE;
		}
		else
		{
			/* If time_to_live is zero, it stays forever */
			time_to_live = atol(row[ttl_field]);
			if(!time_to_live) {
				skippedrows++;
				continue;
			}

			/* Convert stored date to time_t */
			sscanf( row[date_field], "%ld", &addtime);
	
			/* Snag current date */
			currtime = time(NULL);
	
			/* Calculate number of seconds between add date and currdate */
			diff = difftime(currtime, addtime);
	
			/* Convert the time difference to days (s->m->h->d)*/
			daysold = (((diff/60)/60)/24);
	
			if(daysold > time_to_live)
				remove_flag=TRUE;
		}
	
		if( remove_flag )
		{
			remove_flag = FALSE;

			/* Obtain field name of key field */
			while((currfld = msqlFetchField(result)))
			{
				if(cntr == key_field)
					break;
				cntr++;
			}

			/* Reset a few things */
			msqlFieldSeek(result, 0);
			cntr=0;

			/* Build the DELETE SQL statement */
			sprintf(querybuf, "DELETE FROM %s WHERE %s = \'%s\'\n",
				table_name, currfld->name, row[key_field]);
					
			/* Nuke it, mon ami */
			if(! safe_mode )
			{
			 	if( msqlQuery(db, querybuf) == -1)
				{
					perror(msqlErrMsg);
					exit(EXIT_FAILURE);
				}
			}
	
			delete_count++;
				
			/* Notify someone - optional */
			if(notify_field)
				NotifyOwner( );
		}
	}

	/* Free the query handle */
	msqlFreeResult(result);

	/* Close the socket */
	msqlClose(db);

	printf("%ld rows processed\n", totalrows);
	printf("%ld rows skipped\n", skippedrows);
	printf("%ld rows deleted\n", delete_count);

	/* Adios und spater */
	return(0);
}
