/*****************************************************************************
 msqlexpire: module to remove records from a mSQL database based on age.
 ************************************************************************* 
 *
 * Copyright (c), 1994-1995, by B. Scott Burkett
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All modifications to the source code must not be distributed without
 *    the permission of B. Scott Burkett.
 * 4. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgment:
 *      This product includes software developed by B. Scott Burkett and
 *      other unpaid contributors.
 * 5. The name of B. Scott Burkett may not be used to endorse or promote
 *    products derived from this software without specific prior
 *    written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY B. SCOTT BURKETT AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL B. SCOTT BURKETT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 ***************************************************************************** 
 $Header: /opt/home/staff/scottb/msqlexpire/RCS/strlib.c,v 1.1 1996/07/06 16:06:00 scottb Exp scottb $
 ***************************************************************************** 
 $Log: strlib.c,v $
 * Revision 1.1  1996/07/06  16:06:00  scottb
 * Initial revision
 *
 ***************************************************************************** 

 Miscellaneous String Functions

 *****************************************************************************/

#include <string.h>
#include <ctype.h>
#include <stdio.h>

#include "strlib.h"

#ifndef TRUE
#define	 TRUE	1
#define	 FALSE	!TRUE
#endif

int strchg(char *s, char a, char b)
{
   int    n = 0;
   char   *p;

   for(p = s; (*p != '\0'); p++)
      if(a == *p)
      {  *p = b;                       /* change                        */
         n++;
      }
   return(n);
}

char *strsrep(char *s, char *a, char *b)
{
   char   *p;
   int    d;

   if((p = strinc(a, s)) != NULL)
   {  strdel(a, s);
      d = p - s;
      strins(b, s, d);
      p = s;
   }
   return(p);
}

char *strtrim(char *s)
{
   int i;

   for(i = strlen(s) - 1; ('!' > (unsigned char)s[i]) && i >= 0; i--)
      ;
   s[i+1] = '\0';
   return(s);
}

char *strdel(char *a, char *s)
{
   char *p, *q;

   q = strinc(a, s);
   if(!q)
      return(NULL);
   p = q + strlen(a);
   strcpy(q, p);
   return(s);
}

char *strins(char *a, char *s, int p)
{
   int i, l;

   l = strlen(a);                      /* length of string to insert */
   for(i = strlen(s); i >= p; i--)     /* shift text to right */
      *(s + l + i) = *(s + i);
   for(i = 0; i < l; i++)              /* insert text */
      *(s + p + i) = *(a + i);
   return(s);
}

char *strinc(char *a, char *s)
{
   int   m;
   char *p;
   int   n;

   m = strlen(a);
   n = strlen(s);                    /* don't search past EOS      jpl */
   for(p = s; (*p != '\0') && (n>=m); p++, n--) /* stop at end of s jpl */
      if(!strncmp(a, p, m))
         return(p);
   return(NULL);
}

char *strcode(char *s, char *k)
{
   char *q = k;
   char *p;

   for(p = s; (*p != '\0'); p++)
   {  if(*p != *q)
         *p = *p^*q;
      q++;
      if(*q == '\0')
         q = k;
   }
   return(s);
}

char *strltrim(char *s)
{
   char   *p;
   char   *q;

   p = q = s;
   while(('!' > (unsigned char)*p) && (*p != '\0'))
      p++;
   while(*p != '\0')
      *q++ = *p++;
   *q = '\0';
   return(s);
}

char *strschg(char *s, char *a, char *b)
{
   int  n = 0;
   char *p = s;
   int      i;

   i = strlen(b);
   for(;;)
   {  if(strsrep(p, a, b) == NULL)
         break;
      p += i;
      n++;
   }
   return(n ? s : NULL);
}

char *strisrep(char *s, char *a, char *b)
{
   char   *p;
   int     d;

   if((p = striinc(a, s)) != NULL)
   {  stridel(a, s);
      d = p - s;
      strins(b, s, d);
      p = s;
   }
   return(p);
}

char *stridel(char *a, char *s)
{
   char *p, *q;

   if(NULL == (q = striinc(a, s)))
      return(NULL);
   p = q + strlen(a);
   strcpy(q, p);
   return(s);
}

char *striinc(char *a, char *s)
{
   int  m;
   char *p;
   int  n;

   m = strlen(a);
   n = strlen(s);
   for(p = s; (*p != '\0') && (n>=m); p++, n--)
      /* if(!strnicmp(a, p, m)) */
      if(!strncmp(a, p, m))
         return(p);
   return(NULL);
}

char *struplow(char *s)
{
   char i;

   for(i = 0; *(s + i); i++)
      *(s + i) = touplow(s, s + i,*(s + i));
   return(s);
}

char touplow(char *s, char *p, char c)
{
   if(strchr(" ", *(p - 1)) || (p == s))
	  return((char)toupper(c));
   return((char)tolower(c));
}

char *strupper(char *s)
{
   char i;

   for(i = 0; *(s + i) != '\0'; i++)
      *(s + i) = toupper((int)*(s+i));
   return(s);
}

char *strlower(char *s)
{
   int i;

   for(i = 0; *(s + i); i++)
      *(s + i) = (char)tolower(*(s+i));
   return(s);
}

char *strsetsz(char *s, int n)
{
   int i;
   int l;

   l = strlen(s);
   if(n < l)
      *(s + n) = '\0';
   else
   {  for(i = l; i <n; i++)
         *(s + i) = ' ';
      *(s + i) = '\0';
   }
   return(s);
}

int strichg(char *s, char a, char b)
{
   int n = 0;
   char *p;

   a = toupper(a);
   for(p = s; (*p != '\0'); p++)
      if(a == toupper(*p))
      {  *p = b;                       /* change                        */
         n++;
      }
   return(n);
}

char *strischg(char *s, char *a, char *b)
{
   int n=0;
   char *p = s;
   int i;

   i = strlen(b);
   for(;;)
   {  if(strisrep(p, a, b) == NULL)
         break;
      p += i;
      n++;
   }
   return(n ? s: NULL);
}

char *strrol(char *s, int n)
{
   int i, j;
   char t;

   if('\0' != *s)
      for(j = 0; j < n; j++)
      {  t = *(s);
         for(i = 0; *(s + i); i++)
            *(s + i) = *(s + i + 1);
         *(s + i - 1) = t;
      }
   return(s);
}

char *strshl(char *s, int n)
{
   int i;
   int j;

   if('\0' != *s)
      for(j = 0; j < n; j++)
      {  for(i = 0; *(s + i); i++)
            *(s + i) = *(s + i + 1);
         *(s + i - 1) = '\0';
      }
   return(s);
}

int strocc(char *s, char c)
{
   int n=0;
   char *p = s;

   while('\0' != *p)
      if(c == *p++)
         n++;
   return(n);
}

int strblank(char *s)
{
   char *p = s;

   for(p = s; (*p != '\0'); p++)
      if('!' <= (unsigned char)*p)
         return(FALSE);                /* non-blank                     */
   return(TRUE);
}

