/*
 * Filename: sgs.h
 * Project:  Sequence Generation System
 * Module:   API
 *
 * Function: The API provides a library of C functions to access
 *           the sequence generator daemon.
 *
 * Author:   Pascal Forget
 * Date:     October 1995
 *
 * Copyright (C) 1995 Pascal Forget <pascal@wsc.com>
 *
 * This software falls under the GNU General Public Licence.
 * See the COPYING file for all the details.
 */

#ifndef SGS_H__
#define SGS_H__
#include "sgsCommon.h"

int sgsCreateSequence(const char *name);
int sgsDropSequence(const char *name);
SGAnswer sgsCurrentValue(const char *name);
SGAnswer sgsNextValue(const char *name);
SGAnswer sgsCache(const char *name);
SGAnswer sgsIncrement(const char *name);
int sgsSetCache(const char *name, unsigned char newCache);
int sgsSetHostname(const char *name);
int sgsSetIncrement(const char *name, unsigned int newIncrement);
int sgsSetValue(const char *name, unsigned int newValue); 

#endif
