/*
 * Filename: seqgenGlobalDefsPrivate.c
 * Project:  Sequence Generation System
 * Module:   API
 *
 * Function: Refer to the header file for a description
 *
 * Author:   Pascal Forget
 * Date:     May 1995
 *
 * Copyright (C) 1995 Pascal Forget
 *
 * This software falls under the GNU General Public License as published
 * by the Free Software Foundation.  See the COPYING file for more
 * information.
 */

#include "sgsCommon.h"

/* Conversion functions */

SGAnswer
sgsConvertAnswerFromAscii(SGASCIIAnswer answer)
{
    SGAnswer result;

    result.value = atoi(answer.value);
    result.returnStatus = (int)answer.returnStatus;
    return result;
}

SGASCIIAnswer
sgsConvertAnswerToAscii(SGAnswer answer)
{
    SGASCIIAnswer result;

    sprintf(result.value, "%u", answer.value);
    result.returnStatus = (unsigned char)answer.returnStatus;
    return result;
}

SGRequest
sgsConvertRequestFromAscii(SGASCIIRequest req)
{
    SGRequest result;

    result.rtype = (SGRequestType)req.rtype;
    strcpy(result.sequenceName, req.sequenceName);
    result.arg = atoi(req.arg);
    return result;
}

SGASCIIRequest
sgsConvertRequestToAscii(SGRequest req)
{
    SGASCIIRequest result;

    result.rtype = (unsigned char)req.rtype;
    strcpy(result.sequenceName, req.sequenceName);
    sprintf(result.arg, "%u", req.arg);
    return result;
}

/* Socket functions */

int
sgsGetPortNumber(void)
{
    struct servent *serv_ptr, serv;

    if ((serv_ptr = getservbyname(DM_NAME, "tcp"))) {
	serv = *serv_ptr; /* structure copy */
	return serv.s_port;
    } else {
	return DM_PORT;
    }
}







