#ifndef _UTIL
#define _UTIL

#include "msql.h"

/******************************************************/
/*  A set of CGI utility headers.  Some of my own     */
/*  creation and some from the good people at NSCA.   */
/*  Phil Leach <pleach@nerosworld.com>                */
/******************************************************/

typedef struct
{
	char *name;
	char *val;
} entry;

#define LF 10
#define CR 13

#define CFG_REC_LEN 200
#define OPEN_FAILED 1
#define NOT_FOUND 2
#define GOOD 0

#define INC_STR "<!--#include virtual=\""

#define SEVERE_CGI_ERR "<HTML><TITLE>SEVERE CGI ERROR</TITLE><BODY><H1>SEVERE ERROR IN CGI</H1>A severe error occurred in the CGI: %s<BR>This error has <STRONG>not</STRONG> been logged.<BR>Please <A HREF=\"mailto:admin@mailservername.com\">eMail</A> us to inform us of the error</HTML>"
#define CGI_ERR "<HTML><TITLE>CGI ERROR</TITLE><BODY><H1>ERROR IN CGI</H1>An error occurred in the CGI.<BR>This error has been logged.<BR>Please <A HREF=\"mailto:admin@mailservername.com\">eMail</A> us to inform us that an error occurred.</HTML>"

#define MISSING_ITEM "The following item was not found in the config file: %s\n"
#define BAD_CONFIG_OPEN "Could not open the config file.\n"

void getword(char *word, char *line, char stop);
char *makeword(char *line, char stop);
char *fmakeword(FILE *f, char stop, int *cl);
char x2c(char *what);
void unescape_url(char *url);
void plustospace(char *str);
int getline(char *s, int n, FILE *f);
void send_fd(FILE *f, FILE *fd);
int ind(char *s, char c);
int GetIndex(entry list[], char *string, int numEntries);
void LogError(char *fileName, char *whatToLog);
void HardExit(int sock, m_result *result);
char *FormatPrice(double inPrice, char *outPrice);
void msqlInsEscape(char *inString, char *outString);
void DoSSI(char *inStr, char *logFile);
int GetConfig(char *keyname, char *dataname, char *configFileName);
void CheckConfigReturn(int rc, char *buf);

#endif
