#include <stdio.h>
#include "../time.h"

#define DAY (60*60*24)

extern void test1 (void);
extern void test2 (void);
extern void test3 (void);
extern void test4 (void);

void
main()
{
/*	test1(); 
	test2(); 
	test3();*/
	test4();
}

void
test4()
{
	time_t t;
	int mon, day, hour, minute;
	int offset;

	/*
	**	Start on 1/1/1994.
	*/
	for (mon = 4; mon <= 12 ; ++mon)
	{
		fprintf (stderr, "Month %d...\n", mon);
		for (day = 1; day <= month_length(mon, 1994); ++day)
		{
			for (hour = 0; hour < 24; ++hour)
			{
				for (minute = 0; minute < 60; ++minute)
				{
					t = gregorian_to_unix (0, minute, 
							       hour, day, mon, 
							       1994);
					offset = seconds_from_gmt (t);
					/*
					**	Make sure things translate
					**	back correctly.
					*/
					if ((unix_to_gregorian_day (t + offset)
					     != day) ||
					    (unix_to_hour (t + offset)
					     != hour) ||
					    (unix_to_minute (t + offset)
					     != minute))
					{
						fprintf (stderr, "Expecting: %d-%d-%d, %d:%d:%d\n", mon, day, 1994, hour, minute, 0);
						fprintf (stderr, "Got:       %d-%d-%d, %d:%d:%d\n", unix_to_gregorian_month (t + offset), unix_to_gregorian_day (t + offset), 1994, unix_to_hour (t + offset), unix_to_minute (t + offset), 0);
					}
				}
			}
		}
	}
}

void
test3()
{
	time_t t;
	int mon, day;
	int offset;

	/*
	**	Start on 1/1/1994.
	*/
	for (mon = 1; mon <= 12 ; ++mon)
	{
		for (day = 1; day <= month_length(mon, 1994); ++day)
		{
			t = gregorian_to_unix (0, 0, 12, day, mon, 1994);
#ifdef notdef
			fprintf (stderr, "Day %d-%d-%d, %d:%d:%d\toffset: %d\n", 
				 unix_to_gregorian_month (t), 
				 unix_to_gregorian_day (t), 
				 unix_to_gregorian_year (t),
				 unix_to_hour (t), 
				 unix_to_minute (t), 
				 unix_to_second (t),
				 seconds_from_gmt (t));
#endif
			/*
			**	Adjusted for GMT.
			*/
			offset = seconds_from_gmt (t);
			fprintf (stderr, "Day %d-%d-%d, %d:%d:%d\toffset: %d\n", 
				 unix_to_gregorian_month (t + offset), 
				 unix_to_gregorian_day (t + offset), 
				 unix_to_gregorian_year (t + offset),
				 unix_to_hour (t + offset), 
				 unix_to_minute (t + offset), 
				 unix_to_second (t + offset),
				 offset);
		}
	}
}

void
test2()
{
	time_t t;
	time_t today;

	t = gregorian_to_unix (0, 0, 12, 24, 9, 1994);
	today = current_unix_time();

	fprintf (stderr, "t = %d\n", t);
	fprintf (stderr, "That is %d-%d-%d, %d:%d:%d\n", 
		 unix_to_gregorian_month (t), unix_to_gregorian_day (t), 
		 unix_to_gregorian_year (t),
		 unix_to_hour (t), unix_to_minute (t), unix_to_second (t));
		 
	fprintf (stderr, "It is now %d-%d-%d, %d:%d:%d\n", 
		 unix_to_gregorian_month (today), 
		 unix_to_gregorian_day (today), 
		 unix_to_gregorian_year (today),
		 unix_to_hour (today), 
		 unix_to_minute (today), 
		 unix_to_second (today));
}

void
test1 ()
{
	time_t t, t2;
	int mon, day;

	/*
	**	Start on 1/1/1994.
	*/
	t = gregorian_to_unix (0, 0, 12, 1, 1, 1994);
	t2 = gregorian_to_unix (0, 0, 12, 1, 1, 1994);

	t -= DAY;

	for (mon = 1; mon <= 12 ; ++mon)
	{
		for (day = 1; day <= month_length(mon, 1994); ++day)
		{
			t += DAY;
			t2 = gregorian_to_unix (0, 0, 12, day, mon, 1994);
			if ((unix_to_second (t) != unix_to_second (t2)) ||
			    (unix_to_minute (t) != unix_to_minute (t2)) ||
			    (unix_to_hour (t) != unix_to_hour (t2)) ||
			    (unix_to_gregorian_day (t) != 
			     unix_to_gregorian_day (t2)) ||
			    (unix_to_gregorian_month (t) != 
			     unix_to_gregorian_month (t2)) ||
			    (unix_to_gregorian_year (t) != 
			     unix_to_gregorian_year (t2)))
			{
				fprintf (stderr, "Problem on %d/%d\n", 
					 mon, day);
			}
		}
	}
}


