#ifndef TIME_H
#define TIME_H

#include <time.h>
#include <sys/time.h>

typedef enum
{
	January,
	February,
	March,
	April,
	May,
	June,
	July,
	August,
	September,
	October,
	November,
	December
} MONTH;

typedef enum 
{
	Sunday,
	Monday,
	Tuesday,
	Wednesday,
	Thursday,
	Friday,
	Saturday,
} WEEKDAY;

/*
**	Julian date functions.
*/
typedef unsigned int JULIAN_DAY;

extern JULIAN_DAY gregorian_to_julian (int day, int month, int year);
extern JULIAN_DAY unix_to_julian (time_t time);
extern JULIAN_DAY current_julian_date (void);

extern int julian_to_gregorian_day (JULIAN_DAY date);
extern int julian_to_gregorian_month (JULIAN_DAY date);
extern int julian_to_gregorian_year (JULIAN_DAY date);

extern WEEKDAY julian_to_weekday (JULIAN_DAY date);

/*
**	Unix date/time functions.
**
**	gregorian_to_unix() and current_unix_time() assume local time.
**	unix_to_*() assume GMT.
*/
extern time_t gregorian_to_unix (int second, int minute, int hour, 
				 int day, int month, int year);
extern time_t gregorian_to_unix_at_offset (int gmt_offset, 
					   int second, int minute, int hour, 
					   int day, int month, int year);
extern time_t current_unix_time (void);

extern int unix_to_second (time_t time);
extern int unix_to_minute (time_t time);
extern int unix_to_hour (time_t time);
extern int unix_to_gregorian_day (time_t time);
extern int unix_to_gregorian_month (time_t time);
extern int unix_to_gregorian_year (time_t time);

extern WEEKDAY unix_to_weekday (time_t time);

/*
**	Thirty-360 functions.
*/
extern JULIAN_DAY thirty_360_start_date (JULIAN_DAY end_date, int length);
extern JULIAN_DAY thirty_360_end_date (JULIAN_DAY start_date, int length);
extern int thirty_360_length (JULIAN_DAY start_date, JULIAN_DAY end_date);

/*
**	Misc date functions.
*/
extern int is_leap_year (int year);
extern int day_number (int day, int month, int year); /* 1-366 */
extern int month_length (int year, int month); /* 28, 29, 30, or 31 */

/*
**	Misc time functions.
*/
extern int seconds_since_midnight (void);
extern int seconds_from_gmt (time_t time); /* In local time */

#endif /* TIME_H */



