/* bprintf.h: Declarations of functions defined in bprintf.c. */

/* Author: Brian J. Fox (bfox@ua.com) Thu Apr 20 19:34:51 1995. */

#if !defined (_BPRINTF_H_)
#define _BPRINTF_H_

/* A structure used to hold onto a dynamically created buffer of text. */
typedef struct {
  char *buffer;
  int bindex;
  int bsize;
} BPRINTF_BUFFER;

/* Create a new empty output buffer. */
extern BPRINTF_BUFFER *bprintf_create_buffer (void);

/* Create a new buffer which is a copy of INPUT. */
extern BPRINTF_BUFFER *bprintf_copy_buffer (BPRINTF_BUFFER *input);

/* Free the contents of a bprintf buffer. */
extern void bprintf_free_buffer (BPRINTF_BUFFER *buffer);

/* The main function in this library.  Print to BUFFER with FORMAT and
   any additional args. */
extern void bprintf (BPRINTF_BUFFER *buffer, char *format, ...);

/* Like bprintf, but after the va_list has been started. */
extern void vbprintf (BPRINTF_BUFFER *buffer, char *format, va_list args);

/* A few helpful functions for manipulating the insides of bprintf buffers. */

/* Delete the characters from START to END from buffer.  The END'th
   character is not deleted, but the START'th character is.
   Return the number of characters deleted. */
extern int bprintf_delete_range (BPRINTF_BUFFER *buffer, int start, int end);

/* Insert into BUFFER at POINT the results of printing FORMAT with args.
   Return the number of characters inserted, or -1 if there was an error. */
extern int bprintf_insert (BPRINTF_BUFFER *buffer, int point, char *fmt, ...);

/* Insert into BUFFER at POINT the string TEXT.
   Return the number of characters inserted, or -1 if there was an error. */
extern int bprintf_insert_text (BPRINTF_BUFFER *buffer, int point, char *text);

#endif /* ! _BPRINTF_H_ */
