/*  forms.h: The data structures that we use to parse incoming forms. */

/*  Copyright (c) 1995 Universal Access, Inc
    Author: Brian J. Fox (bfox@ua.com) Sat May 20 11:34:04 1995.  */

#if !defined (_FORMS_H_)
#define _FORMS_H_

/* A name/value pair.  NAME is what was specified in the "NAME" field of an
   input item.  VALUES is a null terminated array of character strings, one
   for each NAME that was seen in the post.  For example, checkbox items
   which have the same name, but different values, would have all of the
   selected values collected in one POSTED_ITEM. */
typedef struct
{
  char *name;
  char **values;
} POSTED_ITEM;

/* Read the input data from all of the available sources.  This means
   the environment variables PATH_INFO and QUERY_STRING, the contents
   of standard input, if there is any, and the arguments passed into
   the CGI program.  A single string is returned.  The arguments are
   returned in the item PROGRAM-ARGUMENTS. */
extern POSTED_ITEM **forms_input_data (int argc, char *argv[]);

/* Search through ITEMS for TAG, and return the associated array of
   character strings.  If TAG isn't present, return a NULL pointer. */
extern char **forms_find_tag (POSTED_ITEM **items, char *tag);

/* Read name/value pairs from BUFFER.  The pairs are delimited with ampersand
   (`&') or end of data.  The name is separated from the value by an equals
   sign (`=').  Space characters are encoded as plus signs (`+').  A percent
   sign (`%') is used to introduce two hex digits, which when coerced to an
   ASCII character is the result.  This mechanism is used to get plus signs
   into the name or value string, for example. */
extern POSTED_ITEM **forms_parse_data_string
			(char *buffer, POSTED_ITEM **array,
			 int *array_indexp, int *array_sizep);

/* Turn ITEMS into a string suitable for appending onto a URL.
   This means that we encode special characters, and write name
   value pairs into a new string.
   A newly allocated string is returned. */
extern char *forms_unparse_items (POSTED_ITEM **items);

/* Using the list in ITEMS, give TAG an additional value of VALUE.
   Returns the ITEMS, or if ITEMS was NULL, a new list. */
extern POSTED_ITEM **forms_add_value
			(POSTED_ITEM **items, char *tag, char *value);

/* Using the list in ITEMS, remove from TAG the value of VALUE.
   Returns ITEMS. */
extern POSTED_ITEM **forms_remove_value
			(POSTED_ITEM **items, char *tag, char *value);

/* Totally remove from ITEMS the variable named TAG, and all of the
   associated values. */
extern POSTED_ITEM **forms_delete_item (POSTED_ITEM **items, char *tag);

/* Given 2 arrays of POSTED_ITEM *, merge the contents, returning a
   new array.  */
extern POSTED_ITEM **forms_merge_data (POSTED_ITEM **i1, POSTED_ITEM **i2);

/* Free the data associated with ITEMS. */
extern void forms_free_items (POSTED_ITEM **items);

#endif /* !_FORMS_H_ */
