#include <stdio.h>
#include "forms.h"

#include "Xsqldefs.h"
#include "version.h"

/* Global variables */

int      sock;

/* some simple callbacks */

void XsqlInfo(FL_OBJECT *ob, long parent)
{
   fl_show_message(
	"Xsqlmenu: a powerful MiniSQL frontend build using the Xforms library",
	"by Kees Lemmens, The Netherlands (C) 1996," VERSION,
	"MiniSql: by Hughes Technologies; Xforms: by T. Zhao and M. Overmars");
}

void XsqlExit(FL_OBJECT *ob, long parent)
{
   if(! fl_show_question("Do you want to quit ?","",""))
     return;
   
   msqlClose(sock);
   exit(0);
}

void XsqlSetNewServer(FL_OBJECT *ob, long parent)
{
   SetNewServer((char *)fl_get_input(ob),(FD_Xsql *)parent);
}

void XsqlSetNewDatabase(FL_OBJECT *ob, long parent)
{
   SetNewDatabase((char *)fl_get_choice_text(ob),(FD_Xsql *)parent);
}

void XsqlSetNewTable(FL_OBJECT *ob, long parent)
{
   SetNewTable((char *)fl_get_choice_text(ob),(FD_Xsql *)parent);
}

/* end simple callbacks */

void Initialize(int argc,char *argv[],FD_Xsql *fd_Xsql)
{
   char *basename;
   
   basename=argv[0];

   fd_Xsql->vdata = NULL; /* Set hook for Info Structs to empty */

   if(argc > 1 && ! strncmp(argv[1],"-h",2) )
   {
      SetNewServer(argv[2],fd_Xsql);
      argv+=2; argc-=2;
   }
   else
     SetNewServer(NULL,fd_Xsql);
   
   if(argc > 3)
     Usage(basename);
   if(argc >= 2)
     SetNewDatabase(argv[1],fd_Xsql);
   if(argc == 3)
     SetNewTable(argv[2],fd_Xsql);

   fl_set_goodies_font(FL_NORMAL_TEXT,12); /* font for warnings ed. */
}

int main(int argc, char *argv[])
{
   FD_Xsql *fd_Xsql;

   fl_initialize(&argc, argv, 0, 0, 0);
   
   fd_Xsql = create_form_Xsql();

   /* fill-in form initialization code */
   Initialize(argc,argv,fd_Xsql); /* set socket, database and tablename */

   /* show the first form */
   fl_show_form(fd_Xsql->Xsql,FL_PLACE_CENTER,FL_FULLBORDER,"Xsql");

   while(1)
     fl_do_forms();

   msqlClose(sock);

   return 0;
}
