/* K. Lemmens May 1996 */

#include <msql.h>
#include <forms.h>

#include "Xsql.h"

#define MAXSTRING 1000
#define MAXQUERY  2048
#define MAXBROWSER  25   /* maximum number of lines in browser */

/* browser initial fontsize : */
#define FONTSIZE  12.0

#ifdef __hpux
#define PRINTCMD "lp"
#else
#define PRINTCMD "lpr"
#endif

#define min(a,b) (a > b ? b : a )

#define debug printf

#define SELECT "SELECT * FROM %s "
#define INSERT "INSERT INTO %s VALUES ("
#define UPDATE "UPDATE %s SET "
#define DELETE "DELETE FROM %s "
#define WHERE  " WHERE "
#define EQUAL  "%s = %s"
#define LIKE   "%s LIKE %s" 
#define AND    " AND "

#define PASSIVE  0
#define ACTIVE   1

typedef struct {
   char     *Table;
   int      Numflds;
   m_field  *Fields;
   FD_Xsql  *Xsql; /* to make main form available to subfunctions */
   m_result *Res;  /* hook for Browser to hold a selection */
} Info_t;
   
/* Global variables */

extern int sock;  /* selected database handle */

/* function prototypes */

/* XsqlHelpers.c */

void SetNewServer(char *server,FD_Xsql *fd_Xsql);
void SetNewDatabase(char *database,FD_Xsql *fd_Xsql);
void SetNewTable(char *table,FD_Xsql *fd_Xsql);
char *TypeConvert(char *target,const char *string, int fieldtype);
int CheckTableSelected(FD_Xsql *fd_Xsql);
Info_t *CopyInfoStruct(Info_t *Source);
void FreeInfoStruct(Info_t *Source);
int ExecuteQuery(Info_t *I,char *query);

/* Shower functions : */

FD_Shower *BuildShowerForm(Info_t *I, char *title, int mode);
void WriteToBrowser(Info_t *I,FL_OBJECT *ob,m_row row);

/* XsqlDialog.c */
void Usage(char *name);
void SqlError(char *s,...);
void Message(char *s,...);
void Info(FD_Xsql *fd_Xsql,char *s,...);

