#ifndef __ZDB_H
#define __ZDB_H

#include <stdlib.h>
#include <string.h>
#include <stdarg.h>

const int CONN_OK =1;
const int CONN_ERROR =0;

const char LogFile[100]="zdb.log";

#define INT_FLD 0
#define REAL_FLD 1
#define CHAR_FLD 2

#define MAX_COLS 25
#define MAXSQLLEN 2048
#define MAXFLDNAME 256
#define MAXTABLENAME 256
#define MAXERRLEN 256

#define ZDB_OPEN 1

#define SQL_FETCH_ERROR 0
#define SQL_FETCH_OK 1
#define SQL_FETCH_DONE 2
#define SQL_REQUEST_READY 4
#define SQL_REQUEST_NONE 8

#define UNKNOWN_DB 0
#define MSQL_DB	1
#define ORACLE_DB 2
#define ODBC_DB 3

#define TO_LOG 0
#define TO_STDOUT 1

class  ZDBConnection;
class  ZSQL;

#ifndef BOOL
typedef int BOOL;
#define TRUE 1
#define FALSE 0
#endif

typedef unsigned char *ZRecord;
typedef struct	{
	int Length;
	int Type;
	char Name[MAXFLDNAME];
	char Table[MAXFLDNAME];
	char FQFN[MAXFLDNAME+MAXTABLENAME+1];
	int Nullable;
	unsigned long Precision;
	int Scale;
	} ZField;


class  ZDBConnection    {
		  public:
				unsigned char User[256];
				unsigned char Password[256];
				BOOL ConnectedToServer;
				BOOL ConnectedToDB;
				char ErrorMessage[MAXERRLEN];
				int Type;
				char Server[100];
				char DBName[100];

		  public:
				ZDBConnection(char* =NULL,char* =NULL,char* =NULL);
				virtual ~ZDBConnection();
				virtual void ShutDown();
				virtual void Initialize();
				virtual BOOL SetDB(char* db){strncpy(DBName,db,100);return TRUE;}
				virtual BOOL SetServer(char* s){strncpy(Server,s,100);return TRUE;}
				virtual int GetDB(){return -1;}
				virtual char* GetError(){return ErrorMessage;}
				void Log(char*,char* = NULL);
				virtual void SetUser(char* u){strncpy((char*)User,u,255);}
				virtual void SetPassword(char* p){strncpy((char*)Password,p,255);}
		  };


class  ZSQL	{
	protected:
		int IsOpen;
		unsigned char SQLString[MAXSQLLEN];
		ZDBConnection* Connection;
		char ErrorMessage[MAXERRLEN];
		long CurrRecord;

	public:
		ZSQL(ZDBConnection* = NULL);
		virtual ~ZSQL();

		virtual void SetConnection(ZDBConnection* p){Connection=p;}
		virtual ZDBConnection* GetConnection(){return Connection;}
		virtual int Open(char*,...){IsOpen=1;return 1;}
		virtual void Close(){IsOpen=0;}
		virtual int GetSQLData(int col,char*,int)=0;
		virtual int GetSQLData(int col,int*)=0;
		virtual int GetSQLData(int col,float*)=0;

		virtual int GetNextRecord()=0;
		virtual int GetFieldInfo(int,ZField*){return 0;};
		virtual int GetNumCols()=0;
		virtual int GetNumRows()=0;
		virtual void Initialize();
		virtual long Max(char* table,char* fld,char* Where=NULL)=0;
		virtual long Min(char* table,char* fld,char* Where=NULL)=0;
		virtual long Count(char* table,char* Where=NULL)=0;
		virtual char* GetError(){return ErrorMessage;}
		virtual long GetCurrentRecord(){return CurrRecord;}
		virtual BOOL SetCurrentRecord(long rn);
	};

#endif
