#ifndef __ZDB_H
#define __ZDB_H

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

const int CONN_OK =1;
const int CONN_ERROR =0;

const char LogFile[100]="zdb.log";

#define INT_FLD 0
#define REAL_FLD 1
#define CHAR_FLD 2

#define MAX_COLS 25
#define MAXSQLLEN 2048
#define MAXFLDNAME 256
#define MAXERRLEN 100

#define ZDB_OPEN 1

#define SQL_FETCH_ERROR 0
#define SQL_FETCH_OK 1
#define SQL_FETCH_DONE 2
#define SQL_REQUEST_READY 4
#define SQL_REQUEST_NONE 8

#define UNKNOWN_DB 0
#define MSQL_DB	1
#define ORACLE_DB 2
#define ODBC_DB 3

#define TO_LOG 0
#define TO_STDOUT 1

class  ZDBConnection;
class  ZSQL;

#ifndef BOOL
typedef int BOOL;
#define TRUE 1
#define FALSE 0
#endif

typedef unsigned char *ZRecord;
typedef struct	{
	int Length;
	int Type;
	char Name[MAXFLDNAME];
	} ZField;


class  ZDBConnection    {
        public:
                unsigned char ConnectInfo[256];
                unsigned char User[256];
                unsigned char Password[256];

                unsigned IsConnected;
                char ErrorMessage[MAXERRLEN];
                int Type;

        public:
                ZDBConnection(char* ConnectInfo,char* User=NULL,char* Pass=NULL);
                ~ZDBConnection();
                virtual void ShutDown();
                virtual void Initialize();

                void Log(char*,char* = NULL);
        };


class  ZSQL	{
	protected:
		int IsOpen;
		unsigned char SQLString[MAXSQLLEN];
		ZDBConnection* Connection;
		char ErrorMessage[MAXERRLEN];
		long CurrRecord;	

	ZRecord CurrRecInfo;
	
	public:
		ZSQL(ZDBConnection*);
		~ZSQL();

		virtual int Open(char*){
			Connection->Log("ZSQL: Opening SQL transaction...");
			IsOpen=1;
			return 1;
			}
		virtual void Close(){
			if(IsOpen)	{
				Connection->Log("ZSQL: Closing SQL transaction...");
				IsOpen=0;
				}
			}
		virtual int GetSQLData(int col,char*,int)=0;
		virtual int GetSQLData(int col,int*)=0;
		virtual int GetSQLData(int col,float*)=0;

		virtual int GetNextRecord()=0;
		virtual int GetFieldInfo(int,ZField*)=0;
		virtual int GetNumCols()=0;
		virtual int GetNumRows()=0;
		virtual void Initialize();
		virtual void PrintError(int=TO_LOG)=0;
	};
		
#endif
