#ifndef TIME_H
#define TIME_H

#include <time.h>
#include <sys/time.h>


#if defined(__STDC__) || defined(__cplusplus)
#  define __ANSI_PROTO(x)       x
#else
#  define __ANSI_PROTO(x)       ()
#endif


typedef enum
{
	January,
	February,
	March,
	April,
	May,
	June,
	July,
	August,
	September,
	October,
	November,
	December
} MONTH;

typedef enum 
{
	Sunday,
	Monday,
	Tuesday,
	Wednesday,
	Thursday,
	Friday,
	Saturday,
} WEEKDAY;

/*
**	Julian date functions.
*/
typedef unsigned int JULIAN_DAY;

extern JULIAN_DAY gregorian_to_julian __ANSI_PROTO((int, int, int));
extern JULIAN_DAY unix_to_julian __ANSI_PROTO((time_t));
extern JULIAN_DAY current_julian_date __ANSI_PROTO((void));

extern int julian_to_gregorian_day __ANSI_PROTO((JULIAN_DAY));
extern int julian_to_gregorian_month __ANSI_PROTO((JULIAN_DAY));
extern int julian_to_gregorian_year __ANSI_PROTO((JULIAN_DAY));

extern WEEKDAY julian_to_weekday __ANSI_PROTO((JULIAN_DAY));

/*
**	Unix date/time functions.
**
**	gregorian_to_unix() and current_unix_time() assume local time.
**	unix_to_*() assume GMT.
*/
extern time_t gregorian_to_unix __ANSI_PROTO((int,int,int,int,int,int));
extern time_t gregorian_to_unix_at_offset __ANSI_PROTO((int,int,int,int,int,int,int));
extern time_t current_unix_time __ANSI_PROTO((void));

extern int unix_to_second __ANSI_PROTO((time_t));
extern int unix_to_minute __ANSI_PROTO((time_t));
extern int unix_to_hour __ANSI_PROTO((time_t));
extern int unix_to_gregorian_day __ANSI_PROTO((time_t));
extern int unix_to_gregorian_month __ANSI_PROTO((time_t));
extern int unix_to_gregorian_year __ANSI_PROTO((time_t));

extern WEEKDAY unix_to_weekday __ANSI_PROTO((time_t));

/*
**	Thirty-360 functions.
*/
extern JULIAN_DAY thirty_360_start_date __ANSI_PROTO((JULIAN_DAY, int));
extern JULIAN_DAY thirty_360_end_date __ANSI_PROTO((JULIAN_DAY, int));
extern int thirty_360_length __ANSI_PROTO((JULIAN_DAY, JULIAN_DAY));

/*
**	Misc date functions.
*/
extern int is_leap_year __ANSI_PROTO((int));
extern int day_number __ANSI_PROTO((int, int, int)); /* 1-366 */
extern int month_length __ANSI_PROTO((int, int)); /* 28, 29, 30, or 31 */

/*
**	Misc time functions.
*/
extern int seconds_since_midnight __ANSI_PROTO((void));
extern int seconds_from_gmt __ANSI_PROTO((time_t)); /* In local time */

#endif /* TIME_H */



