/*LINTLIBRARY*/
/* Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
/*
 *	Shape/AtFS
 *
 *	afmemory.c -- memory allocation module for AtFS archive handling
 *
 *	Author: Andreas Lampen, TU-Berlin (andy@coma.UUCP)
 *					  (andy@db0tui62.BITNET)
 *
 *	$Header: afmemory.c[1.5] Fri Jan 31 18:05:17 1992 andy@cs.tu-berlin.de accessed $
 *
 *	EXPORT:
 *
 *      af_malloc -- allocate memory
 *      af_frmemlist -- free list of allocated memory segments
 */

#include <stdio.h>

#include "afsys.h"
#include "atfs.h"
#include "afarchive.h"

#ifdef MEMDEBUG
extern FILE *memprot;
#endif
extern int af_listmem;

/*=========================================================================
 *     af_malloc -- allocate memory and registrate it
 *
 * all memory allocated for data in an archive is preceeded by a pointer
 * pointing to the prevoiusly allocated memory segment.
 * So we get a chain of allocated memory segments.
 * ( probably not portable )
 *
 *=========================================================================*/

EXPORT char *af_malloc (list, size)
     Af_revlist *list;
     unsigned   size;
{
  register char **mem;
  char          *malloc();

  size += sizeof(mem);

  if (afListSpace ((int) size) == ERROR)
    af_wng ("malloc", "Application exceeds memory limit");

  if ((mem = (char **)malloc ((unsigned) (size))) == (char **)0)
    FAIL ("malloc", "malloc", AF_ESYSERR, (char *)0);
  list->af_totalmem += size;
  af_listmem += size;
#ifdef MEMDEBUG
      fprintf (memprot, "list: %x - %x-AL %d b\tlistmem: %d\ttotal: %d\n",
	       list, mem, size, list->af_totalmem, af_listmem);
#endif
  *mem = list->af_mem;
  list->af_mem = (char *)mem;

  mem++; /* increment by sizeof ptr */

  return ((char *)mem);
}


EXPORT char *af_realloc (list, ptr, size)
     Af_revlist *list;
     char       *ptr;
     unsigned   size;
{
  char **mem, **segptr, **nextptr, *realloc();

  if ((mem = (char **)realloc (ptr - sizeof ((char *)0),
			   (unsigned) (size + sizeof (mem)))) == (char **)0)
    return (char *)0;
  list->af_totalmem += size; /* not correct (size of old segment should */
  af_listmem += size;        /*              be subtracted */
#ifdef MEMDEBUG
      fprintf (memprot,"list: %x - %x-RE -> %x %d b\tlistmem: %d\ttotal: %d\n",
	       list, ptr, mem, size + sizeof (mem),
	       list->af_totalmem, af_listmem);
#endif

  if ((char *)mem == ptr - sizeof ((char *)0)) /* no registration necessary */
    return ((char *)++mem);

  segptr = &(list->af_mem); /* remove the implicitely freed memory segment */
  while (*segptr != ptr - sizeof ((char *)0))
    segptr = (char **)*segptr;
  nextptr = (char **)*segptr;
  *segptr = *nextptr;

  *mem = list->af_mem; /* registrate new segment */
  list->af_mem = (char *)mem;

  mem++; /* increment by sizeof ptr */

  return ((char *)mem);
}

EXPORT void af_free (list, ptr)
     Af_revlist *list;
     char       *ptr;
{
  char **segptr, **nextptr;

#ifdef MEMDEBUG
      fprintf (memprot, "list: %x - %x-AFR\n", list, ptr - sizeof ((char *)0));
#endif
  free (ptr - sizeof ((char *)0));

  segptr = &(list->af_mem); /* remove memory segment from registration list */
  while (*segptr != ptr - sizeof ((char *)0))
    segptr = (char **)*segptr;
  nextptr = (char **)*segptr;
  *segptr = *nextptr;
}


EXPORT void af_frmemlist (list)
     Af_revlist *list;
{
  register char **ptr, **ptr1;

  ptr = &(list->af_mem);
  while ((char *)*ptr)
    {
#ifdef MEMDEBUG
      fprintf (memprot, "list: %x - %x-FR\n", list, *ptr);
#endif
      ptr1 = (char **)*ptr;
      free (*ptr);
      ptr = ptr1;
    }
  af_listmem -= list->af_totalmem;
#ifdef MEMDEBUG
      fprintf (memprot, "list: %x - free: %d\ttotal: %d\tname: %s\n",
	       list, list->af_totalmem, af_listmem, list->af_arfilename);
#endif

  list->af_mem = (char *)0;
  list->af_totalmem = 0;
}
