/*LINTLIBRARY*/
/* Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
/*
 *	Shape/AtFS
 *
 *	aftmpfiles.c -- handle temporary- and lock-files
 *
 *	Author: Andreas Lampen, TU-Berlin (andy@coma.UUCP)
 *					  (andy@db0tui62.BITNET)
 *
 *	$Header: aftmpfiles.c[1.3] Fri Jan 31 18:05:03 1992 andy@cs.tu-berlin.de accessed $
 *
 *	EXPORT:
 *
 *      af_regtmpfile -- register tmp file
 *      af_unregtmpfile -- unregister tmp file
 *      af_reglckfile -- register lock file
 *      af_cleanup -- do cleanup (e.g. upon signal)
 */

#include <stdio.h>

#include "afsys.h"
#include "atfs.h"

#ifdef TMPDEBUG
extern FILE *tmpprot;
#endif

/*================================================================
 *      list of tmp files
 *
 *================================================================*/

static char *tmpfilelist[NOFILE];

LOCAL void rmtmpfiles ()
{
  register int i;

  for (i=0; i < NOFILE; i++)
    if (tmpfilelist[i] != (char *)0)
      (void) unlink (tmpfilelist[i]);
}

EXPORT void af_regtmpfile (name) /* registrate tmp file */
     char *name;
{
  register int i;

#ifdef TMPDEBUG
  fprintf (tmpprot, "TMP: register %s\n", name);
#endif
  /* look for free space in list */
  for (i=0; i < NOFILE; i++)
    if (tmpfilelist[i] == (char *)0)
      {
	tmpfilelist[i] = name;
	break;
      }
  if (i == NOFILE) /* list is full */
    af_wng ("regtmpfile", "tmpfile list is full -- couldn't register");
}

EXPORT void af_unregtmpfile (name) /* remove tmp file entry */
     char *name;
{
  register int i;
#ifdef TMPDEBUG
  fprintf (tmpprot, "TMP: unregister %s\n", name);
#endif
  for (i=0; i < NOFILE; i++)
    if (tmpfilelist[i] == name)
      {
	tmpfilelist[i] = (char *)0;
	break;
      }
  if (i == NOFILE) /* name not found */
    af_wng ("unregtmpfile", "name of tmpfile has not been registered before");
}  

/*=========================================================================
 *     af_reglckfile -- register lock file
 *
 *=========================================================================*/

static char *lckfilename;

EXPORT af_reglckfile (name)
     char *name;
{
  lckfilename = af_entersym (name);
}

LOCAL rmlckfiles ()
{
  (void) unlink (lckfilename);
}

/*=========================================================================
 *     af_cleanup -- do cleanup
 *
 *=========================================================================*/

EXPORT af_cleanup ()
{
  /* remove tmp files */
  rmtmpfiles ();
  rmlckfiles ();
}
