/*$__copyright$ */
/*
 *	Shape/AtFS
 *
 *	aftransact.c -- a simple transaction mechanism
 *
 *	by Andreas.Lampen@cs.tu-berlin.de
 *
 *	$Header: aftransact.c[1.1] Fri Mar 13 10:27:00 1992 andy@cs.tu-berlin.de accessed $
 *
 *	EXPORT:
 *      af_transaction -- begin transaction
 *      af_commit      -- commit transaction, make changes effective
 *      af_abort       -- abort transaction, discard changes
 *
 */

#include "atfs.h"

/*=========================
 * afAddToTransactionList
 *=========================*/

LOCAL Af_revlist **afTransactionList;

LOCAL int afTransactionCount = 0;

#define AF_TR_SEGSIZE 16

EXPORT int afAddToTransactionList (list)
     Af_revlist *list;
{
  int i;

  if (afTransactionCount == 0)
    {
      if ((afTransactionList = (Af_revlist **)malloc ((unsigned) AF_TR_SEGSIZE * sizeof (Af_revlist*))) == (Af_revlist **)0)
	FAIL ("AddToTransactionList", "malloc", AF_ESYSERR, ERROR);
      afTransactionCount = AF_TR_SEGSIZE;
      for (i=0; i<afTransactionCount; i++)
        afTransactionList[i] = (Af_revlist *)0;
    }

  for (i=0; i<afTransactionCount; i++)
    {
      if (afTransactionList[i] == (Af_revlist *)0)
	{
	  if (af_arlock (list) == ERROR)
	    return (ERROR); 
	  afTransactionList[i] = list;
	  return (AF_OK);
	}
      if (afTransactionList[i] == list)
	return (AF_OK);
    }

  if ((afTransactionList = (Af_revlist **)realloc ((char *)afTransactionList, (unsigned) (afTransactionCount + AF_TR_SEGSIZE) * sizeof (Af_revlist*))) == (Af_revlist **)0)
    FAIL ("AddToTransactionList", "realloc", AF_ESYSERR, ERROR);
  afTransactionCount += AF_TR_SEGSIZE;

  for (i += 1; i<afTransactionCount; i++)
    afTransactionList[i] = (Af_revlist *)0;

  afTransactionList[i-AF_TR_SEGSIZE] = list;
  return (AF_OK);
}

/*=================
 * af_transaction
 *=================*/

EXPORT int afCurTransaction = 0;

EXPORT af_transaction ()
{
  afCurTransaction = 1;
}

/*=================
 * af_commit
 *=================*/

EXPORT int af_commit ()
{
  int i=0, retCode = AF_OK;

  afCurTransaction = 0;

  if (afTransactionCount == 0)
    return (AF_OK);

  while (afTransactionList[i])
    {
      if (afWriteArchive (afTransactionList[i]) == ERROR)
	retCode = ERROR;

      if (af_arunlock (afTransactionList[i]) == ERROR)
	retCode = ERROR;

      afTransactionList[i] = (Af_revlist *)0;
      if (++i == afTransactionCount)
	return (retCode);
    }
  return (retCode);
}

/*=================
 * af_abort
 *=================*/

EXPORT int af_abort ()
{
  int i=0;

  afCurTransaction = 0;

  if (afTransactionCount == 0)
    return (AF_OK);

  while (afTransactionList[i])
    {
      (void) afDetachList (afTransactionList[i]);
      (void) af_arunlock (afTransactionList[i]);
      afTransactionList[i] = (Af_revlist *)0;
      if (++i == afTransactionCount)
	return (AF_OK);
    }
  return (AF_OK);
}

