/*
  Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.

*/
/* Shape/AtFS
 *
 * s-hpux_6_2.h -- general definitions for HP Unix
 *
 * $Header: config.h[1.8] Mon Mar 30 20:05:15 1992 nickel@cs.tu-berlin.de accessed $
 */

/* do only once */
#ifndef _defs_
#define _defs_

/* identify operating system flavor */
#define HPUX_6_2

/* general includes */
#include <sys/types.h>
#include <sys/stat.h>

#include <sys/param.h>
#ifndef SIGQUIT		/* sys/param.h does not include sys/signal.h */
#include <sys/signal.h>
#endif
#include <string.h>
#include <pwd.h>
#include <time.h>

#include <sys/wait.h>

/* system dependent includes */
#include <unistd.h>
#include <dirent.h>

#define Sfunc_t void    /* type of function argument to signal call */
#define Sigret_t void   /* return type of signal system call */
#define Size_t  size_t  /* used for args to fread() etc. */
#define Uid_t   uid_t   /* used for user-id types */
#define Gid_t   gid_t   /* used for group-id types */
#define Wait_t  int
#define Pid_t   pid_t


/* Which dbm should be used ? (default ndbm) */
#define OWNDBM

/* How long can names be */
#undef MAXNAMLEN
#define MAXNAMLEN 14
#define MAXTYPLEN 14
#define MAXDOMAIN 255

/* definitions according to config.c */
char *index ();
char *rindex ();
char *getwd ();

/* other definitions */
#define direct dirent

extern char *re_comp();

#endif /* _defs_ */
