/*$__copyright$ */
/*
 * $Header: atfsapp.h[3.20] Mon Mar 30 22:02:54 1992 nickel@cs.tu-berlin.de accessed $
 */


/*
 *  The following definitions are used by most version control
 *  commands.
 */

#ifndef __ATFSAPP_HDR__
#define __ATFSAPP_HDR__

#include <atfs.h>
#include <setjmp.h>

struct Transaction {
  char tr_fname[MAXPATHLEN+1];
  int tr_done;
  int tr_seqno;
  int tr_rc;
  jmp_buf tr_env;
};

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#define fail(x) ((x) == -1)
#define min(x,y) (((x) <= (y)) ? (x) : (y)) 
#define gen(x) (((x) >> 16) & 0x0000FFFF)
#define rev(x) ((x) & 0x0000FFFF)

#define NOSHELL 127

#define VC_UNUSED 0

#define MAXTMPF 5
#define MAXSETS 64
#define MAXKEYS 64
#define MAXATTRBUFS 64
#define SYMNAMLEN 64
#define MSGLEN MAXPATHLEN+80

#define TYPEF 1
#define AFSET 2
#define AFKEY 3
#define AFATTRS 4
#define NEXT 1
#define REWIND 2

#define SYMNAME  "__SymbolicName__"
#define CLEAD  "__Clead__"
#define CLEADMAXLEN 32
#define INTENT "__Intent__=Intention for change:\n"
#define EMPTYINTENT "--- no intent expressed ---"
#define EMPTYNOTE "--- empty log message ---"

#define DEFAULT_EDITOR "vi"
#define DEFAULT_PATH "/bin:/usr/bin:/usr/ucb:"

/* from atk.h */
extern char *at_getmode(), *at_symbfiletype(), *at_getversstate();
extern char *at_getbndvers(), *at_getbndvers2(), *at_getfilename();
extern char *at_getuser(), *at_version(), *at_vers2string(), *at_getdate(); 
extern char *at_getmoddate(), *at_getaccdate(), *at_getcreatdate();
extern char *at_getsavedate(), *at_getlockdate(), *at_revision();
extern char *at_mkedpat(), *at_getasoname(), *at_rcachekey();
extern char **af_flatten_uda();
extern int at_string2state(), at_matchregex(), at_savebinary();
extern void at_revset(), at_mkuser();

extern int at_Bflag, at_Udaflag;
extern int at_udapattern, at_nuda;
extern char *at_udas[];

/* from locks.h */
extern Af_user *vc_testlock(), *vc_lock(), *vc_unlock();
extern char *lockerid(), *getintent();
extern Uid_t lockeruid();
extern int locked();

extern Uid_t getuid();
extern Uid_t geteuid();
extern Gid_t getgid();

/* from project.h */
#define NLENGTH 64       /* When changing these values take care */
#define PATHLEN 256      /* to keep the size of type Project below */
#define FNLENGTH 128     /* 1000 bytes. (ndbm insufficiency) */

struct _Project {
  char p_pname[NLENGTH],      /* The name of the game */
       p_ppath[PATHLEN],      /* Pathname of project's masterlibrary */
       p_phost[NLENGTH],      /* Name of host where library service resides */
       p_pfullname[FNLENGTH], /* This is usually a short descriptive entry */
       p_plocbase[PATHLEN];   /* Pathname of this user's private workspace */
  short p_pdomain,            /* 100 = unix, 200 = internet */
        p_plibport,           /* portnumber of library service in internet */
        p_plooklib;           /* take only plocbase from this structure */
  };

typedef struct _Project Project;

#ifndef NULL
#define NULL 0
#endif

/*
 * Definitions for at_callcmd()
 */

#ifdef __STDC__
int at_callcmd(char *command_processor, char *commandstring) ;
#else /* not __STDC__ */
int at_callcmd() ;
#endif /* __STDC__ */


/* possible return values:
 * Zero or positive number is exit status of child process.
 * Negative numbers indicate an error as defined below.
 */
#define OK              0	/* this is not exactly an error */
#define CMDPROC_EMPTY  -1	/* empty string for command processor */
#define NO_MORE_CORE   -3	/* calloc(3) failed */
#define FORK_FAILED    -4	/* [v]fork(2) failed */
#define PIPE_FAILED    -5	/* pipe(2) failed */
#define WAIT_ERROR     -6	/* waitpid(2) failed */
#define EXEC_FAILED    -7	/* execvp(3) failed */
#define CHILD_KILLED   -8	/* child process did not terminate normally */
#define WRITE_FAILED   -9	/* write(2) to pipe failed */
#define NO_PROGRAM    -10	/* command processor program not found */

/* may contain additional information: */
extern int at_callcmd_errno ;


#endif /* __ATFSAPP_HDR__ */
