/* Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
#ifndef lint
static char *ATFSid = "$Header: sighand.c[3.17] Wed Feb  5 18:10:15 1992 axel@cs.tu-berlin.de accessed $";
#ifdef CFFLGS
static char *ConfFlg = CFFLGS;
	/* should be defined from within Makefile */
#endif
#endif

/*LINTLIBRARY*/

#include <signal.h>
#include <stdio.h>
#include <atfs.h>
#include "atfsapp.h"

struct Transaction ThisTransaction;
int nfnms;

CatchSigs () {
/*
 * Setup signal handlers for various signals.
 * On receipt of a signal, the 
 * original handler for this signal will be invoked after specified
 * action has been taken.
 */

extern Sfunc_t interrupt_action();

Sfunc_t    die1(), die2(), die3(), die4(), die5(), die6(), 
       die7(), die8(), die9(), die10(),
       die11(), die12(), die13(), die14(), die15();

(void)signal (SIGINT, die2);
(void)signal (SIGQUIT, die3);
(void)signal (SIGBUS, die10);
(void)signal (SIGSEGV, die11);
(void)signal (SIGFPE, die8);
(void)signal (SIGTERM, die15);
}

extern jmp_buf here;

#ifdef SIGCONT
CatchCont () {
  Sfunc_t conthand();

  (void)signal (SIGCONT, conthand);
}

UnCatchCont () {
  (void)signal (SIGCONT, SIG_DFL);
}

static Sfunc_t conthand () {
  char messg [MSGLEN];

  (void)sprintf (messg, "%s:", ThisTransaction.tr_fname);
  logmsg (messg);
  longjmp (here, 1);
}
    
#endif

static Sfunc_t die1 () {
}

static Sfunc_t die2 () {
  Sfunc_t interrupt_action();

  disableSig (SIGINT);     
  (void)signal (SIGINT, die2);
  af_cleanup ();
  kill_tmpfiles ();
  enableSig ();
  interrupt_action();
}

void quit () {
  (void)signal (SIGQUIT, SIG_DFL);
  kill (getpid(), SIGQUIT);
}

static Sfunc_t die3 () {
  logerr (" Oh! Oh! .... received SIGQUIT -- goodbye.");
  disableSig (SIGQUIT);     
  af_cleanup ();
  kill_tmpfiles ();
  enableSig ();
  quit();
}

static Sfunc_t die8 () {
  /* do eventual cleanup and execute previously defined action */
  logerr (" Oh! Oh! .... this was a floating exception -- goodbye."); 
  disableSig (SIGFPE);     
  af_cleanup ();
  kill_tmpfiles ();
  enableSig ();
  quit();
}

static Sfunc_t die10 () {
  /* do eventual cleanup and execute previously defined action */
  
  logerr ("Oh! Oh! .... this was a buserror -- goodbye.");
  disableSig (SIGBUS);     
  logerr ("Dumping core.");
  af_cleanup ();
  kill_tmpfiles ();
  quit();
}

static Sfunc_t die11 () {
  /* do eventual cleanup and execute previously defined action */

  logerr ("Oh! Oh! .... this was a segmentation violation -- goodbye.");
  disableSig (SIGSEGV);     
  logerr ("Dumping core.");
  af_cleanup ();
  kill_tmpfiles ();
  quit();
}

static Sfunc_t die15 () {
  /* do eventual cleanup and restore previously saved context for */
  /* next transaction */

  (void)signal (SIGTERM, die15);
  kill_tmpfiles ();
  kill_afsets();
  kill_afkeys();
  kill_afattrbufs();
  af_cleanup ();
  ThisTransaction.tr_rc = 1; /* indicating that something went wrong */
  longjmp (ThisTransaction.tr_env, 1);
}

#define sm(i) (1 << (i))

abort_this (domsg) {
  if (domsg)
    logmsg ("...aborting");
  (void)kill (getpid(), SIGTERM); 
  /* abort current execution phase and restore */
  /* a clean context for next phase */
}

/*
 *  Utilities for housekeeping with various allocated 
 *  system resources.
 */

char tmpnames[MAXTMPF][MAXPATHLEN+1];
Af_set *afsets[MAXSETS];
Af_key *afkeys[MAXKEYS];
Af_attrs *afattrbufs[MAXATTRBUFS];

Register (data, type) char *data; short type; {
  register int i, ok;

  if (!data) return; /* NULL pointers not registered */

  switch (type) {
  case TYPEF: /* temporary filenames */
    ok = FALSE;
    for (i=0; i < MAXTMPF; i++) {
      if (tmpnames[i][0]) continue;
      else {
	(void)strcpy (tmpnames[i], data);
	ok = TRUE;
	break;                      /* I admit: UGLY! */
      }
    }
    if (!ok) {
      logerr ("internal error in resource tables");
    }
    break;
  case AFSET:
    ok = FALSE;
    for (i = 0; i < MAXSETS; i++) {
      if (afsets[i]) continue;
      else {
	afsets[i] = (Af_set *)data;
	ok = TRUE;
	break;
      }
    }
    if (!ok) {
      logerr ("resource table error -- Af_set table overflow");
    }
    break;
  case AFKEY:
    ok = FALSE;
    for (i = 0; i < MAXSETS; i++) {
      if (afkeys[i]) continue;
      else {
	afkeys[i] = (Af_key *)data;
	ok = TRUE;
	break;
      }
    }
    if (!ok) {
      logerr ("resource table error -- Af_key table overflow");
    }
    break;
  case AFATTRS:
    ok = FALSE;
    for (i = 0; i < MAXATTRBUFS; i++) {
      if (afattrbufs[i]) continue;
      else {
	afattrbufs[i] = (Af_attrs *)data;
	ok = TRUE;
	break;
      }
    }
    if (!ok) {
      logerr ("resource table error -- Af_attrbuf table overflow");
    }
    break;
  default: /* shouldn't happen */
    logerr ("internal error in resource tables (types)");
  }
}

UnRegister (data, type) char *data; short type; {
  register int i;

  switch (type) {
  case TYPEF:
    for (i=0; i < MAXTMPF; i++) {
      if (tmpnames[i][0]) {
	if (!strcmp (tmpnames[i], data)) {
	  if (i < MAXTMPF-1) {
	    bcopy (tmpnames[i+1], tmpnames[i], MAXTMPF-(i+1));
	    if (tmpnames[MAXTMPF-1][0]) tmpnames[MAXTMPF-1][0] = '\0';
	  }
	  else {
	    tmpnames[i][0] = '\0';
	  }
	  break; /* bail out of for-loop */
	}
	else {
	  continue;
	}
      }
      else {
	break; /* no more entries in list */
      }
    }
    break;
  case AFSET:
    for (i = 0; i < MAXSETS; i++) {
      if (afsets[i] == (Af_set *)data) {
	afsets[i] = (Af_set *)NULL;
	break;
      }
    }
    break;
  case AFKEY:      
    for (i = 0; i < MAXKEYS; i++) {
      if (afkeys[i] == (Af_key *)data) {
	afkeys[i] = (Af_key *)NULL;
	break;
      }
    }
    break;
  case AFATTRS:
    for (i = 0; i < MAXATTRBUFS; i++) {
      if (afattrbufs[i] == (Af_attrs *)data) {
	afattrbufs[i] = (Af_attrs *)NULL;
	break;
      }
    }
    break;
  default: /* shouldn't happen */
    logerr ("internal error in resource tables (unregister)");
  }
}

kill_tmpfiles () { /* do this before exiting */
  register int i;

  for (i=0; i < MAXTMPF; i++) {
    if (tmpnames[i][0])
      (void)unlink (tmpnames[i]);
    else break;  /* save two or three nanoseconds */
  }
}

kill_afsets () { 
  register int i;

  for (i = 0; i < MAXSETS; i++) {
    if (afsets[i])
      af_dropset (afsets[i]);
  }
}

kill_afkeys () { 
  register int i;

  for (i = 0; i < MAXKEYS; i++) {
    if (afkeys[i])
      af_dropkey (afkeys[i]);
  }
}

kill_afattrbufs () {
  register int i;

  for (i = 0; i < MAXATTRBUFS; i++) {
    if (afattrbufs[i])
      udafree (afattrbufs[i]);
  }
}
