/*  Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
#ifndef lint
static char *AtFSid = "$Header: attr.c[1.23] Sat Feb  8 15:37:30 1992 axel@cs.tu-berlin.de accessed $";
#endif

#include <stdio.h>

#include "shape.h"

extern char *re_comp(), *malloc();
extern int re_exec();

extern char *replace();
extern int errexit(), get_attr_type(), get_state_no();

extern struct vardef variantDefs[];
extern char dollarplus[], prev_dir[];

int err;

extern Bool check_vclass();

Bool pattern(string, patt, set)
     char *string;
     char *patt;
     /*ARGSUSED*/
     Af_set *set;
{
register char *retcode, *pat;

if (string == NIL)
  return(FALSE);

pat = replace(patt);

if ((retcode = re_comp(pat)) != 0)
  {
    (void) strcat(retcode, ": re_comp");
    errexit(10, "re_comp");
  }

if (re_exec(string) == 1)
    return (TRUE);
else
  return(FALSE);
}

Bool msg(name, value, set)
     char *name;
     char *value;
     /*ARGSUSED*/
     Af_set *set;
{
register char *p, *message;
char message2[256];
register int len;

  if(nomsgflg)
    return(TRUE);

  (void) strcpy(message2,name);
  if (strcmp(value,""))
    {
      (void) strcat(message2," ");
      (void) strcat(message2,value);
    }
  message = &message2[0];

  len = strlen(message) - 1;
  
  if (((message[0] == '\'') && (message[len] == '\'')) ||
      ((message[0] == '\"') && (message[len] == '\"')))
    {
      message[len] = '\0';
      message++;
    }

  if (((p = index(message,'$')) != NIL) && (*(p+1) == '+'))
    {
      *p = '\0';
      printf("%s%s%s", message, dollarplus, p+2);
    }
  else
    {
      if (strcmp(message,""))
	printf("%s", message);
    }
  printf("\n");
  (void) fflush(stdout);

/*  (void) strcpy(dollarplus,""); */

  return(TRUE);
}

Bool confirm (name, value, set)
     char *name;
     char *value;
     /*ARGSUSED*/
     Af_set *set;
{
  if(nomsgflg)
    return(TRUE);

  return (ask_confirm (name, value));
}

Bool tunix(name, value, set)
     /*ARGSUSED*/
     char *name;
     char *value;
     Af_set *set;
{
  tunixflg = TRUE;
  return (TRUE);
}

Bool stopit(name, value, set)
     /*ARGSUSED*/
     char *name;
     char *value;
     Af_set *set;
{
  stopflg = TRUE;
  return(TRUE);
}

Bool attr(name, value, set)
     char *name;
     char *value;
     Af_set *set;
{
int attr_type, nrofkeys, pos1;
register int i, cur_pos;

Af_key cur_key;

Af_attrs cur_attrbuf;

Bool last_match, found, attr_found;

char val1[256];
char *val2, *val3;

attr_type = get_attr_type(name);

if ((nrofkeys = af_nrofkeys(set)) == -1)
  errexit(10, "af_nrofkeys");

switch (attr_type)
  {
  case 0 :
    if ((af_sortset(set,AF_ATTGEN)) == -1)
      errexit(10,"af_sortset");
    break;
  case 1 :
    if ((af_sortset(set,AF_ATTREV)) == -1)
      errexit(10,"af_sortset");
    break;
  case 2 :
    if ((af_sortset(set,AF_ATTSTATE)) == -1)
      errexit(10,"af_sortset");
    break;
  case 3 :
    if ((af_sortset(set,AF_ATTAUTHOR)) == -1)
      errexit(10,"af_sortset");
    break;
  case 4 :
    errexit(10,"group id");
    break;
  case 5 :
    if ((af_sortset(set,AF_ATTVERSION)) == -1)
      errexit(10,"af_sortset");
    break;
  case 7:
    if ((af_sortset(set,AF_ATTSPATH)) == -1)
      errexit(10,"af_sortset");
    break;
  case 8:
    if ((af_sortset(set,AF_ATTHOST)) == -1)
      errexit(10,"af_sortset");
    break;
  case 9 :
    if ((af_sortset(set,AF_ATTLOCKER)) == -1)
      errexit(10,"af_sortset");
    break;
  case 10 :
    if ((af_sortset(set,AF_ATTOWNER)) == -1)
      errexit(10,"af_sortset");
    break;
  default :
    if ((af_sortset(set,name)) == -1)
      errexit(10,"af_sortset");
  }

cur_pos = 0;
last_match = FALSE;
found = FALSE;

while ((cur_pos < nrofkeys) && (!(last_match)))
  {
    if ((err = af_setgkey(set, cur_pos, &cur_key)) == -1)
      errexit(10, "af_setgkey");
    
    if (af_gattrs(&cur_key, &cur_attrbuf) == -1)
      errexit(10, "af_gattrs");

    switch (attr_type)
      {
      case 0 :
	if (cur_attrbuf.af_gen != atoi(value))
	  {
	    if (found)
	      last_match = TRUE;
	    else
	      cur_pos++;    /* here probably better : */
           /* if (cur_attrbuf.af_gen > atoi(value)) */
           /*   cur_pos = nrofkeys;                  */
           /* else                                   */
           /*   cur_pos++;                           */
	  }
	else
	  {
	    if (!(found))
	      {
		found = TRUE;
		pos1 = cur_pos;
	      }
	    cur_pos++;
	  }
	break;
      case 1 :
	if (cur_attrbuf.af_rev != atoi(value))
	  {
	    if (found)
	      last_match = TRUE;
	    else
	      cur_pos++;
	  }
	else
	  {
	    if (!(found))
	      {
		found = TRUE;
		pos1 = cur_pos;
	      }
	    cur_pos++;
	  }
	break;
      case 2 :
	if ((int) cur_attrbuf.af_state != get_state_no(value))
	  {
	    if (found)
	      last_match = TRUE;
	    else
	      cur_pos++;
	  }
	else
	  {
	    if (!(found))
	      {
		found = TRUE;
		pos1 = cur_pos;
	      }
	    cur_pos++;
	  }
	break;
      case 3 :
	if (strcmp(cur_attrbuf.af_author.af_username,value))
	  {
	    if (found)
	      last_match = TRUE;
	    else
	      cur_pos++;
	  }
	else
	  {
	    if (!(found))
	      {
		found = TRUE;
		pos1 = cur_pos;
	      }
	    cur_pos++;
	  }
	break;
      case 4 :
	errexit(10,"group id");
	break;
      case 5 :
	(void) strcpy(val1, value);
	if ((val2 = index(val1,'.')) == 0)
	  errexit(9, value);
	val2[0] = '\0';
	val2++;
	if ((atoi(val1) == cur_attrbuf.af_gen)
	    && (atoi(val2) == cur_attrbuf.af_rev))
	  {
	    if (!(found))
	      {
		found = TRUE;
		pos1 = cur_pos;
	      }
	    cur_pos++;
	  }
	else
	  {
	    if (found)
	      last_match = TRUE;
	    else
	      cur_pos++;
	  }
	break;
      case 7 :
	if (strcmp(cur_attrbuf.af_syspath,value))
	  {
	    if (found)
	      last_match = TRUE;
	    else
	      cur_pos++;
	  }
	else
	  {
	    if (!(found))
	      {
		found = TRUE;
		pos1 = cur_pos;
	      }
	    cur_pos++;
	  }
	break;
      case 8 :
	if (strcmp(cur_attrbuf.af_host,value))
	  {
	    if (found)
	      last_match = TRUE;
	    else
	      cur_pos++;
	  }
	else
	  {
	    if (!(found))
	      {
		found = TRUE;
		pos1 = cur_pos;
	      }
	    cur_pos++;
	  }
	break;
      case 9 :
	if (strcmp(cur_attrbuf.af_locker.af_username,value))
	  {
	    if (found)
	      last_match = TRUE;
	    else
	      cur_pos++;
	  }
	else
	  {
	    if (!(found))
	      {
		found = TRUE;
		pos1 = cur_pos;
	      }
	    cur_pos++;
	  }
	break;
      case 10 :
	if (strcmp(cur_attrbuf.af_owner.af_username,value))
	  {
	    if (found)
	      last_match = TRUE;
	    else
	      cur_pos++;
	  }
	else
	  {
	    if (!(found))
	      {
		found = TRUE;
		pos1 = cur_pos;
	      }
	    cur_pos++;
	  }
	break;
      default :
/* af_udattrs must contain a '=', even if they don't contain a value */
/* currently only the first value (if existing) in the string is     */
/* considered */
	i = 0;
	attr_found = FALSE;
/* find name in list of udattrs */
	while ((!(attr_found)) && (i < AF_MAXUDAS) &&
	       (cur_attrbuf.af_udattrs[i] != NIL))
	  {
	    (void) strcpy(val1, cur_attrbuf.af_udattrs[i]);
	    if ((val2 = index(val1, '=')) == 0)
	      errexit(10, "attr");
	    val2[0] = '\0';
	    if (strcmp(name, val1) != 0)
	      i++;
	    else
	      attr_found = TRUE;
	  }
/* name should be found now */
	if (!(attr_found))
	  errexit(10, "attr");

/* value comparison */
	val2++;
	if (*val2 == '\0')        /* no value given is considered as != */
	  {
	    if (found)
	      last_match = TRUE;
	    else
	      cur_pos++;
	  }
	else
	  {
	    if ((val3 = index(val2, AF_UDAVALDEL)) != 0) 
	      val3[0] = '\0';     /* only first value in attrbuf is     */
                                  /* considered; parameter value should */
                                  /* contain only one value             */
	    if (strcmp(value, val2) == 0)
	      {
		if (!(found))
		  {
		    found = TRUE;
		    pos1 = cur_pos;
		  }
		cur_pos++;
	      }
	    else
	      {
		if (found)
		  last_match = TRUE;
		else
		  cur_pos++;
	      }
	  }
      }
    if(cur_attrbuf.af_udattrs[0] != NIL)
      free(cur_attrbuf.af_udattrs[0]);
  }

if (!(found))
  cur_pos = 0;
else
  {
    i = pos1;
    while (i > 0)
      {
	if (af_setposrmkey(set, 0) == -1)
	  errexit(10, "af_setposrmkey");
	i--;
	cur_pos--;
	nrofkeys--;
      }
  }

while (cur_pos < nrofkeys)
  {
    if (af_setposrmkey(set, cur_pos) == -1)
      errexit(10, "af_setposrmkey");
    nrofkeys--;
  }
if (nrofkeys == 0)
  {
    return (FALSE);
  }
else
  {
    return (TRUE);
  }
}

Bool attrnot(name, value, set)
     char *name;
     char *value;
     Af_set *set;
{
int attr_type, nrofkeys, pos1;
register int i, cur_pos;
Af_key cur_key;

Af_attrs cur_attrbuf;

Bool last_match, found, attr_found;

char val1[256];
char *val2, *val3;

attr_type = get_attr_type(name);

if ((nrofkeys = af_nrofkeys(set)) == -1)
  errexit(10, "af_nrofkeys");

switch (attr_type)
  {
  case 0 :
    if ((af_sortset(set,AF_ATTGEN)) == -1)
      errexit(10,"af_sortset");
    break;
  case 1 :
    if ((af_sortset(set,AF_ATTREV)) == -1)
      errexit(10,"af_sortset");
    break;
  case 2 :
    if ((af_sortset(set,AF_ATTSTATE)) == -1)
      errexit(10,"af_sortset");
    break;
  case 3 :
    if ((af_sortset(set,AF_ATTAUTHOR)) == -1)
      errexit(10,"af_sortset");
    break;
  case 4 :
    errexit(10,"group id");
    break;
  case 5 :
    if ((af_sortset(set,AF_ATTVERSION)) == -1)
      errexit(10,"af_sortset");
    break;
  case 7:
    if ((af_sortset(set,AF_ATTSPATH)) == -1)
      errexit(10,"af_sortset");
    break;
  case 8:
    if ((af_sortset(set,AF_ATTHOST)) == -1)
      errexit(10,"af_sortset");
    break;
  case 9 :
    if ((af_sortset(set,AF_ATTLOCKER)) == -1)
      errexit(10,"af_sortset");
    break;
  case 10 :
    if ((af_sortset(set,AF_ATTOWNER)) == -1)
      errexit(10,"af_sortset");
  default :
    if ((af_sortset(set,name)) == -1)
      errexit(10,"af_sortset");
  }

cur_pos = 0;
last_match = FALSE;
found = FALSE;

while ((cur_pos < nrofkeys) && (!(last_match)))
  {
    if ((err = af_setgkey(set, cur_pos, &cur_key)) == -1)
      errexit(10, "af_setgkey");
    
    if (af_gattrs(&cur_key, &cur_attrbuf) == -1)
      errexit(10, "af_gattrs");

    switch (attr_type)
      {
      case 0 :
	if (cur_attrbuf.af_gen != atoi(value))
	  {
	    if (found)
	      last_match = TRUE;
	    else
	      cur_pos++;    /* here probably better : */
           /* if (cur_attrbuf.af_gen > atoi(value)) */
           /*   cur_pos = nrofkeys;                  */
           /* else                                   */
           /*   cur_pos++;                           */
	  }
	else
	  {
	    if (!(found))
	      {
		found = TRUE;
		pos1 = cur_pos;
	      }
	    cur_pos++;
	  }
	break;
      case 1 :
	if (cur_attrbuf.af_rev != atoi(value))
	  {
	    if (found)
	      last_match = TRUE;
	    else
	      cur_pos++;
	  }
	else
	  {
	    if (!(found))
	      {
		found = TRUE;
		pos1 = cur_pos;
	      }
	    cur_pos++;
	  }
	break;
      case 2 :
	if ((int) cur_attrbuf.af_state != get_state_no(value))
	  {
	    if (found)
	      last_match = TRUE;
	    else
	      cur_pos++;
	  }
	else
	  {
	    if (!(found))
	      {
		found = TRUE;
		pos1 = cur_pos;
	      }
	    cur_pos++;
	  }
	break;
      case 3 :
	{
	  char user_at_domain[MAXUSERNAMELEN+MAXDOMAIN];
	  Af_user *auth = &cur_attrbuf.af_author;

	  user_at_domain[0] = '\0';
	  (void) sprintf (user_at_domain, "%s%s%s", 
			  auth->af_username && *(auth->af_username) ?
			  auth->af_username : "",
			  auth->af_userdomain && *(auth->af_userdomain) ?
			  "@" : "",
			  auth->af_userdomain && *(auth->af_userdomain) ?
			  auth->af_userdomain : "");
	  
	  if (strcmp(user_at_domain, value)) {
	    if (found)
	      last_match = TRUE;
	    else
	      cur_pos++;
	  }
	  else {
	    if (!(found)) {
	      found = TRUE;
	      pos1 = cur_pos;
	    }
	    cur_pos++;
	  }
	}
	break;
      case 4 :
	errexit(10,"group id");
	break;
      case 5 :
	(void) strcpy(val1, value);
	if ((val2 = index(val1,'.')) == 0)
	  errexit(9, value);
	val2[0] = '\0';
	val2++;
	if ((atoi(val1) == cur_attrbuf.af_gen)
	    && (atoi(val2) == cur_attrbuf.af_rev))
	  {
	    if (!(found))
	      {
		found = TRUE;
		pos1 = cur_pos;
	      }
	    cur_pos++;
	  }
	else
	  {
	    if (found)
	      last_match = TRUE;
	    else
	      cur_pos++;
	  }
	break;
      case 7 :
	if (strcmp(cur_attrbuf.af_syspath,value))
	  {
	    if (found)
	      last_match = TRUE;
	    else
	      cur_pos++;
	  }
	else
	  {
	    if (!(found))
	      {
		found = TRUE;
		pos1 = cur_pos;
	      }
	    cur_pos++;
	  }
	break;
      case 8 :
	if (strcmp(cur_attrbuf.af_host,value))
	  {
	    if (found)
	      last_match = TRUE;
	    else
	      cur_pos++;
	  }
	else
	  {
	    if (!(found))
	      {
		found = TRUE;
		pos1 = cur_pos;
	      }
	    cur_pos++;
	  }
	break;
      case 9 :
	{
	  char user_at_domain[MAXUSERNAMELEN+MAXDOMAIN];
	  Af_user *lckr = &cur_attrbuf.af_locker;

	  user_at_domain[0] = '\0';
	  (void) sprintf (user_at_domain, "%s%s%s", 
			  lckr->af_username && *(lckr->af_username) ?
			  lckr->af_username : "",
			  lckr->af_userdomain && *(lckr->af_userdomain) ?
			  "@" : "",
			  lckr->af_userdomain && *(lckr->af_userdomain) ?
			  lckr->af_userdomain : "");
	  
	  if (strcmp(user_at_domain, value)) {
	    if (found)
	      last_match = TRUE;
	    else
	      cur_pos++;
	  }
	  else {
	    if (!(found)) {
	      found = TRUE;
	      pos1 = cur_pos;
	    }
	    cur_pos++;
	  }
	}
	break;
      case 10 :
	{
	  char user_at_domain[MAXUSERNAMELEN+MAXDOMAIN];
	  Af_user *ownr = &cur_attrbuf.af_owner;

	  user_at_domain[0] = '\0';
	  (void) sprintf (user_at_domain, "%s%s%s", 
			  ownr->af_username && *(ownr->af_username) ?
			  ownr->af_username : "",
			  ownr->af_userdomain && *(ownr->af_userdomain) ?
			  "@" : "",
			  ownr->af_userdomain && *(ownr->af_userdomain) ?
			  ownr->af_userdomain : "");
	  
	  if (strcmp(user_at_domain, value)) {
	    if (found)
	      last_match = TRUE;
	    else
	      cur_pos++;
	  }
	  else {
	    if (!(found)) {
	      found = TRUE;
	      pos1 = cur_pos;
	    }
	    cur_pos++;
	  }
	}
	break;
	default :
/* af_udattrs must contain a '=', even if they don't contain a value */
/* currently only the first value (if existing) in the string is     */
/* considered */
	i = 0;
	attr_found = FALSE;
/* find name in list of udattrs */
	while ((!(attr_found)) && (i < AF_MAXUDAS) &&
	       (cur_attrbuf.af_udattrs[i] != NIL))
	  {
	    (void) strcpy(val1, cur_attrbuf.af_udattrs[i]);
	    if ((val2 = index(val1, '=')) == 0)
	      errexit(10, "attrnot");
	    val2[0] = '\0';
	    if (strcmp(name, val1) != 0)
	      i++;
	    else
	      attr_found = TRUE;
	  }
/* name should be found now */
	if (!(attr_found))
	  errexit(10, "attrnot");

/* value comparison */
	val2++;
	if (*val2 == '\0')        /* no value given is considered as != */
	  {
	    if (found)
	      last_match = TRUE;
	    else
	      cur_pos++;
	  }
	else
	  {
	    if ((val3 = index(val2, AF_UDAVALDEL)) != 0) 
	      val3[0] = '\0';     /* only first value in attrbuf is     */
                                  /* considered; parameter value should */
                                  /* contain only one value             */
	    if (strcmp(value, val2) == 0)
	      {
		if (!(found))
		  {
		    found = TRUE;
		    pos1 = cur_pos;
		  }
		cur_pos++;
	      }
	    else
	      {
		if (found)
		  last_match = TRUE;
		else
		  cur_pos++;
	      }
	  }
      }
    if(cur_attrbuf.af_udattrs[0] != NIL)
      free(cur_attrbuf.af_udattrs[0]);
  }

if (!(found))
  {
    return (TRUE);
  }
else
  {
    i = (cur_pos - pos1);
    while (i > 0)
      {
	if (af_setposrmkey(set, pos1) == -1)
	  errexit(10, "af_setposrmkey");
	i--;
	nrofkeys--;
      }
    if (nrofkeys == 0)
      {
	return (FALSE);
      }
    else
      {
	return (TRUE);
      }
  }
}

Bool attrlt(name, value, set)
     char *name;
     char *value;
     Af_set *set;
{
int attr_type, nrofkeys;
register int i, cur_pos;
Af_key cur_key;

Af_attrs cur_attrbuf;

Bool match, found;

char val1[256];
char *val2, *val3;

attr_type = get_attr_type(name);

if ((nrofkeys = af_nrofkeys(set)) == -1)
  errexit(10, "af_nrofkeys");

switch (attr_type)
  {
  case 0 :
    if ((af_sortset(set,AF_ATTGEN)) == -1)
      errexit(10,"af_sortset");
    break;
  case 1 :
    if ((af_sortset(set,AF_ATTREV)) == -1)
      errexit(10,"af_sortset");
    break;
  case 2 :
    if ((af_sortset(set,AF_ATTSTATE)) == -1)
      errexit(10,"af_sortset");
    break;
  case 3 :
    if ((af_sortset(set,AF_ATTAUTHOR)) == -1)
      errexit(10,"af_sortset");
    break;
  case 4 :
    errexit(10,"group id");
    break;
  case 5 :
    if ((af_sortset(set,AF_ATTVERSION)) == -1)
      errexit(10,"af_sortset");
    break;
  case 7:
    if ((af_sortset(set,AF_ATTSPATH)) == -1)
      errexit(10,"af_sortset");
    break;
  case 8:
    if ((af_sortset(set,AF_ATTHOST)) == -1)
      errexit(10,"af_sortset");
    break;
  case 9 :
    if ((af_sortset(set,AF_ATTLOCKER)) == -1)
      errexit(10,"af_sortset");
    break;
  case 10 :
    if ((af_sortset(set,AF_ATTOWNER)) == -1)
      errexit(10,"af_sortset");
  default :
    if ((af_sortset(set,name)) == -1)
      errexit(10,"af_sortset");
  }

cur_pos = 0;
match = TRUE;

while ((cur_pos < nrofkeys) && match)
  {
    if ((err = af_setgkey(set, cur_pos, &cur_key)) == -1)
      errexit(10, "af_setgkey");
    
    if (af_gattrs(&cur_key, &cur_attrbuf) == -1)
      errexit(10, "af_gattrs");

    switch (attr_type)
      {
      case 0 :
	if (cur_attrbuf.af_gen < atoi(value))
	  cur_pos++;
	else
	  match = FALSE;
	break;
      case 1 :
	if (cur_attrbuf.af_rev < atoi(value))
	  cur_pos++;
	else
	  match = FALSE;
	break;
      case 2 :
	if ((int) cur_attrbuf.af_state < get_state_no(value))
	  cur_pos++;
	else
	  match = FALSE;
	break;
      case 3 :
	if ((strcmp(cur_attrbuf.af_author.af_username,value)) < 0)
	  cur_pos++;
	else
	  match = FALSE;
	break;
      case 4 :
	errexit(10,"group id");
	break;
      case 5 :
	(void) strcpy(val1, value);
	if ((val2 = index(val1,'.')) == 0)
	  errexit(9, value);
	val2[0] = '\0';
	val2++;
	if (atoi(val1) < cur_attrbuf.af_gen)
	  match = FALSE;
	else
	  {
	    if ((atoi(val1) == cur_attrbuf.af_gen) &&
		(atoi(val2) <= cur_attrbuf.af_rev))
	      match = FALSE;
	    else
	      cur_pos++;
	  }
	break;
      case 7 :
	if ((strcmp(cur_attrbuf.af_syspath,value)) < 0)
	  cur_pos++;
	else
	  match = FALSE;
	break;
      case 8 :
	if ((strcmp(cur_attrbuf.af_host,value)) < 0 )
	  cur_pos++;
	else
	  match = FALSE;
	break;
      case 9 :
	if ((strcmp(cur_attrbuf.af_locker.af_username,value)) < 0)
	  cur_pos++;
	else
	  match = FALSE;
	break;
      case 10 :
	if ((strcmp(cur_attrbuf.af_owner.af_username,value)) < 0)
	  cur_pos++;
	else
	  match = FALSE;
	break;
      default :
/* af_udattrs must contain a '=', even if they don't contain a value */
/* currently only the first value (if existing) in the string is     */
/* considered */
	i = 0;
	found = FALSE;
/* find name in list of udattrs */
	while ((!(found)) && (i < AF_MAXUDAS) &&
	       (cur_attrbuf.af_udattrs[i] != NIL))
	  {
	    (void) strcpy(val1, cur_attrbuf.af_udattrs[i]);
	    if ((val2 = index(val1, '=')) == 0)
	      errexit(10, "attrlt");
	    val2[0] = '\0';
	    if (strcmp(name, val1) != 0)
	      i++;
	    else
	      found = TRUE;
	  }
/* name should be found now */
	if (!(found))
	  errexit(10, "attrlt");

/* value comparison */
	val2++;
	if (*val2 == '\0')        /* no value given is considered as != */
	  cur_pos++;
	else
	  {
	    if ((val3 = index(val2, AF_UDAVALDEL)) != 0) 
	      val3[0] = '\0';     /* only first value in attrbuf is     */
                                  /* considered; parameter value should */
                                  /* contain only one value             */
	    if (strcmp(value, val2) <= 0)
	      match = FALSE;
	    else
	      cur_pos++;
	  }
      }
    if(cur_attrbuf.af_udattrs[0] != NIL)
      free(cur_attrbuf.af_udattrs[0]);
  }  
if (match)
  {
    return (TRUE);
  }
else                             /* remove keys from set if necessary */
  {
    while (cur_pos < nrofkeys)
      {
	if (af_setposrmkey(set, cur_pos) == -1)
	  errexit(10, "af_setposrmkey");
	nrofkeys--;
      }
    if (nrofkeys == 0)
      {
	return (FALSE);
      }
    else
      {
	return (TRUE);
      }
  }

}

Bool attrgt(name, value, set)
     char *name;
     char *value;
     Af_set *set;
{
int attr_type, nrofkeys;
register int cur_pos, i;

Af_key cur_key;

Af_attrs cur_attrbuf;

Bool match, found;

char val1[256];
char *val2, *val3;

attr_type = get_attr_type(name);

if ((nrofkeys = af_nrofkeys(set)) == -1)
  errexit(10, "af_nrofkeys");

switch (attr_type)
  {
  case 0 :
    if ((af_sortset(set,AF_ATTGEN)) == -1)
      errexit(10,"af_sortset");
    break;
  case 1 :
    if ((af_sortset(set,AF_ATTREV)) == -1)
      errexit(10,"af_sortset");
    break;
  case 2 :
    if ((af_sortset(set,AF_ATTSTATE)) == -1)
      errexit(10,"af_sortset");
    break;
  case 3 :
    if ((af_sortset(set,AF_ATTAUTHOR)) == -1)
      errexit(10,"af_sortset");
    break;
  case 4 :
    errexit(10,"group id");
    break;
  case 5 :
    if ((af_sortset(set,AF_ATTVERSION)) == -1)
      errexit(10,"af_sortset");
    break;
  case 7:
    if ((af_sortset(set,AF_ATTSPATH)) == -1)
      errexit(10,"af_sortset");
    break;
  case 8:
    if ((af_sortset(set,AF_ATTHOST)) == -1)
      errexit(10,"af_sortset");
    break;
  case 9 :
    if ((af_sortset(set,AF_ATTLOCKER)) == -1)
      errexit(10,"af_sortset");
    break;
  case 10 :
    if ((af_sortset(set,AF_ATTOWNER)) == -1)
      errexit(10,"af_sortset");
  default :
    if ((af_sortset(set,name)) == -1)
      errexit(10,"af_sortset");
  }

cur_pos = (nrofkeys - 1);
match = TRUE;

while ((cur_pos >= 0) && match)
  {
    if ((err = af_setgkey(set, cur_pos, &cur_key)) == -1)
      errexit(10, "af_setgkey");
    
    if (af_gattrs(&cur_key, &cur_attrbuf) == -1)
      errexit(10, "af_gattrs");

    switch (attr_type)
      {
      case 0 :
	if (cur_attrbuf.af_gen > atoi(value))
	  cur_pos--;
	else
	  match = FALSE;
	break;
      case 1 :
	if (cur_attrbuf.af_rev > atoi(value))
	  cur_pos--;
	else
	  match = FALSE;
	break;
      case 2 :
	if ((int) cur_attrbuf.af_state > get_state_no(value))
	  cur_pos--;
	else
	  match = FALSE;
	break;
      case 3 :
	if ((strcmp(cur_attrbuf.af_author.af_username,value)) > 0)
	  cur_pos--;
	else
	  match = FALSE;
	break;
      case 4 :
	errexit(10,"group id");
	break;
      case 5 :
	(void) strcpy(val1, value);
	if ((val2 = index(val1,'.')) == 0)
	  errexit(9, value);
	val2[0] = '\0';
	val2++;
	if (atoi(val1) > cur_attrbuf.af_gen)
	  match = FALSE;
	else
	  {
	    if ((atoi(val1) == cur_attrbuf.af_gen) &&
		(atoi(val2) >= cur_attrbuf.af_rev))
	      match = FALSE;
	    else
	      cur_pos--;
	  }
	break;
      case 7 :
	if ((strcmp(cur_attrbuf.af_syspath,value)) > 0)
	  cur_pos--;
	else
	  match = FALSE;
	break;
      case 8 :
	if ((strcmp(cur_attrbuf.af_host,value)) > 0)
	  cur_pos--;
	else
	  match = FALSE;
	break;
      case 9 :
	if ((strcmp(cur_attrbuf.af_locker.af_username,value)) > 0)
	  cur_pos--;
	else
	  match = FALSE;
	break;
      case 10 :
	if ((strcmp(cur_attrbuf.af_owner.af_username,value)) > 0)
	  cur_pos--;
	else
	  match = FALSE;
	break;
      default :
/* af_udattrs must contain a '=', even if they don't contain a value */
/* currently only the first value (if existing) in the string is     */
/* considered */
	i = 0;
	found = FALSE;
/* find name in list of udattrs */
	while ((!(found)) && (i < AF_MAXUDAS) &&
	       (cur_attrbuf.af_udattrs[i] != NIL))
	  {
	    (void) strcpy(val1, cur_attrbuf.af_udattrs[i]);
	    if ((val2 = index(val1, '=')) == 0)
	      errexit(10, "attrgt");
	    val2[0] = '\0';
	    if (strcmp(name, val1) != 0)
	      i++;
	    else
	      found = TRUE;
	  }
/* name should be found now */
	if (!(found))
	  errexit(10, "attrgt");

/* value comparison */
	val2++;
	if (*val2 == '\0')        /* no value given is considered as < */
	  match = FALSE;
	else
	  {
	    if ((val3 = index(val2, AF_UDAVALDEL)) != 0) 
	      val3[0] = '\0';     /* only first value is considered */
	    if (strcmp(value, val2) >= 0)
	      match = FALSE;
	    else
	      cur_pos--;
	  }
      }
    if(cur_attrbuf.af_udattrs[0] != NIL)
      free(cur_attrbuf.af_udattrs[0]);
  }
if (match)
  {
    return (TRUE);
  }
else                             /* remove keys from set if necessary */
  {
    while (cur_pos >= 0)
      {
	if (af_setposrmkey(set, cur_pos) == -1)
	  errexit(10, "af_setposrmkey");
	cur_pos--;
	nrofkeys--;
      }
    if (nrofkeys == 0)
      {
	return (FALSE);
      }
    else
      {
	return (TRUE);
      }
  }
}

Bool attrle(name, value, set)
     char *name;
     char *value;
     Af_set *set;
{
int attr_type, nrofkeys;
register int cur_pos, i;

Af_key cur_key;

Af_attrs cur_attrbuf;

Bool match, found;

char val1[256];
char *val2, *val3;

attr_type = get_attr_type(name);

if ((nrofkeys = af_nrofkeys(set)) == -1)
  errexit(10, "af_nrofkeys");

switch (attr_type)
  {
  case 0 :
    if ((af_sortset(set,AF_ATTGEN)) == -1)
      errexit(10,"af_sortset");
    break;
  case 1 :
    if ((af_sortset(set,AF_ATTREV)) == -1)
      errexit(10,"af_sortset");
    break;
  case 2 :
    if ((af_sortset(set,AF_ATTSTATE)) == -1)
      errexit(10,"af_sortset");
    break;
  case 3 :
    if ((af_sortset(set,AF_ATTAUTHOR)) == -1)
      errexit(10,"af_sortset");
    break;
  case 4 :
    errexit(10,"group id");
    break;
  case 5 :
    if ((af_sortset(set,AF_ATTVERSION)) == -1)
      errexit(10,"af_sortset");
    break;
  case 7:
    if ((af_sortset(set,AF_ATTSPATH)) == -1)
      errexit(10,"af_sortset");
    break;
  case 8:
    if ((af_sortset(set,AF_ATTHOST)) == -1)
      errexit(10,"af_sortset");
    break;
  case 9 :
    if ((af_sortset(set,AF_ATTLOCKER)) == -1)
      errexit(10,"af_sortset");
    break;
  case 10 :
    if ((af_sortset(set,AF_ATTOWNER)) == -1)
      errexit(10,"af_sortset");
  default :
    if ((af_sortset(set,name)) == -1)
      errexit(10,"af_sortset");
  }

cur_pos = 0;
match = TRUE;

while ((cur_pos < nrofkeys) && match)
  {
    if ((err = af_setgkey(set, cur_pos, &cur_key)) == -1)
      errexit(10, "af_setgkey");
    
    if (af_gattrs(&cur_key, &cur_attrbuf) == -1)
      errexit(10, "af_gattrs");

    switch (attr_type)
      {
      case 0 :
	if (cur_attrbuf.af_gen <= atoi(value))
	  cur_pos++;
	else
	  match = FALSE;
	break;
      case 1 :
	if (cur_attrbuf.af_rev <= atoi(value))
	  cur_pos++;
	else
	  match = FALSE;
	break;
      case 2 :
	if ((int) cur_attrbuf.af_state <= get_state_no(value))
	  cur_pos++;
	else
	  match = FALSE;
	break;
      case 3 :
	if ((strcmp(cur_attrbuf.af_author.af_username,value)) <= 0)
	  cur_pos++;
	else
	  match = FALSE;
	break;
      case 4 :
	errexit(10,"group id");
	break;
      case 5 :
	(void) strcpy(val1, value);
	if ((val2 = index(val1,'.')) == 0)
	  errexit(9, value);
	val2[0] = '\0';
	val2++;
	if (atoi(val1) < cur_attrbuf.af_gen)
	  match = FALSE;
	else
	  {
	    if ((atoi(val1) == cur_attrbuf.af_gen) &&
		(atoi(val2) < cur_attrbuf.af_rev))
	      match = FALSE;
	    else
	      cur_pos++;
	  }
	break;
      case 7 :
	if ((strcmp(cur_attrbuf.af_syspath,value)) <= 0)
	  cur_pos++;
	else
	  match = FALSE;
	break;
      case 8 :
	if ((strcmp(cur_attrbuf.af_host,value)) <= 0)
	  cur_pos++;
	else
	  match = FALSE;
	break;
      case 9 :
	if ((strcmp(cur_attrbuf.af_locker.af_username,value)) <= 0)
	  cur_pos++;
	else
	  match = FALSE;
	break;
      case 10 :
	if ((strcmp(cur_attrbuf.af_owner.af_username,value)) <= 0)
	  cur_pos++;
	else
	  match = FALSE;
	break;
      default :
/* af_udattrs must contain a '=', even if they don't contain a value */
/* currently only the first value (if existing) in the string is     */
/* considered */
	i = 0;
	found = FALSE;
/* find name in list of udattrs */
	while ((!(found)) && (i < AF_MAXUDAS) &&
	       (cur_attrbuf.af_udattrs[i] != NIL))
	  {
	    (void) strcpy(val1, cur_attrbuf.af_udattrs[i]);
	    if ((val2 = index(val1, '=')) == 0)
	      errexit(10, "attrle");
	    val2[0] = '\0';
	    if (strcmp(name, val1) != 0)
	      i++;
	    else
	      found = TRUE;
	  }
/* name should be found now */
	if (!(found))
	  errexit(10, "attrle");

/* value comparison */
	val2++;
	if (*val2 == '\0')        /* no value given is considered as <= */
	  cur_pos++;
	else
	  {
	    if ((val3 = index(val2, AF_UDAVALDEL)) != 0) 
	      val3[0] = '\0';     /* only first value is considered */
	    if (strcmp(value, val2) < 0)
	      match = FALSE;
	    else
	      cur_pos++;
	  }
      }
    if(cur_attrbuf.af_udattrs[0] != NIL)
      free(cur_attrbuf.af_udattrs[0]);
  }
if (match)
  {
    return (TRUE);
  }
else                             /* remove keys from set if necessary */
  {
    while (cur_pos < nrofkeys)
      {
	if (af_setposrmkey(set, cur_pos) == -1)
	  errexit(10, "af_setposrmkey");
	nrofkeys--;
      }
    if (nrofkeys == 0)
      {
	return (FALSE);
      }
    else
      {
	return (TRUE);
      }
  }
	    
}


Bool attrge(name , value, set)
     char *name;
     char *value;
     Af_set *set;
{
int attr_type, nrofkeys;
register int cur_pos, i;

Af_key cur_key;

Af_attrs cur_attrbuf;

Bool match, found;

char val1[256];
char *val2, *val3;

attr_type = get_attr_type(name);

if ((nrofkeys = af_nrofkeys(set)) == -1)
  errexit(10, "af_nrofkeys");

switch (attr_type)
  {
  case 0 :
    if ((af_sortset(set,AF_ATTGEN)) == -1)
      errexit(10,"af_sortset");
    break;
  case 1 :
    if ((af_sortset(set,AF_ATTREV)) == -1)
      errexit(10,"af_sortset");
    break;
  case 2 :
    if ((af_sortset(set,AF_ATTSTATE)) == -1)
      errexit(10,"af_sortset");
    break;
  case 3 :
    if ((af_sortset(set,AF_ATTAUTHOR)) == -1)
      errexit(10,"af_sortset");
    break;
  case 4 :
    errexit(10,"group id");
    break;
  case 5 :
    if ((af_sortset(set,AF_ATTVERSION)) == -1)
      errexit(10,"af_sortset");
    break;
  case 7:
    if ((af_sortset(set,AF_ATTSPATH)) == -1)
      errexit(10,"af_sortset");
    break;
  case 8:
    if ((af_sortset(set,AF_ATTHOST)) == -1)
      errexit(10,"af_sortset");
    break;
  case 9 :
    if ((af_sortset(set,AF_ATTLOCKER)) == -1)
      errexit(10,"af_sortset");
    break;
  case 10 :
    if ((af_sortset(set,AF_ATTOWNER)) == -1)
      errexit(10,"af_sortset");
  default :
    if ((af_sortset(set,name)) == -1)
      errexit(10,"af_sortset");
  }

cur_pos = (nrofkeys - 1);
match = TRUE;

while ((cur_pos >= 0) && match)
  {
    if ((err = af_setgkey(set, cur_pos, &cur_key)) == -1)
      errexit(10, "af_setgkey");
    
    if (af_gattrs(&cur_key, &cur_attrbuf) == -1)
      errexit(10, "af_gattrs");

    switch (attr_type)
      {
      case 0 :
	if (cur_attrbuf.af_gen >= atoi(value))
	  cur_pos--;
	else
	  match = FALSE;
	break;
      case 1 :
	if (cur_attrbuf.af_rev >= atoi(value))
	  cur_pos--;
	else
	  match = FALSE;
	break;
      case 2 :
	if ((int) cur_attrbuf.af_state >= get_state_no(value))
	  cur_pos--;
	else
	  match = FALSE;
	break;
      case 3 :
	if ((strcmp(cur_attrbuf.af_author.af_username,value)) >= 0)
	  cur_pos--;
	else
	  match = FALSE;
	break;
      case 4 :
	errexit(10,"group id");
	break;
      case 5 :
	(void) strcpy(val1, value);
	if ((val2 = index(val1,'.')) == 0)
	  errexit(9, value);
	val2[0] = '\0';
	val2++;
	if (atoi(val1) > cur_attrbuf.af_gen)
	  match = FALSE;
	else
	  {
	    if ((atoi(val1) == cur_attrbuf.af_gen) &&
		(atoi(val2) > cur_attrbuf.af_rev))
	      match = FALSE;
	    else
	      cur_pos--;
	  }
	break;
      case 7 :
	if ((strcmp(cur_attrbuf.af_syspath,value)) >= 0)
	  cur_pos--;
	else
	  match = FALSE;
	break;
      case 8 :
	if ((strcmp(cur_attrbuf.af_host,value)) >= 0)
	  cur_pos--;
	else
	  match = FALSE;
	break;
      case 9 :
	if ((strcmp(cur_attrbuf.af_locker.af_username,value)) >= 0)
	  cur_pos--;
	else
	  match = FALSE;
	break;
      case 10 :
	if ((strcmp(cur_attrbuf.af_owner.af_username,value)) >= 0)
	if ((strcmp(cur_attrbuf.af_locker.af_username,value)) >= 0)
	  cur_pos--;
	else
	  match = FALSE;
	break;
      default :
/* af_udattrs must contain a '=', even if they don't contain a value */
/* currently only the first value (if existing) in the string is     */
/* considered */
	i = 0;
	found = FALSE;
/* find name in list of udattrs */
	while ((!(found)) && (i < AF_MAXUDAS) &&
	       (cur_attrbuf.af_udattrs[i] != NIL))
	  {
	    (void) strcpy(val1, cur_attrbuf.af_udattrs[i]);
	    if ((val2 = index(val1, '=')) == 0)
	      errexit(10, "attrge");
	    val2[0] = '\0';
	    if (strcmp(name, val1) != 0)
	      i++;
	    else
	      found = TRUE;
	  }
/* name should be found now */
	if (!(found))
	  errexit(10, "attrge");

/* value comparison */
	val2++;
	if (*val2 == '\0')        /* no value given is considered as < */
	  match = FALSE;
	else
	  {
	    if ((val3 = index(val2, AF_UDAVALDEL)) != 0) 
	      val3[0] = '\0';     /* only first value is considered */
	    if (strcmp(value, val2) > 0)
	      match = FALSE;
	    else
	      cur_pos--;
	  }
      }
    if(cur_attrbuf.af_udattrs[0] != NIL)
      free(cur_attrbuf.af_udattrs[0]);
  }
if (match)
  {
    return (TRUE);
  }
else                             /* remove keys from set if necessary */
  {
    while (cur_pos >= 0)
      {
	if (af_setposrmkey(set, cur_pos) == -1)
	  errexit(10, "af_setposrmkey");
	cur_pos--;
	nrofkeys--;
      }
    if (nrofkeys == 0)
      {
	return (FALSE);
      }
    else
      {
	return (TRUE);
      }
  }

}



Bool attrmax(name, value, set)
     char *name;
     char *value;
     Af_set *set;
{
int attr_type, nrofkeys;
register int cur_pos, i;
int udattr_pos;

Af_key cur_key;

Af_attrs cur_attrbuf, max_attrbuf;

Bool match, found;

char val1[256];
char *val2;

attr_type = get_attr_type(name);

if ((nrofkeys = af_nrofkeys(set)) == -1)
  errexit(10, "af_nrofkeys");

switch (attr_type)
  {
  case 0 :
    if ((af_sortset(set,AF_ATTGEN)) == -1)
      errexit(10,"af_sortset");
    break;
  case 1 :
    if ((af_sortset(set,AF_ATTREV)) == -1)
      errexit(10,"af_sortset");
    break;
  case 2 :
    if ((af_sortset(set,AF_ATTSTATE)) == -1)
      errexit(10,"af_sortset");
    break;
  case 3 :
    if ((af_sortset(set,AF_ATTAUTHOR)) == -1)
      errexit(10,"af_sortset");
    break;
  case 4 :
    errexit(10,"group id");
    break;
  case 5 :
    if ((af_sortset(set,AF_ATTVERSION)) == -1)
      errexit(10,"af_sortset");
    break;
  case 7:
    if ((af_sortset(set,AF_ATTSPATH)) == -1)
      errexit(10,"af_sortset");
    break;
  case 8:
    if ((af_sortset(set,AF_ATTHOST)) == -1)
      errexit(10,"af_sortset");
    break;
  case 9 :
    if ((af_sortset(set,AF_ATTLOCKER)) == -1)
      errexit(10,"af_sortset");
    break;
  case 10 :
    if ((af_sortset(set,AF_ATTOWNER)) == -1)
      errexit(10,"af_sortset");
  default :
    if ((af_sortset(set,name)) == -1)
      errexit(10,"af_sortset");
  }

if (nrofkeys == 1)
  {
    return (TRUE);
  }
else
  {
    if (nrofkeys == 0)
      {
	return (FALSE);
      }
  }

cur_pos = (nrofkeys - 1);
match = TRUE;

if ((err = af_setgkey(set, cur_pos, &cur_key)) == -1)
  errexit(10, "af_setgkey");
if (af_gattrs(&cur_key, &max_attrbuf) == -1)
  errexit(10, "af_gattrs");
cur_pos--;

if (attr_type >= STD_ATTRS)  /* if looking for udattrs  */
/* name has to be found in list of udattrs     */
  {
    udattr_pos = 0;
    found = FALSE;
/* find name in list of udattrs */
    while ((!(found)) && (udattr_pos < AF_MAXUDAS) &&
	   (max_attrbuf.af_udattrs[udattr_pos] != NIL))
      {
	(void) strcpy(val1, max_attrbuf.af_udattrs[udattr_pos]);
	if ((val2 = index(val1, '=')) == 0)
	  errexit(10, "attrmax");
	val2[0] = '\0';
	if (strcmp(name, val1) != 0)
	  udattr_pos++;
	else
	  found = TRUE;
      }
/* name should be found now */
    if (!(found))
      errexit(10, "attrmax");
  }

while ((cur_pos >= 0) && match)
  {
    /* ??????? Why does this happen here ??????????? */
    if ((err = af_setgkey(set, cur_pos, &cur_key)) == -1)
      errexit(10, "af_setgkey");
    
    if (af_gattrs(&cur_key, &cur_attrbuf) == -1)
      errexit(10, "af_gattrs");

    switch (attr_type)
      {
      case 0 :
	if (cur_attrbuf.af_gen == max_attrbuf.af_gen)
	  cur_pos--;
	else
	  match = FALSE;
	break;
      case 1 :
	if (cur_attrbuf.af_rev == max_attrbuf.af_rev)
	  cur_pos--;
	else
	  match = FALSE;
	break;
      case 2 :
	if (cur_attrbuf.af_state == max_attrbuf.af_state)
	  cur_pos--;
	else
	  match = FALSE;
	break;
      case 3 :
	if(!strcmp(cur_attrbuf.af_author.af_username,max_attrbuf.af_author.af_username))
	  cur_pos--;
	else
	  match = FALSE;
	break;
      case 4 :
	errexit(10,"group id");
	break;
      case 5 :
	if ((cur_attrbuf.af_gen == max_attrbuf.af_gen) &&
	    (cur_attrbuf.af_rev == max_attrbuf.af_rev))
	  cur_pos--;
	else
	  match = FALSE;
	break;
      case 7 :
	if ((strcmp(cur_attrbuf.af_syspath,value)) == 0)
	  cur_pos--;
	else
	  match = FALSE;
	break;
      case 8 :
	if ((strcmp(cur_attrbuf.af_host,value)) == 0)
	  cur_pos--;
	else
	  match = FALSE;
	break;
      case 9 :
	if (!strcmp(cur_attrbuf.af_locker.af_username,max_attrbuf.af_locker.af_username))
	  cur_pos--;
	else
	  match = FALSE;
	break;
      case 10 :
	if (!strcmp(cur_attrbuf.af_owner.af_username,max_attrbuf.af_owner.af_username))
	  cur_pos--;
	else
	  match = FALSE;
	break;
      default :
/* af_udattrs must contain a '=', even if they don't contain a value */
/* currently only the first value (if existing) in the string is     */
/* considered */
	i = 0;
	found = FALSE;
/* find name in list of udattrs */
	while ((!(found)) && (i < AF_MAXUDAS) &&
	       (cur_attrbuf.af_udattrs[i] != NIL))
	  {
	    (void) strcpy(val1, cur_attrbuf.af_udattrs[i]);
	    if ((val2 = index(val1, '=')) == 0)
	      errexit(10, "attrle");
	    val2[0] = '\0';
	    if (strcmp(name, val1) != 0)
	      i++;
	    else
	      found = TRUE;
	  }
/* name should be found now */
	if (!(found))
	  errexit(10, "attrmax");

/* value comparison */
	if (strcmp(cur_attrbuf.af_udattrs[i], 
		   max_attrbuf.af_udattrs[udattr_pos]) != 0)
	  match = FALSE;
	else
	  cur_pos--;
     
      }
    if(cur_attrbuf.af_udattrs[0] != NIL)
      free(cur_attrbuf.af_udattrs[0]);
  }

/* remove keys from set if necessary */
i = cur_pos + 1;
while (i > 0)
  {
    if (af_setposrmkey(set, 0) == -1)
      errexit(10, "af_setposrmkey");
    i--;
  }
if(max_attrbuf.af_udattrs[0] != NIL)
  free(max_attrbuf.af_udattrs[0]);

return (TRUE);

}

Bool attrmin(name, value, set)
     char *name;
     char *value;
     Af_set *set;
{
int attr_type, nrofkeys;
register int cur_pos, i;
int udattr_pos;

Af_key cur_key;

Af_attrs cur_attrbuf, max_attrbuf;

Bool match, found;

char val1[256];
char *val2;

attr_type = get_attr_type(name);

if ((nrofkeys = af_nrofkeys(set)) == -1)
  errexit(10, "af_nrofkeys");

if (nrofkeys == 1)
  {
    return (TRUE);
  }

switch (attr_type)
  {
  case 0 :
    if ((af_sortset(set,AF_ATTGEN)) == -1)
      errexit(10,"af_sortset");
    break;
  case 1 :
    if ((af_sortset(set,AF_ATTREV)) == -1)
      errexit(10,"af_sortset");
    break;
  case 2 :
    if ((af_sortset(set,AF_ATTSTATE)) == -1)
      errexit(10,"af_sortset");
    break;
  case 3 :
    if ((af_sortset(set,AF_ATTAUTHOR)) == -1)
      errexit(10,"af_sortset");
    break;
  case 4 :
    errexit(10,"group id");
    break;
  case 5 :
    if ((af_sortset(set,AF_ATTVERSION)) == -1)
      errexit(10,"af_sortset");
    break;
  case 7:
    if ((af_sortset(set,AF_ATTSPATH)) == -1)
      errexit(10,"af_sortset");
    break;
  case 8:
    if ((af_sortset(set,AF_ATTHOST)) == -1)
      errexit(10,"af_sortset");
    break;
  case 9 :
    if ((af_sortset(set,AF_ATTLOCKER)) == -1)
      errexit(10,"af_sortset");
    break;
  case 10 :
    if ((af_sortset(set,AF_ATTOWNER)) == -1)
      errexit(10,"af_sortset");
  default :
    if ((af_sortset(set,name)) == -1)
      errexit(10,"af_sortset");
  }

cur_pos = (0);
match = TRUE;

if ((err = af_setgkey(set, cur_pos, &cur_key)) == -1)
  errexit(10, "af_setgkey");
if (af_gattrs(&cur_key, &max_attrbuf) == -1)
  errexit(10, "af_gattrs");
cur_pos++;

if (attr_type >= STD_ATTRS)  /* if looking for udattrs  */
/* name has to be found in list of udattrs     */
  {
    udattr_pos = 0;
    found = FALSE;
/* find name in list of udattrs */
    while ((!(found)) && (udattr_pos < AF_MAXUDAS) &&
	   (max_attrbuf.af_udattrs[udattr_pos] != NIL))
      {
	(void) strcpy(val1, max_attrbuf.af_udattrs[udattr_pos]);
	if ((val2 = index(val1, '=')) == 0)
	  errexit(10, "attrmin");
	val2[0] = '\0';
	if (strcmp(name, val1) != 0)
	  udattr_pos++;
	else
	  found = TRUE;
      }
/* name should be found now */
    if (!(found))
      errexit(10, "attrmin");
  }

while ((cur_pos < nrofkeys) && match)
  {
    if ((err = af_setgkey(set, cur_pos, &cur_key)) == -1)
      errexit(10, "af_setgkey");
    
    if (af_gattrs(&cur_key, &cur_attrbuf) == -1)
      errexit(10, "af_gattrs");

    switch (attr_type)
      {
      case 0 :
	if (cur_attrbuf.af_gen == max_attrbuf.af_gen)
	  cur_pos++;
	else
	  match = FALSE;
	break;
      case 1 :
	if (cur_attrbuf.af_rev == max_attrbuf.af_rev)
	  cur_pos++;
	else
	  match = FALSE;
	break;
      case 2 :
	if (cur_attrbuf.af_state == max_attrbuf.af_state)
	  cur_pos++;
	else
	  match = FALSE;
	break;
      case 3 :
	if (!strcmp(cur_attrbuf.af_author.af_username,max_attrbuf.af_author.af_username))
	  cur_pos++;
	else
	  match = FALSE;
	break;
      case 4 :
	errexit(10,"group id");
	break;
      case 5 :
	if ((cur_attrbuf.af_gen == max_attrbuf.af_gen) &&
	    (cur_attrbuf.af_rev == max_attrbuf.af_rev))
	  cur_pos++;
	else
	  match = FALSE;
	break;
      case 7 :
	if ((strcmp(cur_attrbuf.af_syspath,value)) == 0)
	  cur_pos++;
	else
	  match = FALSE;
	break;
      case 8 :
	if ((strcmp(cur_attrbuf.af_host,value)) == 0)
	  cur_pos++;
	else
	  match = FALSE;
	break;
      case 9 :
	if (!strcmp(cur_attrbuf.af_locker.af_username,max_attrbuf.af_locker.af_username))
	  cur_pos++;
	else
	  match = FALSE;
	break;
      case 10 :
	if (!strcmp(cur_attrbuf.af_owner.af_username,max_attrbuf.af_owner.af_username))
	  cur_pos++;
	else
	  match = FALSE;
	break;
      default :
/* af_udattrs must contain a '=', even if they don't contain a value */
/* currently only the first value (if existing) in the string is     */
/* considered */
	i = 0;
	found = FALSE;
/* find name in list of udattrs */
	while ((!(found)) && (i < AF_MAXUDAS) &&
	       (cur_attrbuf.af_udattrs[i] != NIL))
	  {
	    (void) strcpy(val1, cur_attrbuf.af_udattrs[i]);
	    if ((val2 = index(val1, '=')) == 0)
	      errexit(10, "attrle");
	    val2[0] = '\0';
	    if (strcmp(name, val1) != 0)
	      i++;
	    else
	      found = TRUE;
	  }	
/* name should be found now */
	if (!(found))
	  errexit(10, "attrmax");

/* value comparison */
	if (strcmp(cur_attrbuf.af_udattrs[i], 
		   max_attrbuf.af_udattrs[udattr_pos]) != 0)
	  match = FALSE;
	else
	  cur_pos++;
     
      }
    if(cur_attrbuf.af_udattrs[0] != NIL)
      free(cur_attrbuf.af_udattrs[0]);
  }

/* remove keys from set if necessary */
while (cur_pos < nrofkeys)
  {
    if (af_setposrmkey(set, cur_pos) == -1)
      errexit(10, "af_setposrmkey");
    nrofkeys--;
  }
if(max_attrbuf.af_udattrs[0] != NIL)
  free(max_attrbuf.af_udattrs[0]);

return (TRUE);

}


Bool getfromcid()
{
/* not yet implemented */
;
}

Bool attrvar(name, value, set)
     char *name;
     /*ARGSUSED*/
     char *value;
     Af_set *set;
{
/* set variant path & variant flags */
register int k = 0, i = 0;
register char *ind;
char pathlist[256];

if (check_vclass(name) != TRUE)
  errexit(30,name);

while (variantDefs[k].name)
  {
    if (strcmp (variantDefs[k].name, name) != 0)
      k++;
    else
      {
	while (curvpath[i] != NIL)
	  i++;
	if (variantDefs[k].vpath != NIL)
	  {
	    (void) strcpy (pathlist, variantDefs[k].vpath);
	
	    while(( ind = index(pathlist,':')) != NIL)
	      {
		*ind = '\0';
		if((pathlist[0] == '.') && (pathlist[1] == '.')) {
		  if((curvpath[i] = malloc((unsigned) (strlen(prev_dir) + sizeof(char)))) == NIL)
		    errexit(10,"malloc");
		  (void) strcpy(curvpath[i],prev_dir);
		}
		else {
		  if ((curvpath[i] = malloc((unsigned) (strlen(pathlist) + sizeof(char)))) == NIL)
		  errexit(10,"malloc");
		(void) strcpy(curvpath[i],pathlist);
		}
		ind++;
		(void) strcpy(pathlist,ind);
		i++;
	      }
	    if((pathlist[0] == '.') && (pathlist[1] == '.')) {
	      if((curvpath[i] = malloc((unsigned) (strlen(prev_dir) + sizeof(char)))) == NIL)
		errexit(10,"malloc");
	      (void) strcpy(curvpath[i],prev_dir);
	    }
	    else {
	      if ((curvpath[i] = malloc((unsigned) (strlen(pathlist) + sizeof(char)))) == NIL)
		errexit(10,"malloc");
	      (void) strcpy(curvpath[i],pathlist);
	    }
	  }
	break;
      }
  }

if (variantDefs[k].name)
  {
    if (strcmp(variantDefs[k].name, name) == 0)
      return (TRUE);
  }
else
  errexit(19,name);
/*NOTREACHED*/
return (FALSE);
}



char *replace(patt)
     char *patt;
{

/* converts shell-like pattern to ex-like pattern */
/* not yet complete ???? */
/* a{bc,d,e}f mactches abcf adf & aef not implemented */
  register  int i,j;
  static char result[128];
  char tmp_result[64];

  j = 0;
  
  for(i = 0; i < strlen(patt); i++)
    {
      switch (patt[i])
	{
	case '?':
	  tmp_result[j++]='.';
	  break;
	case '*':
	  tmp_result[j++]='.';
  	  tmp_result[j++]='*'; 
	  break;
	case '.':
	  tmp_result[j++]='\\';
	  tmp_result[j++]='.';
	  break;
	default:
	  tmp_result[j++]=patt[i];
      }
  }
tmp_result[j]='\0';
(void) sprintf(result,"^%s$\0",tmp_result);
return(result);
}

