/* $__copyright$ */
#ifndef lint
static char *AtFSid = "$Header: error.c[1.23] Mon Apr  6 22:03:21 1992 axel@cs.tu-berlin.de accessed $";
#endif

#include <stdio.h>
#include "shape.h"

extern int cleanup_links();
extern struct linkreg *link_reg;
extern int af_cleanup();
extern char cfname[];

int errexit(err, mess)
     int err;
     char *mess;
{
if (err != 14)
  {
    cleanup_links(link_reg);
    af_cleanup();
  }
if (confid)
  {
    fprintf(stderr, "shape - error during building confid!\n");
    (void) strcat(cfname,".cid");
    fprintf(stderr, "shape - unlinking incomplete confid %s\n", cfname);
    (void) fclose(cid);
    (void) unlink(cfname);
  }

switch (err)
  {
  case 1: /* ???? */
    fprintf(stderr, "shape - multiple defined action for: %s\n", mess);
    exit(1);
  case 2:
    fprintf(stderr, "shape - unknown option: %s\n", mess);
    exit(1);
  case 3:
    if (!strcmp(mess,"love"))
      {
	fprintf(stderr,"Oh, what was it?");
	sleep(2);
	fprintf(stderr," .");
	sleep(2);
	fprintf(stderr,".");
	sleep(2);
	fprintf(stderr,". ");
	fprintf(stderr,"I should remember it");
	sleep(2);
	fprintf(stderr," .");
	sleep(2);
	fprintf(stderr,".");
	sleep(2);
	fprintf(stderr,". ");
	fprintf(stderr,"memory fault. coeur dumped.");
	exit(1);
      }

    if (!strcmp(mess,"future"))
      {
	fprintf(stderr,"Let me think ");
	sleep(2);
	fprintf(stderr,".");
	sleep(2);
	fprintf(stderr,".");
	sleep(2);
	fprintf(stderr,".");
	sleep(2);
	fprintf(stderr," No future ");
	sleep(2);
	fprintf(stderr,".");
	sleep(2);
	fprintf(stderr,".");
	sleep(2);
	fprintf(stderr,".");
	sleep(2);
	fprintf(stderr," definitely!!!\n");
	exit(1);
      }

    if (!strcmp(mess,"me"))
      {
	fprintf(stderr,"shape - don't know how to shape you\n");
	exit(1);
      }

    if (!strcmp(mess,"you"))
      {
	fprintf(stderr,"shape yourself!\n");
	exit(1);
      }

    if (!strcmp(mess,"god"))
      {
	fprintf(stderr,"Don't know how to shave God\n");
	exit(1);
      }
    if (!strcmp(mess,"the queen"))
      {
	fprintf(stderr,"Don't know how to shave the queen\n");
	exit(1);
      }
    fprintf(stderr, "shape - don't know how to shape - %s\n", mess);
    exit(1);
  case 4:
    fprintf(stderr, "shape - unknown special macro in cmd: %s\n", mess);
    exit(1);
  case 5:
    fprintf(stderr, "shape - multiply defined selection rule: %s\n", mess);
    exit(1);
  case 6:
    fprintf(stderr, "shape - unknown standard predicate: %s\n", mess);
    exit(1);
  case 7:
    fprintf(stderr, "shape - error in variant section %s\n", mess);
    exit(1);
  case 8:
    fprintf(stderr, "shape - file not found: %s\n", mess);
    exit(1);
  case 9:
    fprintf(stderr, "shape - invalid gen/rev specification: %s\n", mess);
    exit(1);
  case 10:
    fprintf(stderr, "shape - error in: %s\n",mess);
    if ((af_errno != 0) && (strcmp("malloc",mess)))
      af_perror("AtFS reports");
    exit(1);
  case 11:
    fprintf(stderr, "shape - no description file and no arguments\n");
    exit(1);
  case 12:
    fprintf(stderr, "shape - cannot open file: %s\n", mess);
    exit(1);
  case 13:
    fprintf(stderr, "shape - error during execution; retcode: %s\n", mess);
    exit(1);
  case 14:
    fprintf(stderr, "shape - syntax error: %s\n", mess);
    break;
  case 15:
    fprintf(stderr, "shape - aborted due to syntactical error(s)\n");
    exit(1);
  case 16:
    fprintf(stderr, "shape - invalid state: %s\n", mess);
    exit(1);
  case 17:
    fprintf(stderr, "shape - couldn't find appropriate version of %s.\n", mess);
    exit(1);
  case 18:
    /* not used */
    fprintf(stderr, "shape - aborted!!!\n", mess);
    exit(1);
  case 19:
    fprintf(stderr, "shape - variant name not defined: %s\n", mess);
    exit(1);
  case 20:
    fprintf(stderr, "shape - can't link %s\n", mess);
    exit(1);
  case 21:
    fprintf(stderr, "shape - can't unlink %s\n", mess);
    exit(1);
  case 22:
    fprintf(stderr, "shape - can't link %s to tmpfile\n", mess);
    exit(1);
  case 23:
    fprintf(stderr, "shape - interrupted \n");
    exit(1);
  case 24:
    fprintf(stderr, "shape - can't open include file: %s\n", mess);
    exit(1);
  case 25:
    fprintf(stderr, "shape - infinitely recursive macro caused by line: %s?\n", mess);
    exit(1);
  case 26:
    fprintf(stderr, "shape - invalid macrocitation within heritage field: %s\n",mess);
    exit(1);
  case 27:
    fprintf(stderr, "shape - too many %s\n", mess);
    exit(1);
  case 28:
    fprintf(stderr, "shape - forced stop :-(; couldn't find appropriate version for: %s\n", mess);
    exit(1);
  case 29:
    fprintf(stderr, "shape - attribute too long\n");
    exit(1);
  case 30:
    fprintf(stderr, "shape - invalid combination of variants (vclass error): %s\n", mess);
    exit(1);
  case 31:
    fprintf(stderr, "shape - syntax error in rule section (delimiter missing)\n");
    exit(1);
  case 32:
    fprintf(stderr, "shape - unknown selection rule name: %s\n", mess);
    exit(1);
  case 33:
    fprintf(stderr, "shape - multiply defined variant name: %s\n", mess);
    exit(1);
  case 34:
    fprintf(stderr, "shape - choose -expandall *or* -expandnothing!\n");
    exit(1);
  case 35:
    fprintf(stderr, "shape - argument %s for -confid is no target name\n",mess);
    exit(1);
  case 36:
    fprintf(stderr, "shape - too many arguments for -force\n");
    exit(1);
  case 37:
    fprintf(stderr, "shape - too many variant definitions\n");
    exit(1);
  case 38:
    fprintf(stderr, "shape - bad delimiter in rule section: %s\n", mess);
    exit(1);
  case 39:
    fprintf(stderr, "shape - multiply defined variant class: %s\n", mess);
    exit(1);
  case 99:
    fprintf(stderr, "shape - not yet implemented: %s\n", mess);
    exit(1);
  default:
    fprintf(stderr, "shape - impossible error\n");
    exit(1);
  }
}


logerr(string)
     char *string;
{
  errexit(10,string);
}

void warning(no,mess)
     int no;
     char *mess;
{
  switch (no)
    {
    case 1:
      fprintf(stderr,"shape - warning: derived object not saved into derived object cache; no AtFS subdirectory\n");
      return;
    case 2:
      fprintf(stderr,"shape - warning: target `%s' not remade because of errors\n", mess);
      return;
    case 3:
      fprintf(stderr,"shape - warning: defining macros via command line may cause the rebuilding of a different system than described in confid\n");
      return;
    case 4:
      fprintf(stderr,"shape - warning: no AtFS subdirectory\n");
      return;
    case 5:
      fprintf(stderr,"shape - warning: environment variable ATFSBPSIZ = 0?\n");
      return;
    case 6:
      fprintf(stderr,"shape - warning: DOC attribute space overflow.\n");
      return;
    case 7:
      fprintf (stderr, "shape - warning: inifinte loop: target `%s' depends on itself.\n", mess);
      return;
    default:
      fprintf (stderr, "%s.\n", mess);
      return;
    }
}
