/* $__copyright$ */
#ifndef lint
static char *AtFSid = "$Header: misc.c[1.32] Mon Apr  6 22:03:51 1992 axel@cs.tu-berlin.de accessed $";
#endif

#include "shape.h"

extern char *forcelist[];
extern Bool is_in_forcelist();
extern int depth;
extern int af_cleanup(), re_exec();
extern char *expandmacro(), *re_comp();

/* Struct for registering links */
struct linkreg *link_reg = (struct linkreg *) NIL;
struct linkreg *last_link;

char *longattrs[MAXDEPTH];

char *types[] = { "generation",          /*  0  int */
		  "revision",            /*  1  int */
		  "state",               /*  2  short */
		  "author",              /*  3  short */
		  "group",               /*  4  short */
		  "version",             /*  5  char * */
		  "variant",             /*  6  char * */
		  "syspath",             /*  7  char * */
		  "host",                /*  8  char * */
		  "locker",              /*  9  char * */
		  "owner",               /* 10  char * */
		  "0"};                  /* 99  default = char *
					    (for userdefined attributes */


char *states[] = { "busy",
		   "saved",
		   "proposed",
		   "published",
		   "accessed",
		   "frozen",
		   "0"};
  

int get_attr_type(name)
     char *name;
{
  register int i = 0;

  if (name == NIL)
    return(99);

  while(strcmp(types[i],"0") != 0)
    {
      if((strcmp(types[i],name) == 0))
	return(i);
      i++;
    }
  return(99);
}

int get_state_no(state)
     char *state;
{
  int i = 0;
  while(strcmp(states[i],"0") != 0)
    {
      if((strcmp(states[i],state) == 0))
	return(i);
      i++;
    }
  return(99);
}


struct linkreg *init_linkreg()
{
  register struct linkreg *lreg = (struct linkreg *) NIL;

  if ((lreg = (struct linkreg *) malloc(sizeof(struct linkreg))) ==
      (struct linkreg *) NIL)
    errexit(10,"malloc");
  if((lreg->fn = malloc(MYMAXNAMLEN)) == NIL)
    errexit(10,"malloc");
  if((lreg->newfn = malloc(MYMAXNAMLEN)) == NIL)
    errexit(10,"malloc");
  lreg->fn[0] = '\0';
  lreg->newfn[0] = '\0';
  lreg->next = (struct linkreg *) NIL;

  return(lreg);
}


register_link (fn, newfn, busy_exist)
     char *fn;
     char *newfn;
     Bool busy_exist;
{
  if (link_reg == (struct linkreg *) NIL)
    {
      link_reg = init_linkreg();
      (void) strcpy(link_reg->fn, fn);
      (void) strcpy(link_reg->newfn, newfn);
      link_reg->busy_exist = busy_exist;
      last_link = link_reg;
    }
  else
    {
      last_link->next = init_linkreg();
      last_link = last_link->next;
      (void) strcpy(last_link->fn, fn);
      (void) strcpy(last_link->newfn, newfn);
      last_link->busy_exist = busy_exist;
    }
}

cleanup_links (cur_link)
     struct linkreg *cur_link;
{
  if(cur_link != (struct linkreg *) NIL)
    {
      cleanup_links(cur_link->next);
    }

  if(cur_link != (struct linkreg *) NIL)
    {
      if (unlink(cur_link->fn) != 0)
	{
	  fprintf(stderr, "shape - warning: can't unlink temporarily restored version %s\n");
	}
      if (cur_link->busy_exist)
	{
	  if (link (cur_link->newfn, cur_link->fn) != 0)
	    {
	      fprintf(stderr, "shape - warning: can't restore original busy version of %s\n",
		      cur_link->fn);
	      fprintf(stderr, "\t\t original file available as %s !\n", cur_link->newfn);
	    }
	  else
	    {
	      if (unlink(cur_link->newfn) != 0)
		fprintf(stderr, "shape - warning: can't unlink temporary file %s\n", cur_link->newfn);
	    }
	}
    }
}

int free_linklist()
{
/* not yet implemented */
/* should free memory of linklist */
  ;
}

int append_attrs(buf,recdepth)
     Af_attrs *buf;
     int recdepth;
{
  char attributes[1024];
  char x[MYMAXNAMLEN];
  (void) sprintf(x,"%s%s%s%s\0",buf->af_syspath,buf->af_name,".",buf->af_type);

  if (!strcmp(expandmacro("$(hosttype)"),"")) {
    if (!strcmp(expandmacro("$(HOSTTYPE)"),"")) {
      (void) sprintf(attributes,"%s%s%s%s%d%d%d%d\0",
		     buf->af_name,
		     ".",
		     buf->af_type,
		     buf->af_host,
		     buf->af_gen,
		     buf->af_rev,
		     buf->af_state,
		     buf->af_mtime
		     );
    }
    else {
      (void) sprintf(attributes,"%s%s%s%s%d%d%d%d\0",
		     buf->af_name,
		     ".",
		     buf->af_type,
		     expandmacro("$(HOSTTYPE)"),
		     buf->af_gen,
		     buf->af_rev,
		     buf->af_state,
		     buf->af_mtime
		     );
    }
  }
  else {
    (void) sprintf(attributes,"%s%s%s%s%d%d%d%d\0",
		   buf->af_name,
		   ".",
		   buf->af_type,
		   expandmacro("$(hosttype)"),
		   buf->af_gen,
		   buf->af_rev,
		   buf->af_state,
		   buf->af_mtime
		   );
  }
  
  if((longattrs[recdepth] = realloc(longattrs[recdepth],
				    (unsigned)(strlen(attributes)
				    + strlen(longattrs[recdepth])
				    + sizeof(char)))) == NIL)
    errexit(10,"realloc");
  (void) strcat(longattrs[recdepth],attributes);
}

append_derived_attr(targname,recdepth)
     /*ARGSUSED*/
     char *targname;
     int recdepth;
{
  char *attr_val;
  Af_key testkey;
  Af_attrs testbuf;
  register int testi = 0;
  Bool has_attr = FALSE;

  if(targname[0] != '/')
    {
      char keypath[MAXPATHLEN], *afpath ;
      
      (void) strcpy(keypath, curvpath[0]) ;
      afpath = af_afpath(targname) ;
				/* absolute path ? */
      if (afpath[0] == '/') {
	  (void) strcpy(keypath, afpath) ;
      } else {
				/* relative path? */
	  (void) strcat(keypath, afpath[0] ? "/" : "") ;
	  (void) strcat(keypath, afpath) ;
      }

      if(af_getkey(keypath, af_afname(targname), af_aftype(targname),
		   AF_BUSYVERS, AF_BUSYVERS, &testkey) == -1)
	errexit(10,"af_getkey");
    }
  else
    {
      if(af_getkey(af_afpath(targname) ,af_afname(targname),
		   af_aftype(targname), AF_BUSYVERS, AF_BUSYVERS,
		   &testkey) == -1)
	errexit(10,"af_getkey");
    }

  if(af_gattrs(&testkey,&testbuf) == -1)
    errexit(10,"af_gattrs");
  while(testbuf.af_udattrs[testi] != NIL)
    {
      if(!strncmp(testbuf.af_udattrs[testi],ATTRNAME, 
		  strlen (ATTRNAME)))
	{
	  has_attr = TRUE;
	  break;
	}
      testi++;
    }
  
  if((af_dropkey(&testkey)) == -1)
    errexit(10,"af_dropkey");

  if(!has_attr)
    {
      if(testbuf.af_udattrs[0])
	free(testbuf.af_udattrs[0]);
      return(0);
    }
  if((attr_val = malloc((unsigned)
			(strlen(longattrs[recdepth]) + sizeof(char)))) == NIL)
    errexit(10,"malloc");

  (void) strcpy(attr_val,longattrs[recdepth]);
  free(longattrs[recdepth]);
  if ((longattrs[recdepth] = malloc((unsigned)
				    strlen(attr_val) +
				    strlen(testbuf.af_udattrs[testi]) +
				    10 + 15 + sizeof(char))) == NIL)
    errexit(10,"malloc");

  (void)sprintf(longattrs[recdepth], "--&--%d", testbuf.af_mtime);
  (void) strcat(longattrs[recdepth], attr_val);

  if(testbuf.af_udattrs[0])
    free(testbuf.af_udattrs[0]);
  free(attr_val);
  return(0);
}


Bool is_in_forcelist(name,type)
     char *name;
     char *type;
{
  char fullname[MYMAXNAMLEN];
  register int i = 0;
  fullname[0] = '\0';
  (void) strcpy(fullname,name);
  if(type != NIL) {
    if(strcmp(type,"")) {
      (void) strcat(fullname,".");
      (void) strcat(fullname,type);
    }
  }

  while(forcelist[i] != NIL) {
    if (!strcmp(forcelist[i],fullname))
      return(TRUE);
    i++;
  }
  return(FALSE);
}

D_debug(name,type,at)
     /*ARGSUSED*/
     char *name, *type, *at;
{
  printf("shape - %s does not bear the appropriate attributes or does not exist\n", name);
  return(0);
}


cat_retrvattr(ret,att)
     char *ret;
     char *att;
{
  register char *p1, *p2;

  p1 = att;
  p2 = ret + 10;

  while(*p1 != '\000')
    {
      if((*(p1) == '-') && (*(p1+1) == '-') && (*(p1+2) == '&') &&
	 (*(p1+3) == '-') && (*(p1+4) == '-'))
	p1 = p1 +14;
      else
	{
	  *p2 = *p1;
	  p1++;
	  p2++;
	}
    }
  *p2 = '\000';
}	    
