/* Copyright (C) 1989,1990,1991,1992 by
	Wilfried Koch, Andreas Lampen, Axel Mahler, Juergen Nickelsen,
	Wolfgang Obst and Ulrich Pralle
 
 This file is part of shapeTools.

 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with shapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
#ifndef lint
static char *AtFSid = "$Header: vadm_reserve.c[3.28] Wed Feb 12 20:47:15 1992 axel@cs.tu-berlin.de accessed $";
#ifdef CFFLGS
static char *ConfFlg = CFFLGS;
	/* should be defined from within Makefile */
#endif
#endif

#include <stdio.h>
#include <atfs.h>
#include <atfsapp.h>

#include "vadm.h"
/* #include "locks.h" now in afsapp.h */

/* externals */
extern char *malloc(), *gethostname();
extern int newmode;
extern Af_user newauthor;
extern int def_vnum;
extern unsigned int options;
extern struct Transaction ThisTransaction;

/* forward */
char *uidname ();

/* locals */
static char buf[MSGLEN];

/**/
Uid_t af_MY_rouid (key) Af_key *key; {
  /*
   *  This function returns the userid of the owner of the AtFS directory
   *  containing the AtFS object identified by key.
   */
  char path[MAXPATHLEN+1];
  struct stat statbuf;

  (void)strcpy (path, af_rsyspath (key));
  if (strcmp (path, "/") == NULL)
    (void)strcpy (path, "");
  (void)strcat (path, "/AtFS");
  if (stat (path, &statbuf) < 0) {
    *rindex (path, '/') = '\0';
    (void)strcat (path, "/AFS");
    if (stat (path, &statbuf) < 0) {
      perror (path);
      return -1;
    }
  }
  return statbuf.st_uid;
}

int do_reserve (set)
     Af_set *set;
{
  register int i;
  Af_user *locker;
  int errs = 0;
  char version[MAXPATHLEN+1], *fn, *mkfn(), *p, *lockerid();
  struct stat sbuf;

  if (af_sortset (set, AF_ATTHUMAN) == -1)
    vctl_abort ("do_reserve: af_sortset()");
      
  for (i = 0; i < set->af_nkeys; i++) {
    mkvstring (version, &set->af_klist[i]);
    if (setjmp (ThisTransaction.tr_env)) continue;
    if (af_rstate (&set->af_klist[i]) == AF_BUSY)
      if (p=rindex(version, '[')) *p = '\0';
    
    if ((!locked(locker = vc_testlock (&set->af_klist[i])))) {
      if (af_rstate (&set->af_klist[i]) == AF_BUSY)
	logmsg ("WARNING! Subsequent locking may lose attribute citations.");
      if (!(vc_lock (&set->af_klist[i], (Uid_t)geteuid()))) {
	af_perror ("af_lock");
	continue;
      }
      else {
	char *intent, *getintent();
	if (!IsOptionSet (Vopt_quiet)) {
	  intent = getintent ("Describe intended changes ?", (char *)NULL,
			      IsOptionSet(Vopt_stdin), 
			      mkfn (&set->af_klist[i]));
	}
	else intent = (char *)NULL;
	if (intent) {
	  char *intattr, *todaystr = af_asctime(), *c, *is; 
	  /* af_asctime is an unofficial AtFS-function -- should be public */
	  
	  if (c = rindex (todaystr, '\n')) *c = '\0';
	  
	  intattr = malloc ((unsigned)(strlen (intent) + strlen (todaystr) +
				       strlen (INTENT) + 3 + 1));
	  if (intattr == (char *) NULL)
	    vctl_abort("Can't malloc");
	  is = malloc ((unsigned)(strlen(INTENT)+1));
	  if (is) {
	    strcpy (is, INTENT);
	    c = index (is, '=');
	    *c = '\0';
	    (void)sprintf (intattr, "%s=[%s] %s%s", is, todaystr, ++c, 
			   intent);
	    free (is);
	  }
	  else
	    (void)sprintf (intattr, "%s%s", INTENT, intent);
	  
	  if (fail(af_sudattr (&set->af_klist[i], AF_REPLACE, intattr)) &&
	      fail(af_sudattr (&set->af_klist[i] , AF_ADD, intattr))) {
	    (void)sprintf (buf, "Can't set change intent for %s.", version);
	    af_perror (buf);
	    free (intattr);
	  }
	}
	(void)sprintf (buf, "%s reserved.", version);
	fn = mkfn (&set->af_klist[i]);
	if (stat (fn, &sbuf) == 0) {
	  (void)chmod (fn, (int)(sbuf.st_mode | 0200));
	}
	logmsg (buf);
      }
    }
    else { /* testlock returned something */
      if (lockeruid(locker) != (Uid_t)geteuid()) {
	(void)sprintf (buf, "%s is already locked by %s.", version, 
		 lockerid (locker));
	logmsg (buf);
	errs++;
	continue;
      }
      else {
	(void)sprintf (buf, "%s reserved.", version);
	fn = mkfn (&set->af_klist[i]);
	if (stat (fn, &sbuf) == 0) {
	  (void)chmod (fn, (int)(sbuf.st_mode | 0200));
	}
	logmsg (buf);
      }
    }
  }
  return errs;
}

int do_chmod (set)
     Af_set *set;
{
  int i;
  int errs = 0;
  char version[MAXPATHLEN+1];
  
  if (af_sortset (set, AF_ATTHUMAN) == -1)
    vctl_abort ("do_chmod: af_sortset()");
      
  for (i = 0; i < set->af_nkeys; i++) {
    mkvstring (version, &set->af_klist[i]);
    if (setjmp (ThisTransaction.tr_env)) continue; 
    if (af_MY_rouid (&set->af_klist[i]) != (Uid_t)geteuid()) {
      (void)sprintf (buf, "%s not owned by %s.", version, 
	       uidname((Uid_t)geteuid()));
      logmsg (buf);
      errs++;
      continue;
    }
    else {
      if (af_chmod (&set->af_klist[i], newmode) < 0) {
	af_perror ("af_chmod");
	errs++;
	continue;
      }
      (void)sprintf (buf, "%s done.", version);
      logmsg (buf);
    }
  }
  return errs;
}

int do_chown (set)
     Af_set *set;
{
  int i;
  int errs = 0;
  char version[MAXPATHLEN+1];
  
  if (af_sortset (set, AF_ATTHUMAN) == -1)
    vctl_abort ("do_chown: af_sortset()");
      
  for (i = 0; i < set->af_nkeys; i++) {
    mkvstring (version, &set->af_klist[i]);
    if (setjmp (ThisTransaction.tr_env)) continue; 
    if (lockeruid (af_rowner (&set->af_klist[i])) != geteuid()) {
      (void)sprintf (buf, "%s not owned by %s.", version, 
	       uidname (geteuid()));
      logmsg (buf);
      errs++;
      continue;
    }
    else {
      logmsg ("This function is not available under BSD.");
      errs++;
      continue;
    }
  }
  return  errs;
}

int do_chaut (set)
     Af_set *set;
{
  int i;
  int errs = 0;
  char version[MAXPATHLEN+1];
  
  if (af_sortset (set, AF_ATTHUMAN) == -1)
    vctl_abort ("do_chaut: af_sortset()");
      
  for (i = 0; i < set->af_nkeys; i++) {
    mkvstring (version, &set->af_klist[i]);
    if (setjmp (ThisTransaction.tr_env)) continue; 
    if (af_MY_rouid (&set->af_klist[i]) != (Uid_t)geteuid()) {
      (void)sprintf (buf, "%s not owned by %s.", version, 
	       uidname ((Uid_t)geteuid()));
      logmsg (buf);
      errs++;
      continue;
    }
    else {
      if (af_chauthor (&set->af_klist[i], &newauthor) < 0) {
	af_perror ("af_chaut");
	errs++;
	continue;
      }
      (void)sprintf (buf, "%s done.", version);
      logmsg (buf);
    }
  }
  return errs;
}

/**/
DoReserve (ac, av)
     int ac;
     char **av;
{
  Af_set set;
  int errs, errput = 0;
  char **erroneous;

  errs = GetKeysByGenRev (ac,av, AF_LASTVERS, AF_LASTVERS, &set, 
			  &erroneous);

  if (errs) {
    print_erroneous (erroneous, errs);
    errput++;
  }

  if (!set.af_nkeys && !errput) {
    return 1;
  }

  if (errs && (!IsOptionSet(Vopt_quiet)) && !ask_confirm ("Continue ?", "yes"))
    return 1;

  return do_reserve (&set);
}

int do_unreserve (set)
     Af_set *set;
{
  int i;
  Af_user *locker;
  Af_attrs thisvattrs;
  int errs = 0;
  char version[MAXPATHLEN+1], hostname[MAXHOSTNAMELEN+1];
  char *p;
  FILE *pip;

  if (af_sortset (set, AF_ATTHUMAN) == -1)
    vctl_abort ("do_unreserve: af_sortset()");
  for (i = 0; i < set->af_nkeys; i++) {
    mkvstring (version, &set->af_klist[i]);
    if (setjmp (ThisTransaction.tr_env)) continue;
    /* if (locking == AF_GLOBALLOCK) { /* to be implemented */
    if (af_rstate (&set->af_klist[i]) == AF_BUSY)
      if (p=rindex(version, '['))  *p = '\0';
    if ((!locked(locker = vc_testlock (&set->af_klist[i])))) {
      (void)sprintf (buf, "%s unlocked.", version);
      logmsg (buf);
      continue;
    }
    if (lockeruid (locker) == geteuid()) {
      (void)af_initattrs (&thisvattrs);
      if (fail(af_gattrs (&set->af_klist[i], &thisvattrs))) {
	(void) sprintf (buf, "WARNING: can't get attributes of %s.", version);
	logmsg (buf);
      }
      else {
	if (af_rstate (&set->af_klist[i]) == AF_BUSY) {
	  u_short thismode = thisvattrs.af_mode;
	  thismode &= ~0222; /* clear the 'w'-bits */
	  if (fail(af_chmod (&set->af_klist[i], thismode))) {
	    (void)sprintf (buf, "WARNING: can't chmod %s.", version);
	    logmsg (buf);
	  }
	}
	(void)vc_unlock (&set->af_klist[i]);
	(void)sprintf (buf, "%s unlocked.", version);
	logmsg (buf);
	continue;
      }
    }
    else { /* locked by somebody else */
      /* The following is an evil hack. BSD doesn't allow chmod(2)
       * for ordinary user processes. 
       */
      if (af_MY_rouid (&set->af_klist[i]) == geteuid()) { 
	/* we've got the power ... */
	(void)sprintf (buf, "%s currently locked by %s. Break the lock ?", version,
		 lockerid (locker));
	if ((!IsOptionSet(Vopt_quiet)) && ask_confirm (buf, "yes")) {
	  if (vc_unlock (&set->af_klist[i]) == NULL) {
	    af_perror ("af_unlock");
	    continue;
	  }
	  if (IsOptionCleared (Vopt_nomail)) {
	    (void)sprintf (buf, "/bin/mail %s", lockerid(locker));
	    
	    if ((pip = popen (buf, "w")) == NULL) {
	      logmsg ("WARNING: couldn't notify lockholder...");
	    }
	    else {
	      (void)gethostname (hostname, MAXHOSTNAMELEN);
	      fprintf (pip, "Subject: Your lock on %s was broken by %s@%s\n", 
		       version, uidname(geteuid()), hostname);
	      fprintf (pip, "This message was issued automatically by ");
	      fprintf (pip, "the version control system.\n");
	      fprintf (pip, "Your lock on %s was broken by %s@%s.\n",
		       version, uidname(geteuid()), hostname);
	      (void)pclose (pip);
	    }
	  }
	  (void)sprintf (buf, "%s unlocked.", version);
	  logmsg (buf);
	  continue;
	}
	else { /* we don't wanna break the lock */
	  (void)sprintf (buf, "%s remains locked by %s.", version, 
		   lockerid (locker));
	  logmsg (buf);
	  continue;
	}
      }
      else { /* we cannot unlock the required version */
	(void)sprintf (buf, "%s is locked by %s.", version, lockerid (locker));
	logmsg (buf);
	errs++;
	continue;
      }
    }
  }
  return errs;
}

/**/
DoUnreserve (ac, av)
     int ac;
     char **av;
{
  Af_set set;
  int errs;
  char **erroneous;

  errs = GetKeysByGenRev (ac,av, AF_LASTVERS, AF_LASTVERS, &set, 
			  &(erroneous));

  if (errs)
    print_erroneous (erroneous, errs);

  if (!set.af_nkeys) {
    return 1;
  }

  if (errs && (!IsOptionSet(Vopt_quiet)) && !ask_confirm ("Continue ?", "yes"))
    return 1;

  return do_unreserve (&set);
}

DoChmod (vlist, ac, av)
     struct vc_vlist *vlist;
     int ac;
     char **av;
{
  Af_set set;
  int errs;
  char **erroneous;

  if (IsOptionSet(Vopt_version)) {
    errs = GetKeysByGenRev
	(ac,av, gen(def_vnum), rev(def_vnum), &set, &erroneous);
  }
  else {
    if (!(vlist->from_version_set) || !(vlist->to_version_set))
      errs = GetKeysByGenRev 
	(ac,av, AF_BUSYVERS, AF_BUSYVERS, &set, &erroneous);
    else
      errs = GetKeysByName ( ac, av, vlist, &set, &erroneous);
  }
  if (errs)
    print_erroneous (erroneous, errs);

  if (!set.af_nkeys) {
    return 1;
  }

  if (errs && (!IsOptionSet(Vopt_quiet)) && !ask_confirm ("Continue ?", "yes"))
    return 1;

  return do_chmod (&set);
}

DoChown (ac, av)
     int ac;
     char **av;
{
  Af_set set;
  int errs;
  char **erroneous;

  errs = GetKeysByGenRev (ac,av, AF_BUSYVERS, AF_BUSYVERS, &set, 
			  &erroneous);

  if (errs)
    print_erroneous (erroneous, errs);

  if (!set.af_nkeys) {
    return 1;
  }

  if (errs && (!IsOptionSet(Vopt_quiet)) && !ask_confirm ("Continue ?", "yes"))
    return 1;

  return do_chown (&set);
}

DoChaut (vlist, ac, av)
     struct vc_vlist *vlist;
     int ac;
     char **av;
{
  Af_set set;
  int errs;
  char **erroneous;

  if (IsOptionSet(Vopt_version)) {
    errs = GetKeysByGenRev
	(ac,av, gen(def_vnum), rev(def_vnum), &set, &erroneous);
  }
  else {
    if (!(vlist->from_version_set) || !(vlist->to_version_set))
      errs = GetKeysByGenRev 
	(ac,av, AF_LASTVERS, AF_LASTVERS, &set, &erroneous);
    else
      errs = GetKeysByName ( ac, av, vlist, &set, &erroneous);
  }
  if (errs)
    print_erroneous (erroneous, errs);

  if (!set.af_nkeys) {
    return 1;
  }

  if (errs && (!IsOptionSet(Vopt_quiet)) && !ask_confirm ("Continue ?", "yes"))
    return 1;

  return do_chaut (&set);
}

char *mkfn (key) Af_key *key; {
  /* construct a unix (busy-)filename for object pointed to by key */
  static char name[MAXNAMLEN+1];
  char *t;

  name[0] = '\0';
  t = af_rtype (key); t = t ? t : "";
  (void)sprintf (name, "%s%s%s", af_rname (key), t[0] ? "." : "", t);
  return name;
}

char *uidname (uid) Uid_t uid; {
  struct passwd *pwent = getpwuid ((int)uid);
  char un[80];

  if (pwent == NULL) {
    (void)sprintf (un, "somebody (uid=%d)", uid);
    return un;
  }
  else return pwent->pw_name;
}

