/*
 *  Copyright © 1993 James Farrow, University of Sydney - all rights reserved
 *
 *  9term graphics interface
 */

#include <u.h>
#include <libc.h>
#include <libg.h>
#include <frame.h>
#include <text.h>
#include <signal.h>

#define Cursor	xCursor
#define Font	xFont
#define Event	xEvent

#define	_SYS_FCNTL_	1

#include <X11/Xlib.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#undef	Cursor
#undef	Font
#undef	Event

#include "9term.h"

extern	Display	*_dpy;
extern	Widget	_toplevel;

static void	delwin(Widget, XEvent*, String*, Cardinal*);

Text		*text;		/* the main and only text buffer */

	/* too many X options */
static XrmOptionDescRec optable[] = {
	{"-s",		"*scroll",	XrmoptionNoArg,		"true"},
	{"+s",		"*scroll",	XrmoptionNoArg,		"false"},
	{"-ls",		"*login",	XrmoptionNoArg,		"true"},
	{"+ls",		"*login",	XrmoptionNoArg,		"false"},
	{"-ut",		"*utmp",	XrmoptionNoArg,		"true"},
	{"+ut",		"*utmp",	XrmoptionNoArg,		"false"},
	{"-9",		"*kbdMode",	XrmoptionNoArg,		"plan9"},
	{"-unix",	"*kbdMode",	XrmoptionNoArg,		"unix"},
	{"-label",	"*label",	XrmoptionSepArg,        (caddr_t)NULL},
};

char *fallbacks[] = {
	"*scroll: false",
	"*login: false",
	"*utmp: false",
	"*label: 9term",
	"*kbdMode: plan9",
	"*geometry: 745x364",
	NULL
};

static XtActionsRec actions[] = {
    "DeleteWindow", delwin,
};

/*
 *  X error handler.  just bomb out.
 */
static int
error_handler(Display *dpy, XErrorEvent *evp)
{
	quit(1);
}

/*
 *  X I/O error handler.  just bomb out.
 */
static int
io_error_handler(Display *dpy)
{
	quit(1);
}

/*
 *	delwin: Action proc to implement ICCCM delete_window.
 */
static void
delwin(Widget w, XEvent *event, String *params, Cardinal *n)
{
  if (w == _toplevel)
	killpg(SIGHUP);
}

/*
 *	try to extract an X resource under a variety of names
 */
static char *
get_resource(char *resource, char *class, char *rname, char *cname)
{
	char str1[256], str2[256];
	static char result[512];
	XrmValue value;
	char *str_type;

	sprintf(str1, "%s.%s", resource, rname);
	sprintf(str2, "%s.%s", class, cname);
#ifdef __alpha
	if (XrmGetResource(((_XPrivDisplay)_dpy)->db, str1, str2, &str_type, &value) == True)
#else
	if (XrmGetResource(_dpy->db, str1, str2, &str_type, &value) == True)
#endif
	{
		strncpy(result, value.addr, (int)value.size);
		return result;
	}
	return 0;
}

/*  
 *	look for X resources
 */
static void
extract_resources(char *resource, char *class, char *shargv[])
{
	char *s;
	char *new;
	Font *newfont;

	s = get_resource(resource, class, "debug", "Debug");
	if (s && strcasecmp(s, "true")) {
		XSetErrorHandler(error_handler);
		XSetIOErrorHandler(io_error_handler);
	}
	s = get_resource(resource, class, "login", "Login");
	if (s && !strcasecmp(s, "true"))
	{
		/* Change argv[0] if this is a login shell */
		new = (char *)malloc(strlen(shargv[0])+2);
		if (!new)
			error("malloc failure");
		new[0] = '-';
		strcpy(new+1, shargv[0]);
		shargv[0] = new;
	}
	s = get_resource(resource, class, "scroll", "Scroll");
	if (s && !strcasecmp(s, "true"))
		text->scrolling = 1;
	s = get_resource(resource, class, "utmp", "Utmp");
	if (s && !strcasecmp(s, "true"))
		utmpentry = 1;
	if (s = get_resource(resource, class, "label", "Label"))
	{
		XStoreName(_dpy, XtWindow(_toplevel), s);
		XSetIconName(_dpy, XtWindow(_toplevel), s);
		XFlush(_dpy);
	}
	if (s = get_resource(resource, class, "ttyModes", "TtyModes"))
		parsettymodes(UNIX, s);
	if (s = get_resource(resource, class, "p9TtyModes", "P9TTyModes"))
		parsettymodes(PLAN9, s);
	if (s = get_resource(resource, class, "kbdMode", "KbdMode"))
		if (!strcasecmp(s, "unix"))
			kbdmode = UNIX;
		else if (!strcasecmp(s, "plan9"))
			kbdmode = PLAN9;
	if (s = get_resource(resource, class, "p9font", "P9font"))
		setenv("font", s, 1);
}
/*
 *	initialize the 9term display
 */
void
init_display(int *argc, char **argv, char **shargv, char *resource)
{
	XrmDatabase	cmd;
	char		**cp;
	char		id[512];
	Atom		wm_del_win;

		/* look for X resources on command line */
	XrmInitialize();
	cmd = 0;
	XrmParseCommand(&cmd, optable, sizeof(optable)/sizeof(optable[0]),
					resource, argc, argv);

		/* use libg to initialize the display, window, & toolkit */
	xtbinit(0, resource, argc, argv, fallbacks);

		/* we're still not done with the command line */
#ifdef __alpha
	XrmMergeDatabases(cmd, &(((_XPrivDisplay)_dpy)->db));
#else
	XrmMergeDatabases(cmd, &(_dpy->db));
#endif
#ifdef DEBUG_X
	XSynchronize(_dpy, True);
	XSetErrorHandler(abort);
#endif
		/* export window id to environment */
	sprintf(id, "%d", XtWindow(_toplevel));
	setenv("WINDOWID", id, 1);

		/* register mouse and keyboard events */
	einit(Ekeyboard | Emouse);

		/* bind the Text ADT to the screen*/
	text = textalloc(&screen, screen.r, font);

		/* More X resource processing - why is this so complicated? */
	extract_resources(resource, "9Term", shargv);

		/* ICCCM delete_window. */
	XtAppAddActions(XtDisplayToApplicationContext(_dpy), actions, XtNumber(actions));
}
/*
 *	handle a reshape event
 */
void
ereshaped(Rectangle r)
{
	int width, height;

	if (text)
	{
		textsetrects(text, r, &screen);
		scr_get_size(&width, &height);
		tty_set_size(comm_fd, width, height);
		border(&screen, screen.r, 3, F);
		if (suspended)
			border(&screen, inset(screen.r, 1), 1, Zero);
	}
}
/*
 *	dummy mouse driver for the frame library
 */
void
frgetmouse(void)
{
	e.mouse = emouse();
}

/*
 *  Return the width and height of the screen.
 */
void
scr_get_size(int *width, int *height)
{
	*width = Dx(text->f.r) * 8 / text->f.maxtab;
	*height = text->f.maxlines;
}

/*
 *	for whom the bell tolls
 */
void
beep(void)
{
	XBell(_dpy, 50);
}
